.\" $Id: atrun.man,v 1.1 1994/05/10 18:23:08 kernel Exp $
.Dd April 12, 1995
.Dt ATRUN 8
.Os "FreeBSD 2.1"
.Sh NAME
.Nm atrun
.Nd run jobs queued for later execution
.Sh SYNOPSIS
.Nm atrun
.Op Fl l Ar load_avg
.Op Fl d
.Sh DESCRIPTION
.Nm Atrun
runs jobs queued by
.Xr at 1 .
Root's
.Xr crontab 5
file
.Pa /etc/crontab
has to contain the line
.nf
*/5     *       *       *       *       root    _ATLIB_DIR/atrun
.fi
so
.Xr atrun 8
gets called every five minutes.
.Pp
At every invocation, every job in lowercase queues whose starting time
has passed is started.
A maximum of one batch jobs (denoted by uppercase queues) are started
each time
.Nm atrun
is invoked.
.Sh OPTIONS
.Bl -tag -width indent
.It Fl l Ar load_avg
Specifies a limiting load factor, over which batch jobs should
not be run, instead of the compiled \- in value of _LOADAVG_MX.
.It Fl d
Debug; print error messages to standard error instead of using
.Xr syslog 3 .
.El
.Sh WARNINGS
For
.Nm atrun
to work, you have to start up a
.Xr cron 8
daemon.
.Sh FILES
.Bl -tag -width _ATSPOOL_DIR -compact
.It Pa _ATSPOOL_DIR
Directory containing output spool files
.It Pa _ATJOB_DIR
Directory containing job files
.El
.Sh SEE ALSO
.Xr cron 8 ,
.Xr crontab 1 ,
.Xr crontab 5 ,
.Xr at 1 ,
.Xr syslog 3 .
.Sh BUGS
The functionality of 
.Nm atrun
should be merged into
.Xr cron 8 .
