/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.impl.frontend.changes.tree;

import com.intellij.openapi.vcs.FileStatus;
import com.intellij.platform.vcs.impl.frontend.changes.UtilKt;
import com.intellij.platform.vcs.impl.frontend.shelf.tree.ChangesBrowserNodeRenderer;
import com.intellij.platform.vcs.impl.frontend.shelf.tree.EntityChangesBrowserNode;
import com.intellij.platform.vcs.impl.shared.rhizome.FilePathNodeEntity;
import com.intellij.platform.vcs.impl.shared.rhizome.NodeEntity;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.PlatformIcons;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u001c\u0010\u0014\u001a\u00020\r2\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000f\u0010\u0017\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b\u0018H\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/vcs/impl/frontend/changes/tree/FilePathTreeNode;", "Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/EntityChangesBrowserNode;", "Lcom/intellij/platform/vcs/impl/shared/rhizome/FilePathNodeEntity;", "entity", "<init>", "(Lcom/intellij/platform/vcs/impl/shared/rhizome/FilePathNodeEntity;)V", "textAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "getTextAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "textAttributes$delegate", "Lkotlin/Lazy;", "render", "", "renderer", "Lcom/intellij/platform/vcs/impl/frontend/shelf/tree/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "appendOriginText", "originText", "", "doGetTextPresentation", "Lorg/jetbrains/annotations/Nls;", "intellij.platform.vcs.impl.frontend"})
@ApiStatus.Internal
public final class FilePathTreeNode
extends EntityChangesBrowserNode<FilePathNodeEntity> {
    @NotNull
    private final Lazy textAttributes$delegate;

    public FilePathTreeNode(@NotNull FilePathNodeEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super((NodeEntity)entity);
        this.textAttributes$delegate = LazyKt.lazy(() -> FilePathTreeNode.textAttributes_delegate$lambda$0(entity));
    }

    private final SimpleTextAttributes getTextAttributes() {
        Lazy lazy = this.textAttributes$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (SimpleTextAttributes)object;
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer), (String)"renderer");
        Object t = this.getUserObject();
        Intrinsics.checkNotNullExpressionValue(t, (String)"getUserObject(...)");
        FilePathNodeEntity entity = (FilePathNodeEntity)t;
        String name = entity.getName();
        String originText = entity.getOriginText();
        if (entity.getParentPath() != null) {
            renderer.append(name, this.getTextAttributes());
            this.appendOriginText(originText, renderer);
            this.appendParentPath(renderer, entity.getParentPath());
        } else {
            renderer.append(name, this.getTextAttributes());
            this.appendOriginText(originText, renderer);
        }
        if (!this.isLeaf()) {
            this.appendCount(renderer);
        }
        renderer.setIcon(PlatformIcons.FOLDER_ICON);
    }

    private final void appendOriginText(@Nls String originText, ChangesBrowserNodeRenderer renderer) {
        if (originText != null) {
            renderer.append(FontUtil.spaceAndThinSpace() + originText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @Override
    @Nullable
    public String doGetTextPresentation() {
        return ((FilePathNodeEntity)this.getUserObject()).getName();
    }

    private static final SimpleTextAttributes textAttributes_delegate$lambda$0(FilePathNodeEntity $entity) {
        FileStatus status = UtilKt.findFileStatusById($entity.getStatus());
        return status != null ? new SimpleTextAttributes(0, status.getColor()) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }
}

