/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.pattern.PatternReplaceCharFilter;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractCharFilterFactory;
import org.opensearch.index.analysis.NormalizingCharFilterFactory;

public class PatternReplaceCharFilterFactory
extends AbstractCharFilterFactory
implements NormalizingCharFilterFactory {
    private final Pattern pattern;
    private final String replacement;

    PatternReplaceCharFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name);
        String sPattern = settings.get("pattern");
        if (!Strings.hasLength((String)sPattern)) {
            throw new IllegalArgumentException("pattern is missing for [" + name + "] char filter of type 'pattern_replace'");
        }
        this.pattern = Regex.compile((String)sPattern, (String)settings.get("flags"));
        this.replacement = settings.get("replacement", "");
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public Reader create(Reader tokenStream) {
        return new PatternReplaceCharFilter(this.pattern, this.replacement, tokenStream);
    }
}

