/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.Bytes;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.FielddataResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class FielddataRequest
extends CatRequestBase
implements ToCopyableBuilder<Builder, FielddataRequest> {
    @Nullable
    private final Bytes bytes;
    @Nonnull
    private final List<String> fields;
    public static final Endpoint<FielddataRequest, FielddataResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<FielddataRequest, FielddataResponse>(request -> "GET", request -> {
        boolean _fields = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.fields())) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_cat/fielddata";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat/fielddata/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.fields), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, FielddataResponse._DESERIALIZER);

    private FielddataRequest(Builder builder) {
        super(builder);
        this.bytes = builder.bytes;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
    }

    public static FielddataRequest of(Function<Builder, ObjectBuilder<FielddataRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    @Nonnull
    public final List<String> fields() {
        return this.fields;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.bytes != null) {
            params.put("bytes", this.bytes.jsonValue());
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.bytes);
        result = 31 * result + Objects.hashCode(this.fields);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FielddataRequest other = (FielddataRequest)o;
        return Objects.equals(this.bytes, other.bytes) && Objects.equals(this.fields, other.fields);
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, FielddataRequest> {
        @Nullable
        private Bytes bytes;
        @Nullable
        private List<String> fields;

        public Builder() {
        }

        private Builder(FielddataRequest o) {
            super(o);
            this.bytes = o.bytes;
            this.fields = Builder._listCopy(o.fields);
        }

        private Builder(Builder o) {
            super(o);
            this.bytes = o.bytes;
            this.fields = Builder._listCopy(o.fields);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        @Nonnull
        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        @Nonnull
        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        @Override
        @Nonnull
        public FielddataRequest build() {
            this._checkSingleUse();
            return new FielddataRequest(this);
        }
    }
}

