/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.enhancedclient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.IndexMetadata;
import software.amazon.awssdk.enhanced.dynamodb.KeyAttributeMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.DynamoDbEncryptionInterceptor;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.enhancedclient.CreateDynamoDbEncryptionInterceptorInput;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.enhancedclient.DynamoDbEnhancedTableEncryptionConfig;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.DynamoDbEncryptionException;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.DynamoDbTableEncryptionConfig;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.DynamoDbTablesEncryptionConfig;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoAction;
import software.amazon.cryptography.materialproviders.ICryptographicMaterialsManager;
import software.amazon.cryptography.materialproviders.IKeyring;

public class DynamoDbEnhancedClientEncryption {
    public static DynamoDbEncryptionInterceptor CreateDynamoDbEncryptionInterceptor(CreateDynamoDbEncryptionInterceptorInput input) {
        HashMap<String, DynamoDbTableEncryptionConfig> tableConfigs = new HashMap<String, DynamoDbTableEncryptionConfig>();
        input.tableEncryptionConfigs().forEach((name, config) -> tableConfigs.put((String)name, DynamoDbEnhancedClientEncryption.getTableConfig(config, name)));
        return DynamoDbEncryptionInterceptor.builder().config(DynamoDbTablesEncryptionConfig.builder().tableEncryptionConfigs(tableConfigs).build()).build();
    }

    private static Set<String> attributeNamesUsedInIndices(TableMetadata tableMetadata) {
        HashSet<String> allIndexAttributes = new HashSet<String>();
        tableMetadata.indices().stream().map(IndexMetadata::partitionKey).filter(Optional::isPresent).map(Optional::get).map(KeyAttributeMetadata::name).forEach(allIndexAttributes::add);
        tableMetadata.indices().stream().map(IndexMetadata::sortKey).filter(Optional::isPresent).map(Optional::get).map(KeyAttributeMetadata::name).forEach(allIndexAttributes::add);
        return allIndexAttributes;
    }

    private static Set<String> attributeNamesUsedInPrimaryKey(TableMetadata tableMetadata) {
        HashSet<String> keyAttributes = new HashSet<String>();
        tableMetadata.primaryKeys().stream().forEach(keyAttributes::add);
        return keyAttributes;
    }

    private static void throwUsageError(String tableName, String attributeName, String usage, String usage2) {
        throw DynamoDbEncryptionException.builder().message(String.format("Attribute %s of table %s is used as both %s and %s.", attributeName, tableName, usage, usage2)).build();
    }

    private static void validateAttributeUsage(String tableName, String attributeName, String usage, Optional<Set<String>> signOnly, Optional<Set<String>> signAndInclude, Optional<Set<String>> doNothing) {
        if (signOnly.isPresent() && signOnly.get().contains(attributeName)) {
            DynamoDbEnhancedClientEncryption.throwUsageError(tableName, attributeName, usage, "@DynamoDbEncryptionSignOnly");
        }
        if (signAndInclude.isPresent() && signAndInclude.get().contains(attributeName)) {
            DynamoDbEnhancedClientEncryption.throwUsageError(tableName, attributeName, usage, "@DynamoDbEncryptionSignAndIncludeInEncryptionContext");
        }
        if (doNothing.isPresent() && doNothing.get().contains(attributeName)) {
            DynamoDbEnhancedClientEncryption.throwUsageError(tableName, attributeName, usage, "@DynamoDbEncryptionDoNothing");
        }
    }

    private static Map<String, CryptoAction> getActionsFromSchema(String tableName, TableSchema<?> topTableSchema) {
        Set<String> signOnlyAttributes = DynamoDbEnhancedClientEncryption.getSignOnlyAttributes(topTableSchema);
        Set<String> signAndIncludeAttributes = DynamoDbEnhancedClientEncryption.getSignAndIncludeInEncryptionContextAttributes(topTableSchema);
        Set<String> doNothingAttributes = DynamoDbEnhancedClientEncryption.getDoNothingAttributes(topTableSchema);
        Set<String> keyAttributes = DynamoDbEnhancedClientEncryption.attributeNamesUsedInIndices(topTableSchema.tableMetadata());
        Set<String> tableKeys = DynamoDbEnhancedClientEncryption.attributeNamesUsedInPrimaryKey(topTableSchema.tableMetadata());
        List attributeNames = topTableSchema.attributeNames();
        HashMap<String, CryptoAction> actions = new HashMap<String, CryptoAction>();
        StringBuilder path = new StringBuilder();
        path.append(tableName).append(".");
        for (String attributeName : attributeNames) {
            if (tableKeys.contains(attributeName)) {
                if (signAndIncludeAttributes.isEmpty()) {
                    DynamoDbEnhancedClientEncryption.validateAttributeUsage(tableName, attributeName, "a primary key", Optional.empty(), Optional.of(signAndIncludeAttributes), Optional.of(doNothingAttributes));
                    actions.put(attributeName, CryptoAction.SIGN_ONLY);
                } else {
                    DynamoDbEnhancedClientEncryption.validateAttributeUsage(tableName, attributeName, "a primary key", Optional.of(signOnlyAttributes), Optional.empty(), Optional.of(doNothingAttributes));
                    actions.put(attributeName, CryptoAction.SIGN_AND_INCLUDE_IN_ENCRYPTION_CONTEXT);
                }
            } else if (signOnlyAttributes.contains(attributeName)) {
                DynamoDbEnhancedClientEncryption.validateAttributeUsage(tableName, attributeName, "@DynamoDbEncryptionSignOnly", Optional.empty(), Optional.of(signAndIncludeAttributes), Optional.of(doNothingAttributes));
                actions.put(attributeName, CryptoAction.SIGN_ONLY);
            } else if (signAndIncludeAttributes.contains(attributeName)) {
                DynamoDbEnhancedClientEncryption.validateAttributeUsage(tableName, attributeName, "@DynamoDbEncryptionSignAndIncludeInEncryptionContext", Optional.of(signOnlyAttributes), Optional.empty(), Optional.of(doNothingAttributes));
                actions.put(attributeName, CryptoAction.SIGN_AND_INCLUDE_IN_ENCRYPTION_CONTEXT);
            } else if (keyAttributes.contains(attributeName)) {
                DynamoDbEnhancedClientEncryption.validateAttributeUsage(tableName, attributeName, "an index key", Optional.empty(), Optional.of(signAndIncludeAttributes), Optional.of(doNothingAttributes));
                actions.put(attributeName, CryptoAction.SIGN_ONLY);
            } else if (doNothingAttributes.contains(attributeName)) {
                DynamoDbEnhancedClientEncryption.validateAttributeUsage(tableName, attributeName, "@DynamoDbEncryptionDoNothing", Optional.of(signOnlyAttributes), Optional.of(signAndIncludeAttributes), Optional.empty());
                actions.put(attributeName, CryptoAction.DO_NOTHING);
            } else {
                actions.put(attributeName, CryptoAction.ENCRYPT_AND_SIGN);
            }
            DynamoDbEnhancedClientEncryption.scanForIgnoredEncryptionTags(topTableSchema, attributeName, path);
        }
        return actions;
    }

    private static Map<String, CryptoAction> mergeActions(List<Map<String, CryptoAction>> actionList) {
        if (actionList.size() == 1) {
            return actionList.get(0);
        }
        HashSet<String> attributes = new HashSet<String>();
        for (Map<String, CryptoAction> config : actionList) {
            attributes.addAll(config.keySet());
        }
        HashMap<String, CryptoAction> actions = new HashMap<String, CryptoAction>();
        for (String attr : attributes) {
            Optional<Object> action = Optional.empty();
            for (Map<String, CryptoAction> config : actionList) {
                CryptoAction act = config.get(attr);
                if (act == null) continue;
                if (action.isPresent()) {
                    if (((CryptoAction)((Object)action.get())).equals((Object)act)) continue;
                    throw DynamoDbEncryptionException.builder().message(String.format("Attribute %s set to %s in one table and %s in another.", new Object[]{attr, action.get(), act})).build();
                }
                action = Optional.of(act);
            }
            actions.put(attr, (CryptoAction)((Object)action.get()));
        }
        return actions;
    }

    private static String getPartitionKeyName(List<TableSchema<?>> schemas) {
        String partitionName = schemas.get(0).tableMetadata().primaryPartitionKey();
        for (TableSchema<?> schema : schemas) {
            String part = schema.tableMetadata().primaryPartitionKey();
            if (partitionName.equals(part)) continue;
            throw DynamoDbEncryptionException.builder().message(String.format("Primary Key set to %s in one table and %s in another.", partitionName, part)).build();
        }
        return partitionName;
    }

    private static Optional<String> getSortKeyName(List<TableSchema<?>> schemas) {
        Optional sortName = schemas.get(0).tableMetadata().primarySortKey();
        for (TableSchema<?> schema : schemas) {
            Optional sort = schema.tableMetadata().primarySortKey();
            if (sortName.equals(sort)) continue;
            throw DynamoDbEncryptionException.builder().message(String.format("Primary Key set to %s in one table and %s in another.", sortName, sort)).build();
        }
        return sortName;
    }

    private static DynamoDbTableEncryptionConfig getTableConfig(DynamoDbEnhancedTableEncryptionConfig configWithSchema, String tableName) {
        ArrayList<Map<String, CryptoAction>> actionList = new ArrayList<Map<String, CryptoAction>>();
        for (TableSchema<?> schema : configWithSchema.schemaOnEncrypt()) {
            actionList.add(DynamoDbEnhancedClientEncryption.getActionsFromSchema(tableName, schema));
        }
        Map<String, CryptoAction> actions = DynamoDbEnhancedClientEncryption.mergeActions(actionList);
        DynamoDbTableEncryptionConfig.Builder builder = DynamoDbTableEncryptionConfig.builder();
        String partitionName = DynamoDbEnhancedClientEncryption.getPartitionKeyName(configWithSchema.schemaOnEncrypt());
        builder = builder.partitionKeyName(partitionName);
        Optional<String> sortName = DynamoDbEnhancedClientEncryption.getSortKeyName(configWithSchema.schemaOnEncrypt());
        if (sortName.isPresent()) {
            builder = builder.sortKeyName(sortName.get());
        }
        if (!Objects.isNull(configWithSchema.keyring())) {
            builder = builder.keyring((IKeyring)configWithSchema.keyring());
        }
        if (!Objects.isNull(configWithSchema.cmm())) {
            builder = builder.cmm((ICryptographicMaterialsManager)configWithSchema.cmm());
        }
        if (!Objects.isNull(configWithSchema.logicalTableName())) {
            builder = builder.logicalTableName(configWithSchema.logicalTableName());
        }
        if (!Objects.isNull((Object)configWithSchema.plaintextOverride())) {
            builder = builder.plaintextOverride(configWithSchema.plaintextOverride());
        }
        if (!Objects.isNull(configWithSchema.algorithmSuiteId())) {
            builder = builder.algorithmSuiteId(configWithSchema.algorithmSuiteId());
        }
        return builder.allowedUnsignedAttributePrefix(configWithSchema.allowedUnsignedAttributePrefix()).allowedUnsignedAttributes(configWithSchema.allowedUnsignedAttributes()).attributeActionsOnEncrypt(actions).legacyOverride(configWithSchema.legacyOverride()).build();
    }

    private static Set<String> getSignOnlyAttributes(TableSchema<?> tableSchema) {
        return tableSchema.tableMetadata().customMetadataObject("DynamoDbEncryption:SortOnly", Set.class).orElseGet(HashSet::new);
    }

    private static Set<String> getSignAndIncludeInEncryptionContextAttributes(TableSchema<?> tableSchema) {
        return tableSchema.tableMetadata().customMetadataObject("DynamoDbEncryption:SignAndIncludeInEncryptionContext", Set.class).orElseGet(HashSet::new);
    }

    private static Set<String> getDoNothingAttributes(TableSchema<?> tableSchema) {
        return tableSchema.tableMetadata().customMetadataObject("DynamoDbEncryption:DoNothing", Set.class).orElseGet(HashSet::new);
    }

    private static void scanForIgnoredEncryptionTags(TableSchema<?> tableSchema, String attributeName, StringBuilder path) {
        AttributeConverter attributeConverter = tableSchema.converterForAttribute((Object)attributeName);
        StringBuilder attributePath = new StringBuilder(path).append(attributeName).append(".");
        if (Objects.nonNull(attributeConverter) && Objects.nonNull(attributeConverter.type()) && attributeConverter.type().tableSchema().isPresent()) {
            TableSchema subTableSchema = (TableSchema)attributeConverter.type().tableSchema().get();
            Set<String> signOnlyAttributes = DynamoDbEnhancedClientEncryption.getSignOnlyAttributes(subTableSchema);
            if (signOnlyAttributes.size() > 0) {
                throw DynamoDbEncryptionException.builder().message(String.format("Detected DynamoDbEncryption Tag %s on a nested attribute with Path %s. This is NOT Supported at this time!", "DynamoDbEncryption:SortOnly", attributePath.append(signOnlyAttributes.toArray()[0]))).build();
            }
            Set<String> signAndIncludeAttributes = DynamoDbEnhancedClientEncryption.getSignAndIncludeInEncryptionContextAttributes(subTableSchema);
            if (signAndIncludeAttributes.size() > 0) {
                throw DynamoDbEncryptionException.builder().message(String.format("Detected DynamoDbEncryption Tag %s on a nested attribute with Path %s. This is NOT Supported at this time!", "DynamoDbEncryption:SignAndIncludeInEncryptionContext", attributePath.append(signAndIncludeAttributes.toArray()[0]))).build();
            }
            Set<String> doNothingAttributes = DynamoDbEnhancedClientEncryption.getDoNothingAttributes(subTableSchema);
            if (doNothingAttributes.size() > 0) {
                throw DynamoDbEncryptionException.builder().message(String.format("Detected DynamoDbEncryption Tag %s on a nested attribute with Path %s. This is NOT Supported at this time!", "DynamoDbEncryption:DoNothing", attributePath.append(doNothingAttributes.toArray()[0]))).build();
            }
            List subAttributeNames = subTableSchema.attributeNames();
            for (String subAttributeName : subAttributeNames) {
                DynamoDbEnhancedClientEncryption.scanForIgnoredEncryptionTags(subTableSchema, subAttributeName, attributePath);
            }
        }
    }
}

