/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control.util;

import org.ldaptive.SearchEntry;
import org.ldaptive.SearchResult;
import org.ldaptive.async.AsyncRequest;
import org.ldaptive.control.SyncDoneControl;
import org.ldaptive.control.SyncStateControl;
import org.ldaptive.intermediate.SyncInfoMessage;

public class SyncReplItem {
    private final AsyncRequest asyncRequest;
    private final Entry syncReplEntry;
    private final SyncInfoMessage syncInfoMessage;
    private final Response syncReplResponse;
    private final Exception syncReplException;

    public SyncReplItem(AsyncRequest request) {
        this.asyncRequest = request;
        this.syncReplEntry = null;
        this.syncInfoMessage = null;
        this.syncReplResponse = null;
        this.syncReplException = null;
    }

    public SyncReplItem(Entry entry) {
        this.asyncRequest = null;
        this.syncReplEntry = entry;
        this.syncInfoMessage = null;
        this.syncReplResponse = null;
        this.syncReplException = null;
    }

    public SyncReplItem(SyncInfoMessage message) {
        this.asyncRequest = null;
        this.syncReplEntry = null;
        this.syncInfoMessage = message;
        this.syncReplResponse = null;
        this.syncReplException = null;
    }

    public SyncReplItem(Response response) {
        this.asyncRequest = null;
        this.syncReplEntry = null;
        this.syncInfoMessage = null;
        this.syncReplResponse = response;
        this.syncReplException = null;
    }

    public SyncReplItem(Exception exception) {
        this.asyncRequest = null;
        this.syncReplEntry = null;
        this.syncInfoMessage = null;
        this.syncReplResponse = null;
        this.syncReplException = exception;
    }

    public boolean isAsyncRequest() {
        return this.asyncRequest != null;
    }

    public AsyncRequest getAsyncRequest() {
        return this.asyncRequest;
    }

    public boolean isEntry() {
        return this.syncReplEntry != null;
    }

    public Entry getEntry() {
        return this.syncReplEntry;
    }

    public boolean isMessage() {
        return this.syncInfoMessage != null;
    }

    public SyncInfoMessage getMessage() {
        return this.syncInfoMessage;
    }

    public boolean isResponse() {
        return this.syncReplResponse != null;
    }

    public Response getResponse() {
        return this.syncReplResponse;
    }

    public boolean isException() {
        return this.syncReplException != null;
    }

    public Exception getException() {
        return this.syncReplException;
    }

    public String toString() {
        String s = this.isAsyncRequest() ? String.format("[%s@%d::asyncRequest=%s]", this.getClass().getName(), this.hashCode(), this.asyncRequest) : (this.isEntry() ? String.format("[%s@%d::syncReplEntry=%s]", this.getClass().getName(), this.hashCode(), this.syncReplEntry) : (this.isMessage() ? String.format("[%s@%d::syncInfoMessage=%s]", this.getClass().getName(), this.hashCode(), this.syncInfoMessage) : (this.isResponse() ? String.format("[%s@%d::syncReplResponse=%s]", this.getClass().getName(), this.hashCode(), this.syncReplResponse) : (this.isException() ? String.format("[%s@%d::syncReplException=%s]", this.getClass().getName(), this.hashCode(), this.syncReplException) : String.format("[%s@%d]", this.getClass().getName(), this.hashCode())))));
        return s;
    }

    public static class Response {
        private final org.ldaptive.Response<SearchResult> response;
        private final SyncDoneControl syncDoneControl;

        public Response(org.ldaptive.Response<SearchResult> res) {
            this.response = res;
            this.syncDoneControl = (SyncDoneControl)this.response.getControl("1.3.6.1.4.1.4203.1.9.1.3");
        }

        public org.ldaptive.Response<SearchResult> getResponse() {
            return this.response;
        }

        public SyncDoneControl getSyncDoneControl() {
            return this.syncDoneControl;
        }

        public String toString() {
            return String.format("[%s@%d::response=%s]", this.getClass().getName(), this.hashCode(), this.response);
        }
    }

    public static class Entry {
        private final SearchEntry searchEntry;
        private final SyncStateControl syncStateControl;

        public Entry(SearchEntry entry) {
            this.searchEntry = entry;
            this.syncStateControl = (SyncStateControl)entry.getControl("1.3.6.1.4.1.4203.1.9.1.2");
        }

        public SearchEntry getSearchEntry() {
            return this.searchEntry;
        }

        public SyncStateControl getSyncStateControl() {
            return this.syncStateControl;
        }

        public String toString() {
            return String.format("[%s@%d::searchEntry=%s]", this.getClass().getName(), this.hashCode(), this.searchEntry);
        }
    }
}

