/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.shaped;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.RectangleUtil;
import net.infonode.gui.shaped.panel.ShapedPanel;
import net.infonode.util.Direction;

public class ShapedUtil {
    private ShapedUtil() {
    }

    public static Direction getDirection(Component c) {
        return c instanceof ShapedPanel ? ((ShapedPanel)c).getDirection() : Direction.RIGHT;
    }

    public static Insets transformInsets(Component c, Insets insets) {
        return InsetsUtil.rotate(ShapedUtil.getDirection(c), ShapedUtil.flipInsets(c, insets));
    }

    public static Insets flipInsets(Component c, Insets i) {
        if (c instanceof ShapedPanel) {
            if (((ShapedPanel)c).isHorizontalFlip()) {
                i = InsetsUtil.flipHorizontal(i);
            }
            if (((ShapedPanel)c).isVerticalFlip()) {
                i = InsetsUtil.flipVertical(i);
            }
        }
        return i;
    }

    public static void rotateCW(Polygon polygon, int height) {
        int i = 0;
        while (i < polygon.npoints) {
            int tmp = polygon.ypoints[i];
            polygon.ypoints[i] = polygon.xpoints[i];
            polygon.xpoints[i] = height - 1 - tmp;
            ++i;
        }
    }

    public static void rotate(Polygon polygon, Direction d, int width, int height) {
        if (d == Direction.UP) {
            ShapedUtil.rotateCW(polygon, height);
            ShapedUtil.rotateCW(polygon, width);
            ShapedUtil.rotateCW(polygon, height);
        } else if (d == Direction.LEFT) {
            ShapedUtil.rotateCW(polygon, height);
            ShapedUtil.rotateCW(polygon, width);
        } else if (d == Direction.DOWN) {
            ShapedUtil.rotateCW(polygon, height);
        }
    }

    public static Rectangle transform(Component c, Rectangle rect) {
        if (c instanceof ShapedPanel) {
            ShapedPanel sp = (ShapedPanel)c;
            return RectangleUtil.transform(rect, sp.getDirection(), sp.isHorizontalFlip(), sp.isVerticalFlip(), c.getWidth(), c.getHeight());
        }
        return rect;
    }

    public static Dimension transform(Component c, Dimension dim) {
        return ShapedUtil.getDirection(c).isHorizontal() ? dim : new Dimension(dim.height, dim.width);
    }

    public static int getWidth(Component c, int width, int height) {
        return ShapedUtil.getDirection(c).isHorizontal() ? width : height;
    }

    public static int getHeight(Component c, int width, int height) {
        return ShapedUtil.getDirection(c).isHorizontal() ? height : width;
    }
}

