/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.conditions;

import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.conditions.DelegatingConditionEvents;
import java.util.Collection;

class NeverCondition<T>
extends ArchCondition<T> {
    private final ArchCondition<T> condition;

    NeverCondition(ArchCondition<T> condition) {
        super("never " + condition.getDescription(), new Object[0]);
        this.condition = condition;
    }

    @Override
    public void init(Collection<T> allObjectsToTest) {
        this.condition.init(allObjectsToTest);
    }

    @Override
    public void finish(ConditionEvents events) {
        this.condition.finish(new InvertingConditionEvents(events));
    }

    @Override
    public void check(T item, ConditionEvents events) {
        this.condition.check(item, new InvertingConditionEvents(events));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{condition=" + this.condition + "}";
    }

    private static class InvertingConditionEvents
    extends DelegatingConditionEvents {
        InvertingConditionEvents(ConditionEvents originalEvents) {
            super(originalEvents);
        }

        @Override
        public void add(ConditionEvent event) {
            this.delegate.add(event.invert());
        }
    }
}

