/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class LineHeightManager
extends LengthManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public int getPropertyType() {
        return 43;
    }

    @Override
    public String getPropertyName() {
        return "line-height";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NORMAL_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case IDENT: {
                String s = lu.getStringValue().toLowerCase(Locale.ROOT);
                if ("normal".equals(s)) {
                    return ValueConstants.NORMAL_VALUE;
                }
                throw this.createInvalidIdentifierDOMException(lu.getStringValue());
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
        }
        return super.createValue(lu, engine);
    }

    @Override
    protected int getOrientation() {
        return 1;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value.getCssValueType() != CSSValue.CssType.TYPED) {
            return value;
        }
        if (value.getPrimitiveType() == CSSValue.Type.IDENT) {
            return new FloatValue(0, 1.1f);
        }
        switch (value.getUnitType()) {
            case 0: {
                return value;
            }
            case 2: {
                return this.fontSizeRelative(elt, pseudo, engine, sm, value.getFloatValue() * 0.01f);
            }
            case 25: {
                float f = value.getFloatValue();
                CSSStylableElement p = CSSEngine.getParentCSSStylableElement(elt);
                if (p != null) {
                    int lhidx = engine.getLineHeightIndex();
                    Value v = engine.getComputedStyle(p, null, lhidx);
                    float lh = v.getFloatValue();
                    return new FloatValue(v.getUnitType(), f * lh);
                }
                return new FloatValue(0, f * 1.1f);
            }
            case 27: {
                float f = value.getFloatValue();
                CSSStylableElement root = (CSSStylableElement)elt.getOwnerDocument().getDocumentElement();
                if (root != elt) {
                    int lhidx = engine.getLineHeightIndex();
                    Value v = engine.getComputedStyle(root, null, lhidx);
                    float lh = v.getFloatValue();
                    return new FloatValue(v.getUnitType(), f * lh);
                }
                return new FloatValue(0, f * 1.1f);
            }
        }
        return super.computeValue(elt, pseudo, engine, idx, sm, value);
    }

    private Value fontSizeRelative(CSSStylableElement elt, String pseudo, CSSEngine engine, StyleMap sm, float lineHeight) {
        int fsidx = engine.getFontSizeIndex();
        Value v = engine.getComputedStyle(elt, pseudo, fsidx);
        float fs = v.getFloatValue();
        return new FloatValue(3, lineHeight * fs);
    }
}

