/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public class StrokeDasharrayManager
extends LengthManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 34;
    }

    @Override
    public String getPropertyName() {
        return "stroke-dasharray";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lunit, CSSEngine engine) throws DOMException {
        switch (lunit.getLexicalUnitType()) {
            case IDENT: {
                if (lunit.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
                throw this.createInvalidIdentifierDOMException(lunit.getStringValue());
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lunit);
            }
        }
        ListValue lv = new ListValue(' ');
        LexicalUnit lu = lunit;
        do {
            Value v = super.createValue(lu, engine);
            lv.append(v);
            lu = lu.getNextLexicalUnit();
            if (lu == null) continue;
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                lu = lu.getNextLexicalUnit();
            }
            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.VAR) continue;
            return this.createLexicalValue(lunit);
        } while (lu != null);
        return lv;
    }

    @Override
    public Value createStringValue(CSSValue.Type type, String value, CSSEngine engine) throws DOMException {
        if (type != CSSValue.Type.IDENT) {
            throw this.createInvalidStringTypeDOMException(type);
        }
        if (value.equalsIgnoreCase("none")) {
            return ValueConstants.NONE_VALUE;
        }
        throw this.createInvalidIdentifierDOMException(value);
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        switch (value.getCssValueType()) {
            case TYPED: {
                return value;
            }
            case LIST: {
                ListValue result = new ListValue(' ');
                for (int i = 0; i < value.getLength(); ++i) {
                    result.append(super.computeValue(elt, pseudo, engine, idx, sm, value.item(i)));
                }
                return result;
            }
        }
        throw this.createDOMException();
    }

    @Override
    protected int getOrientation() {
        return 2;
    }
}

