---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: イシューボード
description: 視覚化、ワークフロー、Kanban、優先順位。
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- イシューカードにマイルストーンとイテレーションが表示される機能がGitLab 16.11 [で導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/25758)。
- グループまたはプロジェクト内の最後のボードを削除する機能がGitLab 17.6 [で導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/499579)。
- イシューボードを管理するための最小ロールが、GitLab 17.7でレポーターからプランナーに[変更されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169256)。

{{< /history >}}

イシューボードは、GitLabでの作業を管理および追跡するための視覚的な方法を提供します。イシューボード:

- ラベル、マイルストーン、または担当者に基づいて、カスタマイズ可能なリストでイシューをカードとして表示します。
- ワークフローのさまざまな段階を通してイシューを追跡します。
- KanbanやScrumなどのアジャイル開発手法をサポートします。
- さまざまなチームやプロジェクトのために複数のボードを編成します。
- プロセス全体のワークロードと進捗状況を視覚化します。

割り当てられた[ラベル](labels.md) 、[マイルストーン](#milestone-lists) 、[イテレーション](#iteration-lists) 、[担当者](#assignee-lists) 、または[ステータス](#status-lists)によって整理された、縦のリストにイシューがカードとして表示されます。

イシューにメタデータを追加し、既存のイシューに対応するリストを作成します。準備ができたら、イシューカードをあるリストから別のリストにドラッグできます。

イシューボードは、[Kanban](https://en.wikipedia.org/wiki/Kanban_(development))や[Scrum](https://en.wikipedia.org/wiki/Scrum_(software_development))などの一般的なフレームワークを強化できます。

チームメンバーが独自のワークフローを編成できるようにするには、[複数のイシューボード](#multiple-issue-boards)を使用します。これにより、同じプロジェクト内で複数のイシューボードを作成できます。

![GitLabイシューボード - コア](img/issue_boards_core_v17_1.png)

イシューボードのさまざまな機能は、さまざまな[GitLabプラン](https://about.gitlab.com/pricing/)で利用できます:

| プラン     | プロジェクトイシューボードの数 | [グループイシューボード](#group-issue-boards)の数 | [構成可能なイシューボード](#configurable-issue-boards) | [担当者リスト](#assignee-lists) |
| -------- | ------------------------------ | --------------------------------------------------- | ------------------------------------------------------- | --------------------------------- |
| Free     | 複数                       | 1                                                   | {{< icon name="dotted-circle" >}}いいえ                                  | {{< icon name="dotted-circle" >}}いいえ            |
| Premium  | 複数                       | 複数                                            | {{< icon name="check-circle" >}}はい                                  | {{< icon name="check-circle" >}}はい            |
| Ultimate | 複数                       | 複数                                            | {{< icon name="check-circle" >}}はい                                  | {{< icon name="check-circle" >}}はい            |

[イシューボードのGitLab Enterpriseの機能](#gitlab-enterprise-features-for-issue-boards)の詳細をご覧ください。

![GitLabイシューボード - Premium](img/issue_boards_premium_v17_1.png)

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>イシューボード機能の[動画プレゼンテーション](https://youtu.be/vjccjHI7aGI)をご覧ください。
<!-- Video published on 2020-04-02 -->

## 複数のイシューボード {#multiple-issue-boards}

複数のイシューボードを使用すると、次の複数のイシューボードを使用できます:

- 全プランのプロジェクト
- PremiumおよびUltimateプランのグループ

複数のイシューボードは、リポジトリが複数の製品のコードをホストしている複数のチームがいる大規模なプロジェクトや、ソフトウェア開発ライフサイクル全体でさまざまなワークフローを強化するボードを作成する場合に最適です。

メニューの上部にある検索ボックスを使用して、リストされたボードをフィルタリングできます。

10個以上のボードが利用可能な場合、メニューには**最近**セクションも表示され、最後にアクセスした4つのボードへのショートカットが表示されます。

![複数のイシューボード](img/issue_boards_multiple_v17_1.png)

複数のボードがあるプロジェクトまたはグループでイシューボードに再度アクセスすると、GitLabは最後にアクセスしたボードを自動的に読み込みます。

### イシューボードを作成する {#create-an-issue-board}

前提要件:

- プロジェクトのプランナーロール以上が必要です。

新しいイシューボードを作成するには:

1. イシューボードページの上部左隅にあるドロップダウンリストで、現在のボード名を選択します。
1. **新しいボードを作成する**を選択します。
1. 新しいボードの名前を入力し、そのスコープ（マイルストーン、イテレーション、ラベル、担当者、またはウェイト）を選択します。
1. **ボードを作成する**を選択します

### イシューボードを削除する {#delete-an-issue-board}

前提要件:

- ボードが保存されているプロジェクトまたはグループのプランナーロール以上が必要です。

開いているイシューボードを削除するには:

1. イシューボードページの右上隅で、**ボードを設定する**（{{< icon name="settings" >}}）を選択します。
1. **ボードを削除する**を選択します。
1. **削除**を選択して確定します。

削除したボードが最後のボードだった場合は、新しい`Development`ボードが作成されます。

## イシューボードのユースケース {#issue-boards-use-cases}

GitLabイシューボードを、独自の推奨ワークフローに合わせて調整できます。ワークフローベースのドキュメントについては、[チュートリアルを参照してください: 作業を計画して追跡](../../tutorials/plan_and_track.md)。

### 単一のイシューボードのユースケース {#use-cases-for-a-single-issue-board}

[GitLab Flow](https://about.gitlab.com/topics/version-control/what-is-gitlab-flow/)を使用すると、イシューで提案について話し合い、ラベル付けし、イシューボードで整理および優先順位を付けることができます。

たとえば、次の簡略化された開発ワークフローについて考えてみましょう:

1. アプリケーションのコードベースをホストするリポジトリがあり、チームは積極的にコードをコントリビュートしています。
1. **backend**（バックエンド）チームが新しい実装に取り組み、フィードバックと承認を収集して、**frontend**（フロントエンド）チームに渡します。
1. フロントエンドが完了すると、新しい機能の**staging**（ステージング）環境にデプロイされてTestされます。
1. 成功すると、**production**（本番環境）にデプロイされます。

**バックエンド**、**Frontend**（フロントエンド）、**Stagingステージ**、および**Production**（本番環境）のラベルがあり、それぞれにリストを含むイシューボードがある場合は、次のことができます:

- 開発ライフサイクルの最初から本番環境へのデプロイまで、実装全体のフローを視覚化します。
- イシューを縦に移動して、リスト内のイシューの優先順位を付けます。
- リスト間でイシューを移動して、設定したラベルに従って整理します。
- 既存のイシューを1つ以上選択して、ボード内のリストに複数のイシューを追加します。

![イシューカードの移動](img/issue_board_move_issue_card_list_v17_1.png)

### Scrumチーム {#scrum-team}

Scrumチームでは、各Scrumチームが独自のボードを持つように、[複数のイシューボード](#multiple-issue-boards)を使用します。Scrumボードでは、プロセスの各部分を通してイシューを簡単に移動できます。例: **To Do**、**Doing**（実行中）、および**完了**。

### クイック割り当て {#quick-assignments}

チームメンバーにイシューをすばやく割り当てるには:

1. チームメンバーごとに[担当者リスト](#assignee-lists)を作成します。
1. チームメンバーのリストにイシューをドラッグします。

## イシューボードの用語 {#issue-board-terminology}

**issue board**（イシューボード）は、イシューの一意のビューを表します。複数のリストを持つことができ、各リストはカードで表されるイシューで構成されています。

**list**（リスト）は、特定の属性に一致するイシューを表示するイシューボードの列です。デフォルトの「オープン」リストと「クローズ」リストに加えて、追加の各リストには、選択したラベル、担当者、またはマイルストーンに一致するイシューが表示されます。各リストの上部には、それに属するイシューの数が表示されます。リストのタイプには次のものがあります:

- **オープン**：他のリストのいずれにも属していない、オープン状態のすべてのイシュー。常に左端のリストとして表示されます。
- **クローズ**：クローズ状態のすべてのイシュー。常に右端のリストとして表示されます。
- **Label list**（ラベルリスト）：ラベルのすべてのオープン状態のイシュー。
- [**Assignee list**（担当者リスト）](#assignee-lists)：ユーザーに割り当てられたすべてのオープン状態のイシュー。
- [**Milestone list**（マイルストーンリスト）](#milestone-lists)：マイルストーンのすべてのオープン状態のイシュー。
- [**Iteration list**（イテレーションリスト）](#iteration-lists)：イテレーションのすべてのオープン状態のイシュー。
- [**Status list**（ステータスリスト）](#status-lists)：ステータスを持つすべてのイシュー。

**Card**（カード）はリスト上のボックスであり、イシューを表します。カードをあるリストから別のリストにドラッグして、ラベル、担当者、またはマイルストーンを変更できます。カードに表示できる情報には、以下が含まれます:

- イシューのタイトル
- 関連付けられたラベル
- イシュー番号
- 担当者
- ウェイト
- マイルストーン
- イテレーション（PremiumおよびUltimateプラン）
- 期限
- タイムトラッキングの見積もり
- ヘルスステータス

**swimlane**（スイムレーン）は、たとえば親エピックごとなど、イシューボード上のイシューの水平方向のグループ化です。

## リストのイシューをオーダー {#ordering-issues-in-a-list}

前提要件:

- プロジェクトのプランナーロール以上が必要です。

イシューが作成されると、システムは、そのイシューのプロジェクトまたはトップレベルグループの最大値よりも大きい相対的な順序の値を割り当てます。これは、イシューが表示されるイシューリストの一番下にイシューがあることを意味します。

ボードにアクセスすると、イシューはリストに順序付けられて表示されます。イシューをドラッグしてその順序を変更できます。変更された順序は保存されるため、後で同じボードにアクセスするすべての人が、いくつかの例外を除いて、並べ替えられた順序を確認できます。

イシューをドラッグして順序を変更するたびに、それに応じて相対的な順序の値が変更されます。次に、そのイシューがボードに表示されるたびに、更新された相対的な順序の値に従って順序付けが行われます。GitLabインスタンス内のユーザーがイシュー`A`をイシュー`B`の上にドラッグすると、これら2つのイシューが同じインスタンス内のボードに後で読み込まれる場合、順序が維持されます。たとえば、これは別のプロジェクトボードまたは別のグループボードである可能性があります。

この順序は[イシューリスト](issues/sorting_issue_lists.md)にも影響します。イシューボードの順序を変更すると、イシューリストの順序が変更され、その逆も同様です。

## フォーカスモード {#focus-mode}

フォーカスモードでは、ナビゲーションUIが非表示になり、ボード内のイシューに集中できます。フォーカスモードを有効または無効にするには、右上隅にある**フォーカスモードのON/OFF切替**（{{< icon name="maximize" >}}）を選択します。

## グループイシューボード {#group-issue-boards}

グループナビゲーションレベルでアクセスできるグループイシューボードは、プロジェクトレベルのボードと同じ機能を提供します。グループとその子孫サブグループに属するすべてのプロジェクトからのイシューを表示できます。

GitLab Freeのユーザーは、単一のグループイシューボードを使用できます。

## イシューボードのGitLab Enterpriseの機能 {#gitlab-enterprise-features-for-issue-boards}

GitLabイシューボードはGitLab Freeプランで利用できますが、高度な機能の一部は[より上位のプランのみ](https://about.gitlab.com/pricing/)に存在します。

### 構成可能なイシューボード {#configurable-issue-boards}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

イシューボードは、[マイルストーン](milestones/_index.md) 、[ラベル](labels.md) 、担当者、ウェイト、および現在の[イテレーション](../group/iterations/_index.md)に関連付けることができ、ボードのイシューを自動的にフィルタリングします。これにより、チームのニーズに応じて独自のボードを作成できます。

![スコープ付きボードを作成](img/issue_board_creation_v17_1.png)

ボードのスコープは、作成時または**ボードを設定する**（{{< icon name="settings" >}}）ボタンを選択して定義できます。マイルストーン、イテレーション、担当者、またはウェイトがイシューボードに割り当てられた後、検索ボックスでこれらを通してフィルタリングすることはできなくなります。それを行うには、イシューボードから目的のスコープ（たとえば、マイルストーン、担当者、またはウェイト）を削除する必要があります。

ボードの編集権限がない場合でも、**ボードの設定**（{{< icon name="settings" >}}）を選択して設定を確認できます。

### 担当者リスト {#assignee-lists}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

選択したラベルのすべてのイシューを表示する通常のリストと同様に、ユーザーに割り当てられたすべてのイシューを表示する担当者リストを追加できます。ラベルリストと担当者リストの両方を持つボードを持つことができます。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

担当者リストを追加するには:

1. **新しいリスト**を選択します。
1. **担当者**を選択します。
1. ドロップダウンリストで、ユーザーを選択します。
1. **ボードに追加**を選択します。

担当者リストが追加されたので、担当者リストとの間で[イシューを移動](#move-issues-and-lists)して、そのユーザーにイシューを割り当てるか、割り当てを解除できます。担当者リストを削除するには、ラベルリストと同様に、ゴミ箱アイコンを選択します。

![担当者リスト](img/issue_board_assignee_lists_v17_1.png)

### マイルストーンリスト {#milestone-lists}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

割り当てられたマイルストーンでイシューをフィルタリングするマイルストーンリストを作成して、イシューボードでより自由度を高め、表示レベルを高めることができます。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

マイルストーンリストを追加するには:

1. **新しいリスト**を選択します。
1. **マイルストーン**を選択します。
1. ドロップダウンリストで、マイルストーンを選択します。
1. **ボードに追加**を選択します。

イシューのマイルストーンを変更するには、[イシューカードをドラッグ](#move-issues-and-lists)してマイルストーンリストに出し入れします。

![マイルストーンリスト](img/issue_board_milestone_lists_v17_1.png)

### イテレーションリスト {#iteration-lists}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

イテレーションでイシューのリストを作成できます。

前提要件:

- プロジェクトのプランナーロール以上が必要です。

イテレーションリストを追加するには:

1. **新しいリスト**を選択します。
1. **イテレーション**を選択します。
1. ドロップダウンリストで、イテレーションを選択します。
1. **ボードに追加**を選択します。

イシューのイテレーションを変更するには、[イシューカードをドラッグ](#move-issues-and-lists)してイテレーションリストに出し入れします。

![イテレーションリスト](img/issue_board_iteration_lists_v17_1.png)

### ステータスリスト {#status-lists}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 18.2で`work_item_status_feature_flag`[フラグ](../../administration/feature_flags/_index.md)とともに[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/543862)されました。デフォルトでは有効になっています。
- GitLab 18.4で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/521286)になりました。機能フラグ`work_item_status_feature_flag`は削除されました。

{{< /history >}}

特定のステータスを持つイシューのリストを作成します。ステータスリストを使用すると、**進行中**や**完了**など、ワークフローの段階ごとにイシューを整理できます。

ステータスの詳細については、[ステータス](../work_items/status.md)を参照してください。

ステータスリストは、他のリストタイプとは異なる動作をします:

- **Status lists**（ステータスリスト）: ステータスがオープン状態にマップされているかクローズ状態にマップされているかに応じて、オープンイシューとクローズイシューの両方を含めることができます。
- （アサイン先またはマイルストーンのような）**Other lists**（他のリスト）: 常にオープンイシューのみを表示します。

前提要件: 

- プロジェクトのプランナーロール以上が必要です。

ステータスリストを追加するには:

1. **新しいリスト**を選択します。
1. **ステータス**を選択します。
1. ドロップダウンリストからステータスを選択します。
1. **ボードに追加**を選択します。

ステータスリストがボードに追加され、そのステータスを持つイシューが表示されます。

イシューのステータスを変更するには、[イシューカードをドラッグ](#move-issues-and-lists)してステータスリストに出し入れします。

![ステータスリスト](img/issue_board_status_lists_v18_2.png)

### スイムレーンでイシューをグループ化する {#group-issues-in-swimlanes}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

スイムレーンを使用すると、エピックでグループ化されたイシューを視覚化できます。イシューボードは他のすべての機能を保持しますが、イシューの視覚的な構成が異なります。この機能は、projectレベルとgroupレベルの両方で使用できます。

前提要件: 

- プロジェクトのプランナーロール以上が必要です。

イシューボードでイシューをエピック別にグループ化するには:

1. **表示オプション** ({{< icon name="preferences" >}}) を選択します。
1. **エピックのスイムレーン**を選択します。

![エピックのスイムレーン](img/epics_swimlanes_v17_1.png)

この表示のままイシューを[編集](#edit-an-issue)したり、[ドラッグ](#move-issues-and-lists)して位置やエピックの割り当てを変更したりできます:

- イシューを並べ替えるには、リスト内の新しい位置までドラッグします。
- イシューを別のエピックに割り当てるには、そのエピックの水平レーンにドラッグします。
- エピックからイシューを削除するには、**エピックがアサインされていないイシュー**レーンにドラッグします。
- イシューを別のエピックと別のリストに同時に移動するには、イシューを斜めにドラッグします。

![スイムレーン間でイシューをドラッグする](img/epics_swimlanes_drag_and_drop_v13_6.png)

### イシューのウェイトの合計 {#sum-of-issue-weights}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

各リストの上部には、そのリストに属するイシューのウェイトの合計が表示されます。これは、特に[担当者](#assignee-lists)リストと組み合わせて、キャパシティの割り当てにボードを使用する場合に便利です。

![イシューボードの合計ウェイト](img/issue_board_summed_weights_v17_1.png)

### 実行の制限 {#work-in-progress-limits}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- ウェイトによる制限の設定は、GitLab 17.11で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/119208/)。

{{< /history >}}

イシューボードの各イシューリストに、実行の制限（WIP）を設定できます。制限が設定されると、現在の状態と設定された制限がボードリストのヘッダーに表示されます。

リスト内の線は、制限内の項目と制限を超える項目を区切ります。デフォルトのリスト（**オープン**および**クローズ**）には、実行の制限を設定できません。

#### 制限の種類 {#types-of-limits}

GitLabは、次の2種類の実行の制限をサポートしています:

- **アイテム**: ウェイトに関係なく、リスト内のイシューの数を制限します。ボードのヘッダーには、リスト内のイシューの数とアイテムの制限が表示されます。

  たとえば、イシューが4つあり、アイテムの制限が3つある場合、ヘッダーには**4/3**（4/3）と表示されます。

  ![イシューボードで実行中のアイテム制限](img/issue_board_wip_items_limit_v17_11.png)

- **ウェイト**: リスト内のイシューの合計ウェイトを制限します。ボードのヘッダーには、リスト内のイシューの合計ウェイトとウェイト制限が表示されます。

  たとえば、イシューのウェイトの合計が8になり、ウェイト制限が5つある場合、ヘッダーには**8/5**（8/5）と表示されます。

  ![イシューボードで実行中のウェイト制限](img/issue_board_wip_weight_limit_v17_11.png)

例:

- リストに4つのイシューがあり、アイテム制限が5つある場合、ヘッダーには**4/5**（4/5）と表示されます。制限を超えると、現在のイシュー数が赤で表示されます。
- アイテム制限が5つのイシューが5つあるリストがあるとします。別のイシューをそのリストに移動すると、リストのヘッダーには**6/5**（6/5）と表示され、6は赤で表示されます。実行中の制限の線は、6番目のイシューの前に表示されます。
- ウェイト制限を使用する場合、ウェイトがそれぞれ1、2、5（合計ウェイトは8）のイシューが3つあり、ウェイト制限が5の場合、ヘッダーには**8/5**（8は赤色）と表示されます。実行中の制限の線は、結合されたウェイトが制限内にあるイシューの後に表示され、制限を超えるイシューから分離されます。

#### 実行中の制限を設定する {#set-work-in-progress-limit}

前提要件: 

- プロジェクトのプランナーロール以上が必要です。

リストの実行の制限を設定するには、イシューボードで次の手順を実行します:

1. 編集するリストの上部にある**リスト設定を編集**の編集({{< icon name="settings" >}})を選択します。リスト設定サイドバーが右側に開きます。
1. **作業中の上限**の横にある**編集**を選択します。
1. ドロップダウンリストから制限の種類を選択します:
   - **アイテム**: イシューの数で制限する場合。
   - **ウェイト**: イシューの合計ウェイトで制限する場合。
1. アイテムの最大数または最大ウェイトを入力します。
1. <kbd>Enter</kbd>を押して保存します。

実行の制限を削除するには、**制限の解除**を選択します。

### ブロックされたイシュー {#blocked-issues}

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

イシューが[別のイシューによってブロックされている](issues/related_issues.md#blocking-issues)場合、ブロックされている状態を示すアイコンがタイトルの横に表示されます。

ブロックされたアイコン({{< icon name="entity-blocked" >}})の上にカーソルを合わせると、詳細な情報のポップオーバーが表示されます。

![ブロックされたイシュー](img/issue_boards_blocked_icon_v17_9.png)

## イシューボードで実行できるアクション {#actions-you-can-take-on-an-issue-board}

- [イシュー](#edit-an-issue)を編集。
- [新しいリスト](#create-a-new-list)を作成。
- [既存のリスト](#remove-a-list)を削除。
- リストから[イシュー](#remove-an-issue-from-a-list)を削除。
- [イシューボード](#filter-issues)全体に表示されるイシューをフィルタリングします。
- [イシュー](#move-issues-and-lists)とリストを移動。
- リストをドラッグして並べ替えます。
- （リスト間でイシューをドラッグして）イシューラベルを変更します。
- （イシューを**クローズ**リストにドラッグして）イシューをクローズします。

### イシューを編集 {#edit-an-issue}

ボード表示のままイシューを編集できます。右側のサイドバーを開くには、イシューカード（タイトルではなく）を選択します。

前提要件: 

- プロジェクトのプランナーロール以上が必要です。

右側のサイドバーで、次のイシュー属性を編集できます:

- 担当者
- 機密性
- 期限
- [エピック](../group/epics/_index.md)
- [ヘルスステータス](issues/managing_issues.md#health-status)
- [イテレーション](../group/iterations/_index.md)
- ラベル
- マイルストーン
- 通知の設定
- タイトル
- [ウェイト](issues/issue_weight.md)
- タイムトラッキング

<!-- When issues_list_drawer feature flag is removed, use the following info
and the ones outlined in issues/managing_issues.md#open-issues-in-a-drawer to update the main previous topic. -->

管理者が[イシュードロワー](issues/managing_issues.md#open-issues-in-a-drawer)を有効にしている場合、イシューボードからイシューカードを選択すると、ドロワーにイシューが開きます。そこでは、説明、コメント、関連アイテムなど、すべてのフィールドを編集できます。

### 新しいリストを作成 {#create-a-new-list}

{{< history >}}

- 既存のリスト間にリストを作成することは、GitLab 17.5[で導入](https://gitlab.com/gitlab-org/gitlab/-/issues/462515)されました。

{{< /history >}}

2つの既存のリストの間、またはイシューボードの右側に新しいリストを作成できます。

2つのリストの間に新しいリストを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **Plan** > **イシューボード**を選択します。
1. 2つのリストの間で、カーソルを合わせるか、キーボードのフォーカスを移動します。
1. **新しいリスト**を選択します。新しいリストパネルが開きます。

   ![イシューボードの2つのリスト間に新しいリストを作成する](img/issue_board_add_list_between_lists_v17_6.png)

1. 新しいリストのベースにするラベル、ユーザー、マイルストーン、イテレーション、またはステータスを選択します。
1. **ボードに追加**を選択します。

新しいリストは、新しいリストパネルと同じ位置にボードに挿入されます。

リストを移動して並べ替えるには、それらをドラッグして移動します。

または、**新しいリスト**の右端にある新しいリストを選択することもできます。新しいリストは、リストの右端の**クローズ**の前に挿入されます。

### リストを削除 {#remove-a-list}

リストの削除は、削除されるのはリストビューだけなので、イシューやラベルには影響しません。必要に応じて、いつでも後で再作成できます。

前提要件: 

- プロジェクトのプランナーロール以上が必要です。

イシューボードからリストを削除するには:

1. 削除するリストの上部にある**リスト設定を編集**の編集({{< icon name="settings" >}})を選択します。リスト設定サイドバーが右側に開きます。
1. **リストを削除**を削除を選択します。
1. 確認**リストを削除**で、もう一度リストを削除を選択します。

### リストにイシューを追加 {#add-issues-to-a-list}

前提要件: 

- プロジェクトのプランナーロール以上が必要です。

ボードが1つまたは複数の属性にスコープされている場合は、追加するイシューに移動し、ボードのスコープと同じ属性を適用します。

たとえば、グループイシューボードで、`Doing`ラベルにスコープされたリストにイシューを追加するには:

1. グループまたはいずれかのサブグループまたはプロジェクトのイシューに移動します。
1. `Doing`ラベルを追加します。

これで、イシューがイシューボードの`Doing`リストに表示されるはずです。

### リストからイシューを削除 {#remove-an-issue-from-a-list}

イシューがリストに属さなくなった場合は、削除できます。

前提要件: 

- プロジェクトのプランナーロール以上が必要です。

手順は、リストのスコープによって異なります:

1. 右側のサイドバーを開くには、イシューカードを選択します。
1. イシューをリストに保持しているものを削除します。ラベルリストの場合は、ラベルを削除します。[担当者](#assignee-lists)リストの場合は、ユーザーの割り当てを解除します。

### イシューをフィルタリングする {#filter-issues}

イシューボードの上部にあるフィルターを使用して、必要な結果のみを表示できます。これは、[イシュートラッカー](issues/_index.md)で使用されているフィルタリングに似ています。

前提要件: 

- プロジェクトのプランナーロール以上が必要です。

以下でフィルタリングできます:

- 担当者
- 作成者
- [エピック](../group/epics/_index.md)
- [イテレーション](../group/iterations/_index.md)
- ラベル
- マイルストーン
- 自分のリアクション
- リリース
- タイプ（イシュー/インシデント）
- [ウェイト](issues/issue_weight.md)
- [ステータス](../work_items/status.md)

#### グループボードでイシューをフィルタリング {#filtering-issues-in-a-group-board}

[グループ](#filter-issues)ボードで**グループ**をフィルタリングする場合は、次の動作に注意してください:

- マイルストーン：グループとその子孫グループに属するマイルストーンでフィルタリングできます。
- ラベル：グループに属するラベルでのみフィルタリングできますが、その子孫グループはフィルタリングできません。

右側のサイドバーを使用して**プロジェクト**を個別に編集する場合は、イシューのプロジェクトからマイルストーンとラベルをさらに選択できます。

### イシューとリストを移動 {#move-issues-and-lists}

イシューとリストは、ドラッグして移動できます。

前提要件: 

- GitLabのプロジェクトのプランナーロール以上を持っている必要があります。

イシューを移動するには、イシューカードを選択し、現在のリスト内の別の位置、または別のリストにドラッグします。[リスト間](#dragging-issues-between-lists)でイシューをドラッグした場合に起こりうる影響について説明します。

リストを移動するには、上部のバーを選択し、水平方向にドラッグします。**オープン**リストと**クローズ**リストは移動できませんが、イシューボードの編集中に非表示にすることはできます。

#### リストの先頭にイシューを移動 {#move-an-issue-to-the-start-of-the-list}

{{< history >}}

- GitLab 15.4で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/367473)されました。

{{< /history >}}

メニューショートカットを使用して、イシューをリストの一番上に移動できます。

別のイシューがフィルターで非表示になっている場合でも、イシューはリストの一番上に移動されます。

前提要件: 

- プロジェクトのプランナーロール以上を持っている必要があります。

リストの先頭にイシューを移動するには:

1. イシューボードで、移動するイシューのカードの上にカーソルを合わせます。
1. **カードオプション** ({{< icon name="ellipsis_v" >}}) を選択し、次に**リストの先頭に移動**の先頭に移動を選択します。

#### イシューをリストの最後に移動 {#move-an-issue-to-the-end-of-the-list}

{{< history >}}

- GitLab 15.4で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/367473)されました。

{{< /history >}}

メニューショートカットを使用して、イシューをリストの一番下に移動できます。

別のイシューがフィルターで非表示になっている場合でも、イシューはリストの一番下に移動されます。

前提要件: 

- プロジェクトのプランナーロール以上を持っている必要があります。

リストの最後にイシューを移動するには:

1. イシューボードで、移動するイシューのカードの上にカーソルを合わせます。
1. **カードオプション** ({{< icon name="ellipsis_v" >}}) を選択し、次にリストの最後に**リストの最後に移動**を選択します。

#### リスト間でイシューをドラッグ {#dragging-issues-between-lists}

イシューを別のリストに移動するには、イシューカードを選択してそのリストにドラッグします。

リスト間でイシューをドラッグすると、その結果はソースリストとターゲットリストによって異なります。

|                              | オープンへ        | 完了へ   | ラベルBリストへ                | 担当者Bobのリストへ          |
| ---------------------------- | -------------- | ----------- | ------------------------------ | ----------------------------- |
| **From Open**（オープンから）                | -              | イシューを完了 | ラベルBを追加                    | Bobを割り当て                    |
| **From Closed**（完了から）              | イシューを再開   | -           | イシューを再開してラベルBを追加   | イシューを再開してBobを割り当て   |
| **From label A list**（ラベルAリストから）        | ラベルAを削除 | イシューを完了 | ラベルAを削除してラベルBを追加 | Bobを割り当て                    |
| **From assignee Alice list**（担当者Aliceのリストから） | Aliceの割り当てを解除 | イシューを完了 | ラベルBを追加                    | Aliceの割り当てを解除してBobを割り当て |

## ヒント {#tips}

覚えておくべきことがいくつかあります:

- リスト間でイシューを移動すると、移動元のリストからラベルが削除され、移動先のリストからラベルが追加されます。
- イシューに複数のラベルがある場合、複数のリストに存在できます。
- イシューにラベルが付けられている場合、リストにはイシューが自動的に入力されます。
- カード内のイシュータイトルを選択すると、そのイシューに移動します。
- カード内のラベルを選択すると、イシューボード全体がすばやくフィルタリングされ、そのラベルを持つすべてのリストからのイシューのみが表示されます。
- イシューがステータスリストからオープンリストに移動されると、デフォルトのオープンステータスが適用されます。同様に、クローズリストに移動されると、デフォルトのクローズステータスが適用されます。
- パフォーマンスと表示レベルの理由から、各リストにはデフォルトで最初の20件のイシューが表示されます。20件を超えるイシューがある場合は、下にスクロールを開始すると、次の20件が表示されます。

## イシューボードのトラブルシューティング {#troubleshooting-issue-boards}

### 作成者または担当者でフィルタリングするときのグループイシューボードの`There was a problem fetching users` {#there-was-a-problem-fetching-users-on-group-issue-board-when-filtering-by-author-or-assignee}

グループイシューボードで作成者または担当者でフィルタリングするときに、`There was a problem fetching users`エラーのバナーが表示される場合は、現在のグループのメンバーとして追加されていることを確認してください。メンバー以外のユーザーには、イシューボードで作成者または担当者でフィルタリングするときにグループメンバーを一覧表示する権限がありません。

このエラーを修正するには、少なくともゲストロールで、すべてのユーザーをトップレベルグループに追加する必要があります。

### Railsコンソールを使用して、読み込みに失敗してタイムアウトになるイシューボードを修正する {#use-rails-console-to-fix-issue-boards-not-loading-and-timing-out}

UIでイシューボードが読み込まれず、タイムアウトする場合は、Railsコンソールを使用してイシュー再分散サービスを呼び出して修正します:

1. [Railsコンソールセッションを開始します](../../administration/operations/rails_console.md#starting-a-rails-console-session)。
1. 次のコマンドを実行します:

   ```ruby
   p = Project.find_by_full_path('<username-or-group>/<project-name>')

   Issues::RelativePositionRebalancingService.new(p.root_namespace.all_projects).execute
   ```

1. Railsコンソールを終了するには、`quit`と入力します。
