#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 brick
version:              2.5
visibility:           public
id:                   brick-2.5-EJi2Zlg8hXn3J6PuS9PxYB
key:                  brick-2.5-EJi2Zlg8hXn3J6PuS9PxYB
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2024
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  0f6da35d6f009a8ac093f83793bd08ef
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Keybindings Brick.Keybindings.KeyConfig
    Brick.Keybindings.KeyDispatcher Brick.Keybindings.KeyEvents
    Brick.Keybindings.Normalize Brick.Keybindings.Parse
    Brick.Keybindings.Pretty Brick.Main Brick.Themes Brick.Types
    Brick.Util Brick.Widgets.Border Brick.Widgets.Border.Style
    Brick.Widgets.Center Brick.Widgets.Core Brick.Widgets.Dialog
    Brick.Widgets.Edit Brick.Widgets.FileBrowser Brick.Widgets.List
    Brick.Widgets.ProgressBar Brick.Widgets.Table Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.EventM
    Brick.Types.Internal Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.6.6/site-local/brick-2.5
library-dirs:         /usr/lib/ghc-9.6.6/site-local/brick-2.5
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/brick-2.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick
hs-libraries:         HSbrick-2.5-EJi2Zlg8hXn3J6PuS9PxYB
depends:
    base-4.18.2.1 bimap-0.5.0-D6AFa8yrdg3IGvtNE9i0U bytestring-0.11.5.3
    config-ini-0.2.7.0-8h1sjgCJq3h9VYmpu4NDXL containers-0.6.7
    data-clist-0.2-mLSB5ER2jP9iuwVp2NgAV deepseq-1.4.8.1
    directory-1.3.8.5 exceptions-0.10.7 filepath-1.4.300.1
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-mtl-0.2.1.0-Ewo8HmKpWhTASatFX3KZGS
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw mtl-2.3.1 stm-2.5.1.0
    template-haskell-2.20.0.0 text-2.0.2
    text-zipper-0.13-98bqWKQdGtK8b9grSnzonE
    unix-compat-0.7.4.1-DqDzbwuaouv1yXLtKQLq3q
    vector-0.13.2.0-KFVS0U8K6eML5O0P7tVbRi
    vty-6.2-6i5q23gZbHJ7XNQnEoipug
    vty-crossplatform-0.4.0.0-6KDyQngFIGuInusJrKiv5h
    word-wrap-0.5-IctFmjV7GnuGJHlEdYs2T2

haddock-interfaces:   /usr/share/doc/haskell-brick/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

