/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.io.File;
import java.util.function.Consumer;
import org.aesh.readline.Readline;
import org.aesh.readline.completion.CompletionHandler;
import org.aesh.readline.completion.SimpleCompletionHandler;
import org.aesh.readline.editing.EditMode;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.history.FileHistory;
import org.aesh.readline.history.History;
import org.aesh.readline.history.InMemoryHistory;

public class ReadlineBuilder {
    private EditMode editMode;
    private History history;
    private CompletionHandler completionHandler;
    private int historySize = 50;
    private String historyFile;
    private boolean enableHistory = true;

    public static ReadlineBuilder builder() {
        return new ReadlineBuilder();
    }

    private ReadlineBuilder() {
    }

    private ReadlineBuilder apply(Consumer<ReadlineBuilder> consumer) {
        consumer.accept(this);
        return this;
    }

    public ReadlineBuilder editMode(EditMode editMode) {
        return this.apply(c -> {
            c.editMode = editMode;
        });
    }

    public ReadlineBuilder history(History history) {
        return this.apply(c -> {
            c.history = history;
        });
    }

    public ReadlineBuilder enableHistory(boolean enableHistory) {
        return this.apply(c -> {
            c.enableHistory = enableHistory;
        });
    }

    public ReadlineBuilder historySize(int historySize) {
        return this.apply(c -> {
            c.historySize = historySize;
        });
    }

    public ReadlineBuilder historyFile(String historyFile) {
        return this.apply(c -> {
            c.historyFile = historyFile;
        });
    }

    public ReadlineBuilder completionHandler(CompletionHandler completionHandler) {
        return this.apply(c -> {
            c.completionHandler = completionHandler;
        });
    }

    public Readline build() {
        if (this.editMode == null) {
            this.editMode = EditModeBuilder.builder().create();
        }
        if (!this.enableHistory) {
            this.history = null;
        } else if (this.history == null) {
            this.history = this.historyFile == null || !new File(this.historyFile).isFile() ? new InMemoryHistory(this.historySize) : new FileHistory(new File(this.historyFile), this.historySize);
        }
        if (this.completionHandler == null) {
            this.completionHandler = new SimpleCompletionHandler();
        }
        return new Readline(this.editMode, this.history, this.completionHandler);
    }
}

