/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InternetGatewayExclusionMode;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VpcBlockPublicAccessExclusionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcBlockPublicAccessExclusion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcBlockPublicAccessExclusion> {
    private static final SdkField<String> EXCLUSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExclusionId").getter(VpcBlockPublicAccessExclusion.getter(VpcBlockPublicAccessExclusion::exclusionId)).setter(VpcBlockPublicAccessExclusion.setter(Builder::exclusionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionId").unmarshallLocationName("exclusionId").build()}).build();
    private static final SdkField<String> INTERNET_GATEWAY_EXCLUSION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InternetGatewayExclusionMode").getter(VpcBlockPublicAccessExclusion.getter(VpcBlockPublicAccessExclusion::internetGatewayExclusionModeAsString)).setter(VpcBlockPublicAccessExclusion.setter(Builder::internetGatewayExclusionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InternetGatewayExclusionMode").unmarshallLocationName("internetGatewayExclusionMode").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(VpcBlockPublicAccessExclusion.getter(VpcBlockPublicAccessExclusion::resourceArn)).setter(VpcBlockPublicAccessExclusion.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").unmarshallLocationName("resourceArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(VpcBlockPublicAccessExclusion.getter(VpcBlockPublicAccessExclusion::stateAsString)).setter(VpcBlockPublicAccessExclusion.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(VpcBlockPublicAccessExclusion.getter(VpcBlockPublicAccessExclusion::reason)).setter(VpcBlockPublicAccessExclusion.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").unmarshallLocationName("reason").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(VpcBlockPublicAccessExclusion.getter(VpcBlockPublicAccessExclusion::creationTimestamp)).setter(VpcBlockPublicAccessExclusion.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").unmarshallLocationName("creationTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTimestamp").getter(VpcBlockPublicAccessExclusion.getter(VpcBlockPublicAccessExclusion::lastUpdateTimestamp)).setter(VpcBlockPublicAccessExclusion.setter(Builder::lastUpdateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimestamp").unmarshallLocationName("lastUpdateTimestamp").build()}).build();
    private static final SdkField<Instant> DELETION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletionTimestamp").getter(VpcBlockPublicAccessExclusion.getter(VpcBlockPublicAccessExclusion::deletionTimestamp)).setter(VpcBlockPublicAccessExclusion.setter(Builder::deletionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionTimestamp").unmarshallLocationName("deletionTimestamp").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(VpcBlockPublicAccessExclusion.getter(VpcBlockPublicAccessExclusion::tags)).setter(VpcBlockPublicAccessExclusion.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCLUSION_ID_FIELD, INTERNET_GATEWAY_EXCLUSION_MODE_FIELD, RESOURCE_ARN_FIELD, STATE_FIELD, REASON_FIELD, CREATION_TIMESTAMP_FIELD, LAST_UPDATE_TIMESTAMP_FIELD, DELETION_TIMESTAMP_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VpcBlockPublicAccessExclusion.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String exclusionId;
    private final String internetGatewayExclusionMode;
    private final String resourceArn;
    private final String state;
    private final String reason;
    private final Instant creationTimestamp;
    private final Instant lastUpdateTimestamp;
    private final Instant deletionTimestamp;
    private final List<Tag> tags;

    private VpcBlockPublicAccessExclusion(BuilderImpl builder) {
        this.exclusionId = builder.exclusionId;
        this.internetGatewayExclusionMode = builder.internetGatewayExclusionMode;
        this.resourceArn = builder.resourceArn;
        this.state = builder.state;
        this.reason = builder.reason;
        this.creationTimestamp = builder.creationTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.deletionTimestamp = builder.deletionTimestamp;
        this.tags = builder.tags;
    }

    public final String exclusionId() {
        return this.exclusionId;
    }

    public final InternetGatewayExclusionMode internetGatewayExclusionMode() {
        return InternetGatewayExclusionMode.fromValue(this.internetGatewayExclusionMode);
    }

    public final String internetGatewayExclusionModeAsString() {
        return this.internetGatewayExclusionMode;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final VpcBlockPublicAccessExclusionState state() {
        return VpcBlockPublicAccessExclusionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String reason() {
        return this.reason;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final Instant lastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public final Instant deletionTimestamp() {
        return this.deletionTimestamp;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.internetGatewayExclusionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcBlockPublicAccessExclusion)) {
            return false;
        }
        VpcBlockPublicAccessExclusion other = (VpcBlockPublicAccessExclusion)obj;
        return Objects.equals(this.exclusionId(), other.exclusionId()) && Objects.equals(this.internetGatewayExclusionModeAsString(), other.internetGatewayExclusionModeAsString()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.lastUpdateTimestamp(), other.lastUpdateTimestamp()) && Objects.equals(this.deletionTimestamp(), other.deletionTimestamp()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"VpcBlockPublicAccessExclusion").add("ExclusionId", (Object)this.exclusionId()).add("InternetGatewayExclusionMode", (Object)this.internetGatewayExclusionModeAsString()).add("ResourceArn", (Object)this.resourceArn()).add("State", (Object)this.stateAsString()).add("Reason", (Object)this.reason()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("LastUpdateTimestamp", (Object)this.lastUpdateTimestamp()).add("DeletionTimestamp", (Object)this.deletionTimestamp()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExclusionId": {
                return Optional.ofNullable(clazz.cast(this.exclusionId()));
            }
            case "InternetGatewayExclusionMode": {
                return Optional.ofNullable(clazz.cast(this.internetGatewayExclusionModeAsString()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "LastUpdateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimestamp()));
            }
            case "DeletionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.deletionTimestamp()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExclusionId", EXCLUSION_ID_FIELD);
        map.put("InternetGatewayExclusionMode", INTERNET_GATEWAY_EXCLUSION_MODE_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Reason", REASON_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("LastUpdateTimestamp", LAST_UPDATE_TIMESTAMP_FIELD);
        map.put("DeletionTimestamp", DELETION_TIMESTAMP_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcBlockPublicAccessExclusion, T> g) {
        return obj -> g.apply((VpcBlockPublicAccessExclusion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String exclusionId;
        private String internetGatewayExclusionMode;
        private String resourceArn;
        private String state;
        private String reason;
        private Instant creationTimestamp;
        private Instant lastUpdateTimestamp;
        private Instant deletionTimestamp;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcBlockPublicAccessExclusion model) {
            this.exclusionId(model.exclusionId);
            this.internetGatewayExclusionMode(model.internetGatewayExclusionMode);
            this.resourceArn(model.resourceArn);
            this.state(model.state);
            this.reason(model.reason);
            this.creationTimestamp(model.creationTimestamp);
            this.lastUpdateTimestamp(model.lastUpdateTimestamp);
            this.deletionTimestamp(model.deletionTimestamp);
            this.tags(model.tags);
        }

        public final String getExclusionId() {
            return this.exclusionId;
        }

        public final void setExclusionId(String exclusionId) {
            this.exclusionId = exclusionId;
        }

        @Override
        public final Builder exclusionId(String exclusionId) {
            this.exclusionId = exclusionId;
            return this;
        }

        public final String getInternetGatewayExclusionMode() {
            return this.internetGatewayExclusionMode;
        }

        public final void setInternetGatewayExclusionMode(String internetGatewayExclusionMode) {
            this.internetGatewayExclusionMode = internetGatewayExclusionMode;
        }

        @Override
        public final Builder internetGatewayExclusionMode(String internetGatewayExclusionMode) {
            this.internetGatewayExclusionMode = internetGatewayExclusionMode;
            return this;
        }

        @Override
        public final Builder internetGatewayExclusionMode(InternetGatewayExclusionMode internetGatewayExclusionMode) {
            this.internetGatewayExclusionMode(internetGatewayExclusionMode == null ? null : internetGatewayExclusionMode.toString());
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcBlockPublicAccessExclusionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Instant getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final Instant getDeletionTimestamp() {
            return this.deletionTimestamp;
        }

        public final void setDeletionTimestamp(Instant deletionTimestamp) {
            this.deletionTimestamp = deletionTimestamp;
        }

        @Override
        public final Builder deletionTimestamp(Instant deletionTimestamp) {
            this.deletionTimestamp = deletionTimestamp;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VpcBlockPublicAccessExclusion build() {
            return new VpcBlockPublicAccessExclusion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcBlockPublicAccessExclusion> {
        public Builder exclusionId(String var1);

        public Builder internetGatewayExclusionMode(String var1);

        public Builder internetGatewayExclusionMode(InternetGatewayExclusionMode var1);

        public Builder resourceArn(String var1);

        public Builder state(String var1);

        public Builder state(VpcBlockPublicAccessExclusionState var1);

        public Builder reason(String var1);

        public Builder creationTimestamp(Instant var1);

        public Builder lastUpdateTimestamp(Instant var1);

        public Builder deletionTimestamp(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

