/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.auth.aws.crt.internal.signer;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.auth.signing.AwsSigner;
import software.amazon.awssdk.crt.auth.signing.AwsSigningConfig;
import software.amazon.awssdk.crt.auth.signing.AwsSigningResult;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;
import software.amazon.awssdk.http.auth.aws.crt.internal.io.CrtInputStream;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public final class RollingSigner {
    private final byte[] seedSignature;
    private final AwsSigningConfig signingConfig;
    private byte[] previousSignature;

    public RollingSigner(byte[] seedSignature, AwsSigningConfig signingConfig) {
        this.seedSignature = (byte[])seedSignature.clone();
        this.previousSignature = (byte[])seedSignature.clone();
        this.signingConfig = signingConfig;
    }

    private static byte[] signChunk(ByteBuffer chunkBody, byte[] previousSignature, AwsSigningConfig signingConfig) {
        AwsSigningConfig configCopy = signingConfig.clone();
        configCopy.setSignatureType(AwsSigningConfig.AwsSignatureType.HTTP_REQUEST_CHUNK);
        configCopy.setSignedBodyHeader(AwsSigningConfig.AwsSignedBodyHeaderType.NONE);
        configCopy.setSignedBodyValue(null);
        CrtInputStream crtBody = new CrtInputStream(() -> new ByteBufferBackedInputStream(chunkBody));
        return (byte[])CompletableFutureUtils.joinLikeSync((CompletableFuture)AwsSigner.signChunk((HttpRequestBodyStream)crtBody, (byte[])previousSignature, (AwsSigningConfig)configCopy));
    }

    private static AwsSigningResult signTrailerHeaders(Map<String, List<String>> headerMap, byte[] previousSignature, AwsSigningConfig signingConfig) {
        List httpHeaderList = headerMap.entrySet().stream().map(entry -> new HttpHeader((String)entry.getKey(), String.join((CharSequence)",", (Iterable)entry.getValue()))).collect(Collectors.toList());
        AwsSigningConfig configCopy = signingConfig.clone();
        configCopy.setSignatureType(AwsSigningConfig.AwsSignatureType.HTTP_REQUEST_TRAILING_HEADERS);
        configCopy.setSignedBodyHeader(AwsSigningConfig.AwsSignedBodyHeaderType.NONE);
        configCopy.setSignedBodyValue(null);
        return (AwsSigningResult)CompletableFutureUtils.joinLikeSync((CompletableFuture)AwsSigner.sign(httpHeaderList, (byte[])previousSignature, (AwsSigningConfig)configCopy));
    }

    public byte[] sign(ByteBuffer chunkBody) {
        this.previousSignature = RollingSigner.signChunk(chunkBody, this.previousSignature, this.signingConfig);
        return this.previousSignature;
    }

    public byte[] sign(Map<String, List<String>> headerMap) {
        AwsSigningResult result = RollingSigner.signTrailerHeaders(headerMap, this.previousSignature, this.signingConfig);
        this.previousSignature = result != null ? result.getSignature() : new byte[]{};
        return this.previousSignature;
    }

    public void reset() {
        this.previousSignature = this.seedSignature;
    }

    private static final class ByteBufferBackedInputStream
    extends InputStream {
        private final ByteBuffer buf;

        private ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public int read() {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }
    }
}

