\name{ZeroCrossingImageFilter}
\alias{ZeroCrossingImageFilter}
\title{ZeroCrossingImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter finds the closest pixel to the zero-crossings (sign
changes) in a signed itk::Image .
ZeroCrossingImageFilter}
\details{
Pixels closest to zero-crossings are labeled with a foreground value.
All other pixels are marked with a background value. The algorithm
works by detecting differences in sign among neighbors using city-
block style connectivity (4-neighbors in 2d, 6-neighbors in 3d, etc.).
Inputs and Outputs
The input to this filter is an itk::Image of arbitrary dimension. The algorithm assumes a signed data type
(zero-crossings are not defined for unsigned int data types), and
requires that operator>, operator<, operator==, and operator!= are
defined.
The output of the filter is a binary, labeled image of user-specified
type. By default, zero-crossing pixels are labeled with a default
"foreground" value of itk::NumericTraits<OutputDataType>::OneValue() , where OutputDataType is the data type of the output image. All
other pixels are labeled with a default "background" value of itk::NumericTraits<OutputDataType>::ZeroValue() .
Parameters
There are two parameters for this filter. ForegroundValue is the value
that marks zero-crossing pixels. The BackgroundValue is the value
given to all other pixels.
See:
Image
Neighborhood
NeighborhoodOperator
NeighborhoodIterator
ZeroCrossing for the procedural interface
itk::ZeroCrossingImageFilter for the Doxygen on the original ITK class.
ZeroCrossingImageFilter}
%C++ includes: sitkZeroCrossingImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{uint8_t GetBackgroundValue() const:}{
Set/Get the label value for non-zero-crossing pixels.
}
\item{uint8_t GetForegroundValue() const:}{
Set/Get the label value for zero-crossing pixels.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetBackgroundValue(uint8_t BackgroundValue):}{
Set/Get the label value for non-zero-crossing pixels.
}
\item{Self SetForegroundValue(uint8_t ForegroundValue):}{
Set/Get the label value for zero-crossing pixels.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ZeroCrossingImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{ ~ZeroCrossingImageFilter():}{
Destructor
}
}
}
