/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen;

import ghidra.pcode.emu.jit.JitCompiler;
import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.JitPcodeThread;
import ghidra.pcode.emu.jit.analysis.JitAllocationModel;
import ghidra.pcode.emu.jit.analysis.JitAnalysisContext;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitDataFlowModel;
import ghidra.pcode.emu.jit.analysis.JitOpUseModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.analysis.JitTypeModel;
import ghidra.pcode.emu.jit.analysis.JitVarScopeModel;
import ghidra.pcode.emu.jit.gen.ExceptionHandler;
import ghidra.pcode.emu.jit.gen.FieldForArrDirect;
import ghidra.pcode.emu.jit.gen.FieldForContext;
import ghidra.pcode.emu.jit.gen.FieldForExitSlot;
import ghidra.pcode.emu.jit.gen.FieldForSpaceIndirect;
import ghidra.pcode.emu.jit.gen.FieldForUserop;
import ghidra.pcode.emu.jit.gen.FieldForVarnode;
import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.op.OpGen;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassageClass;
import ghidra.pcode.emu.jit.gen.var.ValGen;
import ghidra.pcode.emu.jit.gen.var.VarGen;
import ghidra.pcode.emu.jit.op.JitOp;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.pcode.emu.jit.var.JitVar;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.TraceClassVisitor;

public class JitCodeGenerator {
    private final MethodHandles.Lookup lookup;
    final JitAnalysisContext context;
    final JitControlFlowModel cfm;
    final JitDataFlowModel dfm;
    final JitVarScopeModel vsm;
    final JitTypeModel tm;
    final JitAllocationModel am;
    final JitOpUseModel oum;
    private final Map<JitControlFlowModel.JitBlock, Label> blockLabels = new HashMap<JitControlFlowModel.JitBlock, Label>();
    private final Map<PcodeOp, ExceptionHandler> excHandlers = new LinkedHashMap<PcodeOp, ExceptionHandler>();
    private final Map<AddressSpace, FieldForSpaceIndirect> fieldsForSpaceIndirect = new HashMap<AddressSpace, FieldForSpaceIndirect>();
    private final Map<Address, FieldForArrDirect> fieldsForArrDirect = new HashMap<Address, FieldForArrDirect>();
    private final Map<RegisterValue, FieldForContext> fieldsForContext = new HashMap<RegisterValue, FieldForContext>();
    private final Map<VarnodeKey, FieldForVarnode> fieldsForVarnode = new HashMap<VarnodeKey, FieldForVarnode>();
    private final Map<String, FieldForUserop> fieldsForUserop = new HashMap<String, FieldForUserop>();
    private final Map<JitPassage.AddrCtx, FieldForExitSlot> fieldsForExitSlot = new HashMap<JitPassage.AddrCtx, FieldForExitSlot>();
    final String nameThis;
    private final ClassWriter cw;
    private final ClassVisitor cv;
    private final MethodVisitor clinitMv;
    private final MethodVisitor initMv;
    private final MethodVisitor runMv;
    private final Label startLocals = new Label();
    private final Label endLocals = new Label();

    public JitCodeGenerator(MethodHandles.Lookup lookup, JitAnalysisContext context, JitControlFlowModel cfm, JitDataFlowModel dfm, JitVarScopeModel vsm, JitTypeModel tm, JitAllocationModel am, JitOpUseModel oum) {
        this.lookup = lookup;
        this.context = context;
        this.cfm = cfm;
        this.dfm = dfm;
        this.vsm = vsm;
        this.tm = tm;
        this.am = am;
        this.oum = oum;
        JitPassage.AddrCtx entry = context.getPassage().getEntry();
        Object pkgThis = lookup.lookupClass().getPackageName().replace(".", "/");
        if (!((String)pkgThis).isEmpty()) {
            pkgThis = (String)pkgThis + "/";
        }
        this.nameThis = ((String)pkgThis + "Passage$at_" + String.valueOf(entry.address) + "_" + entry.biCtx.toString(16)).replace(":", "_").replace(" ", "_");
        int flags = entry.address.getOffset() == -1L ? 0 : 3;
        this.cw = new ClassWriter(flags);
        this.cv = JitCompiler.ENABLE_DIAGNOSTICS.contains((Object)JitCompiler.Diag.TRACE_CLASS) ? new TraceClassVisitor((ClassVisitor)this.cw, new PrintWriter(System.err)) : this.cw;
        this.cv.visit(61, 1, this.nameThis, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(JitCompiledPassage.class)});
        this.cv.visitField(26, "LANGUAGE_ID", GenConsts.TDESC_STRING, null, (Object)context.getLanguage().getLanguageID().toString());
        this.cv.visitField(26, "LANGUAGE", GenConsts.TDESC_LANGUAGE, null, null);
        this.cv.visitField(26, "ADDRESS_FACTORY", GenConsts.TDESC_ADDRESS_FACTORY, null, null);
        this.cv.visitField(26, "ENTRIES", GenConsts.TDESC_LIST, GenConsts.TSIG_LIST_ADDRCTX, null);
        this.cv.visitField(18, "thread", GenConsts.TDESC_JIT_PCODE_THREAD, null, null);
        this.cv.visitField(18, "state", GenConsts.TDESC_JIT_BYTES_PCODE_EXECUTOR_STATE, null, null);
        this.clinitMv = this.cv.visitMethod(9, "<clinit>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        this.initMv = this.cv.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(JitPcodeThread.class)}), null, null);
        this.runMv = this.cv.visitMethod(1, "run", Type.getMethodDescriptor((Type)Type.getType(JitCompiledPassage.EntryPoint.class), (Type[])new Type[]{Type.INT_TYPE}), null, null);
        this.startStaticInitializer();
        this.startConstructor();
        MethodVisitor gtMv = this.cw.visitMethod(1, "thread", Type.getMethodDescriptor((Type)Type.getType(JitPcodeThread.class), (Type[])new Type[0]), null, null);
        gtMv.visitCode();
        JitAllocationModel.RunFixedLocal.THIS.generateLoadCode(gtMv);
        gtMv.visitFieldInsn(180, this.nameThis, "thread", GenConsts.TDESC_JIT_PCODE_THREAD);
        gtMv.visitInsn(176);
        gtMv.visitMaxs(20, 20);
        gtMv.visitEnd();
    }

    public JitAnalysisContext getAnalysisContext() {
        return this.context;
    }

    public JitVarScopeModel getVariableScopeModel() {
        return this.vsm;
    }

    public JitTypeModel getTypeModel() {
        return this.tm;
    }

    public JitAllocationModel getAllocationModel() {
        return this.am;
    }

    protected void startStaticInitializer() {
        this.clinitMv.visitCode();
        this.clinitMv.visitFieldInsn(178, this.nameThis, "LANGUAGE_ID", GenConsts.TDESC_STRING);
        this.clinitMv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, "getLanguage", GenConsts.MDESC_JIT_COMPILED_PASSAGE__GET_LANGUAGE, true);
        this.clinitMv.visitInsn(89);
        this.clinitMv.visitFieldInsn(179, this.nameThis, "LANGUAGE", GenConsts.TDESC_LANGUAGE);
        this.clinitMv.visitMethodInsn(185, GenConsts.NAME_LANGUAGE, "getAddressFactory", GenConsts.MDESC_LANGUAGE__GET_ADDRESS_FACTORY, true);
        this.clinitMv.visitFieldInsn(179, this.nameThis, "ADDRESS_FACTORY", GenConsts.TDESC_ADDRESS_FACTORY);
    }

    protected void startConstructor() {
        this.initMv.visitCode();
        JitAllocationModel.InitFixedLocal.THIS.generateLoadCode(this.initMv);
        this.initMv.visitMethodInsn(183, GenConsts.NAME_OBJECT, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
        JitAllocationModel.InitFixedLocal.THIS.generateLoadCode(this.initMv);
        JitAllocationModel.InitFixedLocal.THREAD.generateLoadCode(this.initMv);
        this.initMv.visitFieldInsn(181, this.nameThis, "thread", GenConsts.TDESC_JIT_PCODE_THREAD);
        JitAllocationModel.InitFixedLocal.THIS.generateLoadCode(this.initMv);
        JitAllocationModel.InitFixedLocal.THREAD.generateLoadCode(this.initMv);
        this.initMv.visitMethodInsn(182, GenConsts.NAME_JIT_PCODE_THREAD, "getState", GenConsts.MDESC_JIT_PCODE_THREAD__GET_STATE, false);
        this.initMv.visitFieldInsn(181, this.nameThis, "state", GenConsts.TDESC_JIT_BYTES_PCODE_EXECUTOR_STATE);
    }

    protected void generateLoadJitStateSpace(AddressSpace space, MethodVisitor iv) {
        JitAllocationModel.InitFixedLocal.THIS.generateLoadCode(this.initMv);
        iv.visitFieldInsn(180, this.nameThis, "state", GenConsts.TDESC_JIT_BYTES_PCODE_EXECUTOR_STATE);
        iv.visitFieldInsn(178, this.nameThis, "ADDRESS_FACTORY", GenConsts.TDESC_ADDRESS_FACTORY);
        iv.visitLdcInsn((Object)space.getSpaceID());
        iv.visitMethodInsn(185, GenConsts.NAME_ADDRESS_FACTORY, "getAddressSpace", GenConsts.MDESC_ADDRESS_FACTORY__GET_ADDRESS_SPACE, true);
        iv.visitMethodInsn(185, GenConsts.NAME_JIT_BYTES_PCODE_EXECUTOR_STATE, "getForSpace", GenConsts.MDESC_JIT_BYTES_PCODE_EXECUTOR_STATE__GET_SPACE_FOR, true);
    }

    public FieldForSpaceIndirect requestFieldForSpaceIndirect(AddressSpace space) {
        return this.fieldsForSpaceIndirect.computeIfAbsent(space, s -> {
            FieldForSpaceIndirect f = new FieldForSpaceIndirect((AddressSpace)s);
            f.generateInitCode(this, this.cv, this.initMv);
            return f;
        });
    }

    public FieldForArrDirect requestFieldForArrDirect(Address address) {
        return this.fieldsForArrDirect.computeIfAbsent(address, a -> {
            FieldForArrDirect f = new FieldForArrDirect((Address)a);
            f.generateInitCode(this, this.cv, this.initMv);
            return f;
        });
    }

    protected FieldForContext requestStaticFieldForContext(RegisterValue ctx) {
        return this.fieldsForContext.computeIfAbsent(ctx, c -> {
            FieldForContext f = new FieldForContext(ctx);
            f.generateClinitCode(this, this.cv, this.clinitMv);
            return f;
        });
    }

    public FieldForVarnode requestStaticFieldForVarnode(Varnode vn) {
        return this.fieldsForVarnode.computeIfAbsent(new VarnodeKey(vn), vk -> {
            FieldForVarnode f = new FieldForVarnode(vn);
            f.generateClinitCode(this, this.cv, this.clinitMv);
            return f;
        });
    }

    public FieldForUserop requestFieldForUserop(PcodeUseropLibrary.PcodeUseropDefinition<?> userop) {
        return this.fieldsForUserop.computeIfAbsent(userop.getName(), n -> {
            FieldForUserop f = new FieldForUserop(userop);
            f.generateInitCode(this, this.cv, this.initMv);
            return f;
        });
    }

    public FieldForExitSlot requestFieldForExitSlot(JitPassage.AddrCtx target) {
        return this.fieldsForExitSlot.computeIfAbsent(target, t -> {
            FieldForExitSlot f = new FieldForExitSlot((JitPassage.AddrCtx)t);
            f.generateInitCode(this, this.cv, this.initMv);
            return f;
        });
    }

    public Label labelForBlock(JitControlFlowModel.JitBlock block) {
        return this.blockLabels.computeIfAbsent(block, b -> new Label());
    }

    public ExceptionHandler requestExceptionHandler(JitPassage.DecodedPcodeOp op, JitControlFlowModel.JitBlock block) {
        return this.excHandlers.computeIfAbsent(op, o -> new ExceptionHandler((PcodeOp)o, block));
    }

    protected void generateValInitCode(JitVal v) {
        ValGen.lookup(v).generateValInitCode(this, v, this.initMv);
    }

    public JitType generateValReadCode(JitVal v, JitTypeBehavior typeReq) {
        return ValGen.lookup(v).generateValReadCode(this, v, typeReq, this.runMv);
    }

    public void generateVarWriteCode(JitVar v, JitType type) {
        VarGen.lookup(v).generateVarWriteCode(this, v, type, this.runMv);
    }

    protected void generateInitCode() {
        for (JitAllocationModel.JvmLocal local : this.am.allLocals()) {
            local.generateInitCode(this, this.initMv);
        }
        for (JitVal v : this.dfm.allValuesSorted()) {
            this.generateValInitCode(v);
        }
        for (PcodeOp op : this.context.getPassage().getCode()) {
            JitOp jitOp = this.dfm.getJitOp(op);
            if (!this.oum.isUsed(jitOp)) continue;
            OpGen.lookup(jitOp).generateInitCode(this, jitOp, this.initMv);
        }
    }

    protected void generateCodeForOp(PcodeOp op, JitControlFlowModel.JitBlock block, int opIdx) {
        JitOp jitOp = this.dfm.getJitOp(op);
        if (!this.oum.isUsed(jitOp)) {
            return;
        }
        Label lblLine = new Label();
        this.runMv.visitLabel(lblLine);
        this.runMv.visitLineNumber(opIdx, lblLine);
        OpGen.lookup(jitOp).generateRunCode(this, jitOp, block, this.runMv);
    }

    protected int generateCodeForBlockOps(JitControlFlowModel.JitBlock block, int opIdx) {
        for (PcodeOp op : block.getCode()) {
            this.generateCodeForOp(op, block, opIdx);
            ++opIdx;
        }
        return opIdx;
    }

    protected int generateCodeForBlock(JitControlFlowModel.JitBlock block, int opIdx) {
        PcodeOp pcodeOp;
        if (block.hasJumpTo() || this.getOpEntry(block.first()) != null) {
            Label start = this.labelForBlock(block);
            this.runMv.visitLabel(start);
        }
        if ((pcodeOp = block.first()) instanceof JitPassage.DecodedPcodeOp) {
            JitPassage.DecodedPcodeOp first = (JitPassage.DecodedPcodeOp)pcodeOp;
            if (this.context.getConfiguration().emitCounters()) {
                Label tryStart = new Label();
                Label tryEnd = new Label();
                this.runMv.visitTryCatchBlock(tryStart, tryEnd, this.requestExceptionHandler(first, block).label(), GenConsts.NAME_THROWABLE);
                this.runMv.visitLabel(tryStart);
                JitAllocationModel.RunFixedLocal.THIS.generateLoadCode(this.runMv);
                this.runMv.visitLdcInsn((Object)block.instructionCount());
                this.runMv.visitLdcInsn((Object)block.trailingOpCount());
                this.runMv.visitMethodInsn(185, GenConsts.NAME_JIT_COMPILED_PASSAGE, "count", GenConsts.MDESC_JIT_COMPILED_PASSAGE__COUNT, true);
                this.runMv.visitLabel(tryEnd);
            }
        }
        return this.generateCodeForBlockOps(block, opIdx);
    }

    protected void generateAddress(Address address, MethodVisitor mv) {
        if (address == Address.NO_ADDRESS) {
            mv.visitFieldInsn(178, GenConsts.NAME_ADDRESS, "NO_ADDRESS", GenConsts.TDESC_ADDRESS);
            return;
        }
        mv.visitFieldInsn(178, this.nameThis, "ADDRESS_FACTORY", GenConsts.TDESC_ADDRESS_FACTORY);
        mv.visitLdcInsn((Object)address.getAddressSpace().getSpaceID());
        mv.visitMethodInsn(185, GenConsts.NAME_ADDRESS_FACTORY, "getAddressSpace", GenConsts.MDESC_ADDRESS_FACTORY__GET_ADDRESS_SPACE, true);
        mv.visitLdcInsn((Object)address.getOffset());
        mv.visitMethodInsn(185, GenConsts.NAME_ADDRESS_SPACE, "getAddress", GenConsts.MDESC_ADDRESS_SPACE__GET_ADDRESS, true);
    }

    protected void generateStaticEntry(JitPassage.AddrCtx entry) {
        FieldForContext ctxField = this.requestStaticFieldForContext(entry.rvCtx);
        this.clinitMv.visitFieldInsn(178, this.nameThis, "ENTRIES", GenConsts.TDESC_LIST);
        this.clinitMv.visitTypeInsn(187, GenConsts.NAME_ADDR_CTX);
        this.clinitMv.visitInsn(89);
        ctxField.generateLoadCode(this, this.clinitMv);
        this.generateAddress(entry.address, this.clinitMv);
        this.clinitMv.visitMethodInsn(183, GenConsts.NAME_ADDR_CTX, "<init>", GenConsts.MDESC_ADDR_CTX__$INIT, false);
        this.clinitMv.visitMethodInsn(185, GenConsts.NAME_LIST, "add", GenConsts.MDESC_LIST__ADD, true);
        this.clinitMv.visitInsn(87);
    }

    protected void generateStaticEntries() {
        this.clinitMv.visitTypeInsn(187, GenConsts.NAME_ARRAY_LIST);
        this.clinitMv.visitInsn(89);
        this.clinitMv.visitMethodInsn(183, GenConsts.NAME_ARRAY_LIST, "<init>", GenConsts.MDESC_ARRAY_LIST__$INIT, false);
        this.clinitMv.visitFieldInsn(179, this.nameThis, "ENTRIES", GenConsts.TDESC_LIST);
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            JitPassage.AddrCtx entry = this.getOpEntry(block.first());
            if (entry == null) continue;
            this.generateStaticEntry(entry);
        }
    }

    protected void generateRunCode() {
        this.runMv.visitCode();
        this.runMv.visitLabel(this.startLocals);
        for (JitAllocationModel.FixedLocal fixed : JitAllocationModel.RunFixedLocal.ALL) {
            fixed.generateDeclCode(this.runMv, this.nameThis, this.startLocals, this.endLocals);
        }
        for (JitAllocationModel.JvmLocal local : this.am.allLocals()) {
            local.generateDeclCode(this, this.startLocals, this.endLocals, this.runMv);
        }
        for (JitVal v : this.dfm.allValuesSorted()) {
            JitAllocationModel.VarHandler handler = this.am.getHandler(v);
            handler.generateDeclCode(this, this.startLocals, this.endLocals, this.runMv);
        }
        int opIdx = 1;
        ArrayList<Label> entries = new ArrayList<Label>();
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            JitPassage.AddrCtx entry = this.getOpEntry(block.first());
            if (entry == null) continue;
            Label lblEntry = new Label();
            entries.add(lblEntry);
        }
        JitAllocationModel.RunFixedLocal.BLOCK_ID.generateLoadCode(this.runMv);
        Label lblBadEntry = new Label();
        this.runMv.visitTableSwitchInsn(0, entries.size() - 1, lblBadEntry, (Label[])entries.toArray(Label[]::new));
        Iterator eit = entries.iterator();
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            JitPassage.AddrCtx entry = this.getOpEntry(block.first());
            if (entry == null) continue;
            Label lblEntry = (Label)eit.next();
            this.runMv.visitLabel(lblEntry);
            VarGen.computeBlockTransition(this, null, block).generate(this.runMv);
            this.runMv.visitJumpInsn(167, this.labelForBlock(block));
        }
        this.runMv.visitLabel(lblBadEntry);
        this.runMv.visitTypeInsn(187, GenConsts.NAME_ILLEGAL_ARGUMENT_EXCEPTION);
        this.runMv.visitInsn(89);
        this.runMv.visitLdcInsn((Object)"Bad entry blockId");
        this.runMv.visitMethodInsn(183, GenConsts.NAME_ILLEGAL_ARGUMENT_EXCEPTION, "<init>", GenConsts.MDESC_ILLEGAL_ARGUMENT_EXCEPTION__$INIT, false);
        this.runMv.visitInsn(191);
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            opIdx = this.generateCodeForBlock(block, opIdx);
            JitControlFlowModel.JitBlock fall = block.getFallFrom();
            if (fall == null) continue;
            VarGen.computeBlockTransition(this, block, fall).generate(this.runMv);
        }
        for (ExceptionHandler handler : this.excHandlers.values()) {
            handler.generateRunCode(this, this.runMv);
        }
    }

    public JitCompiledPassageClass load() {
        byte[] bytes = this.generate();
        return JitCompiledPassageClass.load(this.lookup, bytes);
    }

    protected byte[] dumpBytecode(byte[] bytes) {
        File dest = new File("build/gen/" + this.nameThis + ".class");
        dest.getParentFile().mkdirs();
        try (FileOutputStream os = new FileOutputStream(dest);){
            ((OutputStream)os).write(bytes);
        }
        catch (IOException e) {
            Msg.warn((Object)this, (Object)("Could not dump class file: " + this.nameThis + " (" + String.valueOf(e) + ")"));
        }
        return bytes;
    }

    protected byte[] generate() {
        this.generateStaticEntries();
        this.generateInitCode();
        this.generateRunCode();
        this.clinitMv.visitInsn(177);
        this.clinitMv.visitMaxs(20, 20);
        this.clinitMv.visitEnd();
        this.initMv.visitInsn(177);
        this.initMv.visitMaxs(20, 20);
        this.initMv.visitEnd();
        this.runMv.visitLabel(this.endLocals);
        try {
            this.runMv.visitMaxs(20, 20);
        }
        catch (Exception e) {
            if (JitCompiler.ENABLE_DIAGNOSTICS.contains((Object)JitCompiler.Diag.DUMP_CLASS)) {
                this.runMv.visitEnd();
                this.cv.visitEnd();
                this.dumpBytecode(this.cw.toByteArray());
            }
            throw e;
        }
        this.runMv.visitEnd();
        this.cv.visitEnd();
        if (JitCompiler.ENABLE_DIAGNOSTICS.contains((Object)JitCompiler.Diag.DUMP_CLASS)) {
            return this.dumpBytecode(this.cw.toByteArray());
        }
        return this.cw.toByteArray();
    }

    public JitPassage.AddrCtx getOpEntry(PcodeOp op) {
        return this.context.getOpEntry(op);
    }

    public RegisterValue getExitContext(PcodeOp op) {
        if (op instanceof JitPassage.DecodedPcodeOp) {
            JitPassage.DecodedPcodeOp dec = (JitPassage.DecodedPcodeOp)op;
            return dec.getContext();
        }
        throw new AssertionError((Object)("Couldn't figure exit context for " + String.valueOf(op)));
    }

    public void generateRetirePcCtx(Runnable pcGen, RegisterValue ctx, RetireMode mode, MethodVisitor rv) {
        JitAllocationModel.RunFixedLocal.THIS.generateLoadCode(rv);
        pcGen.run();
        if (ctx == null) {
            rv.visitInsn(1);
        } else {
            this.requestStaticFieldForContext(ctx).generateLoadCode(this, rv);
        }
        rv.visitMethodInsn(185, GenConsts.NAME_JIT_COMPILED_PASSAGE, mode.mname, mode.mdesc, true);
    }

    public void generatePassageExit(JitControlFlowModel.JitBlock block, Runnable pcGen, RegisterValue ctx, MethodVisitor rv) {
        VarGen.computeBlockTransition(this, block, null).generate(rv);
        this.generateRetirePcCtx(pcGen, ctx, RetireMode.WRITE, rv);
    }

    public String getErrorMessage(PcodeOp op) {
        return this.context.getErrorMessage(op);
    }

    public Address getAddressForOp(PcodeOp op) {
        if (op instanceof JitPassage.DecodedPcodeOp) {
            JitPassage.DecodedPcodeOp dec = (JitPassage.DecodedPcodeOp)op;
            return dec.getCounter();
        }
        return op.getSeqnum().getTarget();
    }

    record VarnodeKey(int space, long offset, int size) {
        public VarnodeKey(Varnode vn) {
            this(vn.getSpace(), vn.getOffset(), vn.getSize());
        }
    }

    public static enum RetireMode {
        WRITE(GenConsts.MDESC_JIT_COMPILED_PASSAGE__WRITE_COUNTER_AND_CONTEXT, "writeCounterAndContext"),
        SET(GenConsts.MDESC_JIT_COMPILED_PASSAGE__SET_COUNTER_AND_CONTEXT, "setCounterAndContext");

        private String mdesc;
        private String mname;

        private RetireMode(String mdesc, String mname) {
            this.mdesc = mdesc;
            this.mname = mname;
        }
    }

    public static class LineNumberer {
        final MethodVisitor mv;
        int nextLine = 1;

        public LineNumberer(MethodVisitor mv) {
            this.mv = mv;
        }

        public void nextLine() {
            Label label = new Label();
            this.mv.visitLabel(label);
            this.mv.visitLineNumber(this.nextLine++, label);
        }
    }
}

