/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.program;

import ghidra.framework.store.LockException;
import ghidra.program.database.mem.AddressSourceInfo;
import ghidra.program.database.mem.ByteMappingScheme;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockException;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.trace.database.memory.DBTraceMemoryManager;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.database.program.ByteCache;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.model.Trace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceProgramViewMemory;
import ghidra.trace.util.MemoryAdapter;
import ghidra.util.LockHold;
import ghidra.util.MathUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractDBTraceProgramViewMemory
implements TraceProgramViewMemory,
MemoryAdapter {
    protected final DBTraceProgramView program;
    protected final DBTraceMemoryManager memoryManager;
    private volatile AddressSetView addressSet;
    private volatile boolean addressSetValid;
    private boolean forceFullView = false;
    private long snap;
    private static final int CACHE_PAGE_COUNT = 3;
    protected final ByteCache cache = new ByteCache(3){

        @Override
        protected int doLoad(Address address, ByteBuffer buf) throws MemoryAccessException {
            DBTraceMemorySpace space = AbstractDBTraceProgramViewMemory.this.program.trace.getMemoryManager().getMemorySpace(address.getAddressSpace(), false);
            if (space == null) {
                int len = buf.remaining();
                buf.position(buf.limit());
                return len;
            }
            return space.getViewBytes(AbstractDBTraceProgramViewMemory.this.program.snap, address, buf);
        }
    };

    public AbstractDBTraceProgramViewMemory(DBTraceProgramView program) {
        this.program = program;
        this.memoryManager = program.trace.getMemoryManager();
        this.setSnap(program.snap);
    }

    protected abstract AddressSetView computeAddressSet();

    protected void invalidateAddressSet() {
        this.addressSetValid = false;
        this.program.fireObjectRestored();
    }

    protected AddressSetView getOrComputeAddressSet() {
        if (!this.addressSetValid) {
            this.addressSet = this.computeAddressSet();
            this.addressSetValid = true;
        }
        return this.addressSet;
    }

    @Override
    public void setForceFullView(boolean forceFullView) {
        this.forceFullView = forceFullView;
        this.invalidateAddressSet();
    }

    @Override
    public boolean isForceFullView() {
        return this.forceFullView;
    }

    void setSnap(long snap) {
        this.snap = snap;
        if (!this.forceFullView) {
            this.invalidateAddressSet();
        }
    }

    @Override
    public TraceProgramView getProgram() {
        return this.program;
    }

    @Override
    public Trace getTrace() {
        return this.program.trace;
    }

    @Override
    public long getSnap() {
        return this.snap;
    }

    public AddressSetView getLoadedAndInitializedAddressSet() {
        return this.getOrComputeAddressSet();
    }

    public AddressSetView getAllInitializedAddressSet() {
        return this.getOrComputeAddressSet();
    }

    public AddressSetView getInitializedAddressSet() {
        return this.getOrComputeAddressSet();
    }

    public boolean isBigEndian() {
        return this.program.getLanguage().isBigEndian();
    }

    public MemoryBlock createInitializedBlock(String name, Address start, InputStream is, long length, TaskMonitor monitor, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException, CancelledException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock createInitializedBlock(String name, Address start, FileBytes fileBytes, long offset, long size, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock createInitializedBlock(String name, Address start, long size, byte initialValue, TaskMonitor monitor, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException, CancelledException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock createUninitializedBlock(String name, Address start, long size, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException {
        throw new UnsupportedOperationException("All trace memory is initialized");
    }

    public MemoryBlock createBitMappedBlock(String name, Address start, Address mappedAddress, long length, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException, IllegalArgumentException {
        throw new UnsupportedOperationException("Mapped blocks are not supported in traces");
    }

    public MemoryBlock createByteMappedBlock(String name, Address start, Address mappedAddress, long length, ByteMappingScheme byteMappingScheme, boolean overlay) throws LockException, MemoryConflictException, AddressOverflowException, IllegalArgumentException {
        throw new UnsupportedOperationException("Mapped blocks are not supported in traces");
    }

    public MemoryBlock createBlock(MemoryBlock block, String name, Address start, long length) throws LockException, MemoryConflictException, AddressOverflowException {
        throw new UnsupportedOperationException();
    }

    public void removeBlock(MemoryBlock block, TaskMonitor monitor) throws LockException {
        throw new UnsupportedOperationException();
    }

    public long getSize() {
        return this.getOrComputeAddressSet().getNumAddresses();
    }

    public void moveBlock(MemoryBlock block, Address newStartAddr, TaskMonitor monitor) throws LockException, MemoryBlockException, MemoryConflictException, AddressOverflowException, NotFoundException {
        throw new UnsupportedOperationException();
    }

    public void split(MemoryBlock block, Address addr) throws MemoryBlockException, LockException, NotFoundException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock join(MemoryBlock blockOne, MemoryBlock blockTwo) throws LockException, MemoryBlockException, NotFoundException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock convertToInitialized(MemoryBlock uninitializedBlock, byte initialValue) throws LockException, MemoryBlockException, NotFoundException {
        throw new UnsupportedOperationException();
    }

    public MemoryBlock convertToUninitialized(MemoryBlock itializedBlock) throws MemoryBlockException, NotFoundException, LockException {
        throw new UnsupportedOperationException();
    }

    public Address findBytes(Address addr, byte[] bytes, byte[] masks, boolean forward, TaskMonitor monitor) {
        Address endAddr;
        Address startAddr;
        if (forward) {
            startAddr = addr;
            endAddr = this.getMaxAddress();
        } else {
            startAddr = this.getMinAddress();
            endAddr = addr;
        }
        return this.findBytes(startAddr, endAddr, bytes, masks, forward, monitor);
    }

    public Address findBytes(Address startAddr, Address endAddr, byte[] bytes, byte[] masks, boolean forward, TaskMonitor monitor) {
        ByteBuffer bufBytes = ByteBuffer.wrap(bytes);
        ByteBuffer bufMasks = masks == null ? null : ByteBuffer.wrap(masks);
        Address minAddr = forward ? startAddr : endAddr;
        Address maxAddr = forward ? endAddr : startAddr;
        Iterator it = this.program.getAddressFactory().getAddressSet(minAddr, maxAddr).iterator(forward);
        while (it.hasNext()) {
            Address found;
            AddressRange range = (AddressRange)it.next();
            DBTraceMemorySpace space = this.memoryManager.getMemorySpace(range.getAddressSpace(), false);
            if (space == null || (found = space.findBytes(this.snap, range, bufBytes, bufMasks, forward, monitor)) == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public byte getByte(Address addr) throws MemoryAccessException {
        try (LockHold hold = this.program.trace.lockRead();){
            byte by = this.cache.read(addr);
            return by;
        }
    }

    public int getBytes(Address addr, byte[] b, int off, int len) throws MemoryAccessException {
        try (LockHold hold = this.program.trace.lockRead();){
            if (this.cache.canCache(addr, len)) {
                int n = this.cache.read(addr, ByteBuffer.wrap(b, off, len));
                return n;
            }
            AddressSpace as = addr.getAddressSpace();
            DBTraceMemorySpace space = this.program.trace.getMemoryManager().getMemorySpace(as, false);
            if (space == null) {
                throw new MemoryAccessException("Space does not exist");
            }
            len = MathUtilities.unsignedMin((int)len, (long)(as.getMaxAddress().subtract(addr) + 1L));
            int n = space.getViewBytes(this.program.snap, addr, ByteBuffer.wrap(b, off, len));
            return n;
        }
    }

    @Override
    public void setByte(Address addr, byte value) throws MemoryAccessException {
        DBTraceMemorySpace space = this.memoryManager.getMemorySpace(addr.getAddressSpace(), true);
        if (space.putBytes(this.snap, addr, ByteBuffer.wrap(new byte[]{value})) != 1) {
            throw new MemoryAccessException();
        }
    }

    public void setBytes(Address addr, byte[] source, int sIndex, int size) throws MemoryAccessException {
        DBTraceMemorySpace space = this.memoryManager.getMemorySpace(addr.getAddressSpace(), true);
        if (space.putBytes(this.snap, addr, ByteBuffer.wrap(source, sIndex, size)) != size) {
            throw new MemoryAccessException();
        }
    }

    public FileBytes createFileBytes(String filename, long offset, long size, InputStream is, TaskMonitor monitor) throws IOException, CancelledException {
        throw new UnsupportedOperationException();
    }

    public List<FileBytes> getAllFileBytes() {
        return Collections.emptyList();
    }

    public AddressSourceInfo getAddressSourceInfo(Address address) {
        MemoryBlock block = this.getBlock(address);
        return block == null ? null : new AddressSourceInfo((Memory)this, address, block);
    }

    public boolean deleteFileBytes(FileBytes fileBytes) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean contains(Address addr) {
        return this.getOrComputeAddressSet().contains(addr);
    }

    public boolean contains(Address start, Address end) {
        return this.getOrComputeAddressSet().contains(start, end);
    }

    public boolean contains(AddressSetView set) {
        return this.getOrComputeAddressSet().contains(set);
    }

    public boolean isEmpty() {
        return this.getOrComputeAddressSet().isEmpty();
    }

    public Address getMinAddress() {
        return this.getOrComputeAddressSet().getMinAddress();
    }

    public Address getMaxAddress() {
        return this.getOrComputeAddressSet().getMaxAddress();
    }

    public int getNumAddressRanges() {
        return this.getOrComputeAddressSet().getNumAddressRanges();
    }

    public AddressRangeIterator getAddressRanges() {
        return this.getOrComputeAddressSet().getAddressRanges();
    }

    public AddressRangeIterator getAddressRanges(boolean forward) {
        return this.getOrComputeAddressSet().getAddressRanges(forward);
    }

    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        return this.getOrComputeAddressSet().getAddressRanges(start, forward);
    }

    public Iterator<AddressRange> iterator() {
        return this.getOrComputeAddressSet().iterator();
    }

    public Iterator<AddressRange> iterator(boolean forward) {
        return this.getOrComputeAddressSet().iterator(forward);
    }

    public Iterator<AddressRange> iterator(Address start, boolean forward) {
        return this.getOrComputeAddressSet().iterator(start, forward);
    }

    public long getNumAddresses() {
        return this.getOrComputeAddressSet().getNumAddresses();
    }

    public AddressIterator getAddresses(boolean forward) {
        return this.getOrComputeAddressSet().getAddresses(forward);
    }

    public AddressIterator getAddresses(Address start, boolean forward) {
        return this.getOrComputeAddressSet().getAddresses(start, forward);
    }

    public boolean intersects(AddressSetView addrSet) {
        return this.getOrComputeAddressSet().intersects(addrSet);
    }

    public boolean intersects(Address start, Address end) {
        return this.getOrComputeAddressSet().intersects(start, end);
    }

    public AddressSet intersect(AddressSetView view) {
        return this.getOrComputeAddressSet().intersect(view);
    }

    public AddressSet intersectRange(Address start, Address end) {
        return this.getOrComputeAddressSet().intersectRange(start, end);
    }

    public AddressSet union(AddressSetView addrSet) {
        return this.getOrComputeAddressSet().union(addrSet);
    }

    public AddressSet subtract(AddressSetView addrSet) {
        return this.getOrComputeAddressSet().subtract(addrSet);
    }

    public AddressSet xor(AddressSetView addrSet) {
        return this.getOrComputeAddressSet().xor(addrSet);
    }

    public boolean hasSameAddresses(AddressSetView view) {
        return this.getOrComputeAddressSet().hasSameAddresses(view);
    }

    public AddressRange getFirstRange() {
        return this.getOrComputeAddressSet().getFirstRange();
    }

    public AddressRange getLastRange() {
        return this.getOrComputeAddressSet().getLastRange();
    }

    public AddressRange getRangeContaining(Address address) {
        return this.getOrComputeAddressSet().getRangeContaining(address);
    }

    public Address findFirstAddressInCommon(AddressSetView set) {
        return this.getOrComputeAddressSet().findFirstAddressInCommon(set);
    }
}

