/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import generic.theme.GIcon;
import ghidra.lifecycle.Transitional;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.TraceTimeViewport;
import ghidra.trace.model.bookmark.TraceBookmarkManager;
import ghidra.trace.model.breakpoint.TraceBreakpointManager;
import ghidra.trace.model.context.TraceRegisterContextManager;
import ghidra.trace.model.data.TraceBasedDataTypeManager;
import ghidra.trace.model.guest.TracePlatformManager;
import ghidra.trace.model.listing.TraceCodeManager;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.modules.TraceStaticMappingManager;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceVariableSnapProgramView;
import ghidra.trace.model.property.TraceAddressPropertyManager;
import ghidra.trace.model.stack.TraceStackManager;
import ghidra.trace.model.symbol.TraceEquateManager;
import ghidra.trace.model.symbol.TraceReferenceManager;
import ghidra.trace.model.symbol.TraceSymbolManager;
import ghidra.trace.model.target.TraceObjectManager;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.trace.model.time.TraceTimeManager;
import ghidra.util.LockHold;
import java.util.Collection;
import javax.swing.Icon;

public interface Trace
extends DataTypeManagerDomainObject {
    public static final Icon TRACE_ICON = new GIcon("icon.content.handler.trace");

    @Transitional
    public static boolean isLegacy(Trace trace) {
        return trace != null && trace.getObjectManager().getRootSchema() == null;
    }

    public Language getBaseLanguage();

    public CompilerSpec getBaseCompilerSpec();

    public void setEmulatorCacheVersion(long var1);

    public long getEmulatorCacheVersion();

    public AddressFactory getBaseAddressFactory();

    public TraceAddressPropertyManager getAddressPropertyManager();

    public TraceBookmarkManager getBookmarkManager();

    public TraceBreakpointManager getBreakpointManager();

    public TraceCodeManager getCodeManager();

    default public TraceBasedDataTypeManager getDataTypeManager() {
        return this.getBaseDataTypeManager();
    }

    public TraceBasedDataTypeManager getBaseDataTypeManager();

    public TraceEquateManager getEquateManager();

    public TracePlatformManager getPlatformManager();

    public TraceMemoryManager getMemoryManager();

    public TraceModuleManager getModuleManager();

    public TraceObjectManager getObjectManager();

    public TraceReferenceManager getReferenceManager();

    public TraceRegisterContextManager getRegisterContextManager();

    public TraceStackManager getStackManager();

    public TraceStaticMappingManager getStaticMappingManager();

    public TraceSymbolManager getSymbolManager();

    public TraceThreadManager getThreadManager();

    public TraceTimeManager getTimeManager();

    public TraceProgramView getFixedProgramView(long var1);

    public TraceVariableSnapProgramView createProgramView(long var1);

    public Collection<TraceProgramView> getAllProgramViews();

    public TraceVariableSnapProgramView getProgramView();

    public TraceTimeViewport createTimeViewport();

    public void addProgramViewListener(TraceProgramViewListener var1);

    public void removeProgramViewListener(TraceProgramViewListener var1);

    public LockHold lockRead();

    public LockHold lockWrite();

    public static interface TraceProgramViewListener {
        public void viewCreated(TraceProgramView var1);
    }
}

