/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.go.ipc;

import ghidra.app.plugin.core.go.dialog.GhidraGoWaitForListenerDialog;
import ghidra.app.plugin.core.go.exception.StartedGhidraProcessExitedException;
import ghidra.app.plugin.core.go.exception.StopWaitingException;
import ghidra.util.Swing;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class CheckPeriodicallyRunnable
implements Runnable {
    protected static GhidraGoWaitForListenerDialog dialog = new GhidraGoWaitForListenerDialog();
    protected boolean showDialog;
    protected int period;
    protected TimeUnit timeUnit;
    protected ScheduledExecutorService executor;
    protected Callable<Boolean> checkCondition;

    public CheckPeriodicallyRunnable(boolean showDialog, int period, TimeUnit timeUnit, Callable<Boolean> checkCondition) {
        this.showDialog = showDialog;
        this.period = period;
        this.timeUnit = timeUnit;
        this.checkCondition = checkCondition;
        this.executor = Executors.newScheduledThreadPool(2);
    }

    protected CheckPeriodicallyRunnable(ScheduledExecutorService executor, boolean showDialog, int period, TimeUnit timeUnit, Callable<Boolean> checkCondition) {
        this(showDialog, period, timeUnit, checkCondition);
        this.executor = executor;
    }

    public void startChecking(int delay, TimeUnit delayTimeUnit) throws StopWaitingException {
        this.executor.schedule(this, (long)delay, delayTimeUnit);
    }

    public abstract void awaitTermination() throws StopWaitingException, StartedGhidraProcessExitedException;

    public void dispose() {
        this.executor.shutdownNow();
        Swing.runNow(() -> ((GhidraGoWaitForListenerDialog)dialog).close());
    }
}

