/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.expression;

import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;

public class TokenField
extends PatternValue {
    private boolean bigendian;
    private boolean signbit;
    private int bitstart;
    private int bitend;
    private int bytestart;
    private int byteend;
    private int shift;

    public int hashCode() {
        int result = 0;
        result += this.bitstart;
        result *= 31;
        result += this.bitend;
        result *= 31;
        result += Boolean.hashCode(this.signbit);
        result *= 31;
        return result += Boolean.hashCode(this.bigendian);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TokenField)) {
            return false;
        }
        TokenField that = (TokenField)obj;
        if (this.bitstart != that.bitstart) {
            return false;
        }
        if (this.bitend != that.bitend) {
            return false;
        }
        if (this.signbit != that.signbit) {
            return false;
        }
        return this.bigendian == that.bigendian;
    }

    @Override
    public long minValue() {
        return 0L;
    }

    @Override
    public long maxValue() {
        long res = -1L;
        res <<= this.bitend - this.bitstart;
        return (res <<= 1) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public long getValue(ParserWalker walker) throws MemoryAccessException {
        long res = this.getInstructionBytes(walker);
        res >>= this.shift;
        res = this.signbit ? TokenField.signExtend(res, this.bitend - this.bitstart) : TokenField.zeroExtend(res, this.bitend - this.bitstart);
        return res;
    }

    public int getBitStart() {
        return this.bitstart;
    }

    public int getBitEnd() {
        return this.bitend;
    }

    public int getByteStart() {
        return this.bytestart;
    }

    public int getByteEnd() {
        return this.byteend;
    }

    @Override
    public void decode(Decoder decoder, SleighLanguage lang) throws DecoderException {
        int el = decoder.openElement(SlaFormat.ELEM_TOKENFIELD);
        this.bigendian = decoder.readBool(SlaFormat.ATTRIB_BIGENDIAN);
        this.signbit = decoder.readBool(SlaFormat.ATTRIB_SIGNBIT);
        this.bitstart = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_STARTBIT);
        this.bitend = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_ENDBIT);
        this.bytestart = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_STARTBYTE);
        this.byteend = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_ENDBYTE);
        this.shift = (int)decoder.readSignedInteger(SlaFormat.ATTRIB_SHIFT);
        decoder.closeElement(el);
    }

    public boolean hasSignbit() {
        return this.signbit;
    }

    private long getInstructionBytes(ParserWalker walker) throws MemoryAccessException {
        long tmp;
        int size;
        int tmpsize;
        long res = 0L;
        int bs = this.bytestart;
        for (tmpsize = size = this.byteend - this.bytestart + 1; tmpsize >= 4; tmpsize -= 4) {
            tmp = walker.getInstructionBytes(bs, 4);
            res <<= 32;
            res |= tmp & 0xFFFFFFFFL;
            bs += 4;
        }
        if (tmpsize > 0) {
            tmp = walker.getInstructionBytes(bs, tmpsize);
            res <<= 8 * tmpsize;
            res |= tmp & 0xFFFFFFFFL;
        }
        if (!this.bigendian) {
            res = TokenField.byteSwap(res, size);
        }
        return res;
    }

    public static long signExtend(long val, int bit) {
        long mask = 0L;
        mask = (mask ^ 0xFFFFFFFFFFFFFFFFL) << bit;
        val = (val >> bit & 1L) != 0L ? (val |= mask) : (val &= mask ^ 0xFFFFFFFFFFFFFFFFL);
        return val;
    }

    public static long zeroExtend(long val, int bit) {
        long mask = 0L;
        mask = (mask ^ 0xFFFFFFFFFFFFFFFFL) << bit;
        return val &= (mask <<= 1) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long byteSwap(long val, int size) {
        long res = 0L;
        while (size > 0) {
            res <<= 8;
            res |= val & 0xFFL;
            val >>= 8;
            --size;
        }
        return res;
    }

    public boolean isBigEndian() {
        return this.bigendian;
    }

    public int getShift() {
        return this.shift;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[ins(" + this.bitstart + "," + this.bitend + ")");
        if (this.signbit) {
            sb.append(", signed");
        }
        if (this.bigendian) {
            sb.append(", bigendian");
        }
        sb.append(", bytes " + this.bytestart + "-" + this.byteend);
        sb.append(", shift=" + this.shift);
        sb.append("]");
        return sb.toString();
    }
}

