/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.disassemble;

import ghidra.app.util.PseudoInstruction;
import ghidra.program.disassemble.DisassemblerContextImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.DisassemblerContextAdapter;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.lang.InsufficientBytesException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ParallelInstructionLanguageHelper;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ProgramContextImpl;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class ReDisassembler {
    protected final Language language;
    protected final AddressFactory addrFactory;
    protected final Register ctxRegister;
    protected final ParallelInstructionLanguageHelper parallelHelper;
    private final Program program;
    private final Listing listing;
    private final ProgramContext programContext;

    public ReDisassembler(Program program) {
        this.program = program;
        this.listing = program.getListing();
        this.programContext = program.getProgramContext();
        this.language = program.getLanguage();
        this.addrFactory = program.getAddressFactory();
        this.ctxRegister = this.language.getContextBaseRegister();
        this.parallelHelper = this.language.getParallelInstructionHelper();
    }

    public AddressSetView disasemble(Address seed, TaskMonitor monitor) throws CancelledException {
        ReDisState state = new ReDisState(monitor);
        state.addSeed(seed);
        InstructionSet set = state.disassemble();
        for (AddressRange range : set.getAddressSet()) {
            this.listing.clearCodeUnits(range.getMinAddress(), range.getMaxAddress(), true, monitor);
        }
        state.writeContext();
        try {
            this.listing.addInstructions(set, false);
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)this, (Object)"Could not overwrite with re-disassembly", (Throwable)((Object)e));
        }
        return set.getAddressSet();
    }

    protected class ReDisState {
        protected final TaskMonitor monitor;
        protected final Map<AddressSpace, MemBuffer> progMemBuffers = new HashMap<AddressSpace, MemBuffer>();
        protected final ProgramContext tempContext;
        protected final AddressSet visited;
        protected final Deque<Flow> queue;
        protected final InstructionSet instructionSet;
        protected final Set<Address> ctxAddrs;

        public ReDisState(TaskMonitor monitor) {
            this.tempContext = new ProgramContextImpl(ReDisassembler.this.language);
            this.visited = new AddressSet();
            this.queue = new LinkedList<Flow>();
            this.instructionSet = new InstructionSet(ReDisassembler.this.addrFactory);
            this.ctxAddrs = new TreeSet<Address>();
            this.monitor = monitor;
            this.monitor.setMessage("Re-disassembling");
        }

        protected ReDisState addSeed(Address seed) {
            RegisterValue seedCtx = ReDisassembler.this.programContext.getRegisterValue(ReDisassembler.this.ctxRegister, seed);
            try {
                if (seedCtx == null) {
                    this.tempContext.remove(seed, seed, ReDisassembler.this.ctxRegister);
                } else {
                    this.tempContext.setRegisterValue(seed, seed, seedCtx);
                }
            }
            catch (ContextChangeException e) {
                throw new AssertionError((Object)e);
            }
            return this.addFlow(Flow.seed(seed));
        }

        protected ReDisState addFlow(Flow flow) {
            this.queue.add(flow);
            return this;
        }

        protected MemBuffer createBuffer(Address at) {
            return this.progMemBuffers.computeIfAbsent(at.getAddressSpace(), space -> new DumbMemBufferImpl(ReDisassembler.this.program.getMemory(), space.getMinAddress()));
        }

        protected boolean nextBlock() throws CancelledException {
            this.monitor.checkCancelled();
            this.instructionSet.addBlock(new ReDisBlock(this, this.queue.pop()).disassembleBlock());
            return !this.queue.isEmpty();
        }

        protected InstructionSet disassemble() throws CancelledException {
            while (this.nextBlock()) {
            }
            return this.instructionSet;
        }

        public void writeContext() {
            for (Address addr : this.ctxAddrs) {
                RegisterValue newCtxVal;
                RegisterValue curCtxVal = ReDisassembler.this.programContext.getRegisterValue(ReDisassembler.this.ctxRegister, addr);
                if (Objects.equals(curCtxVal, newCtxVal = this.tempContext.getRegisterValue(ReDisassembler.this.ctxRegister, addr))) continue;
                try {
                    if (newCtxVal == null) {
                        ReDisassembler.this.programContext.remove(addr, addr, ReDisassembler.this.ctxRegister);
                        continue;
                    }
                    ReDisassembler.this.programContext.setRegisterValue(addr, addr, newCtxVal);
                }
                catch (ContextChangeException e) {
                    Msg.error((Object)this, (Object)("Cannot write context at " + String.valueOf(addr) + ": " + String.valueOf((Object)e)));
                }
            }
        }
    }

    protected class ReDisassemblerContext
    implements DisassemblerContextAdapter {
        protected final ReDisState state;
        protected final Flow flow;

        public ReDisassemblerContext(ReDisassembler this$0, ReDisState state, Flow flow) {
            this.state = state;
            this.flow = flow;
        }

        @Override
        public void setFutureRegisterValue(Address address, RegisterValue value) {
            this.state.addFlow(this.flow.globalSet(address));
            try {
                this.state.tempContext.setRegisterValue(address, address, value);
                this.state.ctxAddrs.add(address);
            }
            catch (ContextChangeException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public RegisterValue getRegisterValue(Register register) {
            return this.state.tempContext.getRegisterValue(register, this.flow.to);
        }
    }

    protected class ReDisBlock {
        protected final ReDisState state;
        protected final Flow entry;
        protected final InstructionBlock block;
        protected final DisassemblerContextImpl disassemblerContext;
        protected PseudoInstruction lastInstruction;

        public ReDisBlock(ReDisState state, Flow entry) {
            this.state = state;
            this.entry = entry;
            this.block = new InstructionBlock(entry.to);
            this.disassemblerContext = new DisassemblerContextImpl(state.tempContext);
            this.disassemblerContext.flowStart(entry.to);
        }

        protected void recordContext(Address to) {
            RegisterValue ctxValue = this.disassemblerContext.getRegisterValue(ReDisassembler.this.ctxRegister);
            try {
                if (ctxValue == null) {
                    this.state.tempContext.remove(to, to, ReDisassembler.this.ctxRegister);
                } else {
                    this.state.tempContext.setRegisterValue(to, to, ctxValue);
                }
                this.state.ctxAddrs.add(to);
            }
            catch (ContextChangeException e) {
                throw new AssertionError((Object)e);
            }
        }

        protected PseudoInstruction createInstruction(Address address, InstructionPrototype prototype, MemBuffer memBuffer, ProcessorContext ctx) throws AddressOverflowException {
            PseudoInstruction instruction = new PseudoInstruction(ReDisassembler.this.program, address, prototype, memBuffer, ctx);
            instruction.setInstructionBlock(this.block);
            this.lastInstruction = instruction;
            return this.lastInstruction;
        }

        protected boolean shouldDisassemble(Flow flow) {
            Instruction exists = ReDisassembler.this.listing.getInstructionContaining(flow.to);
            if (exists == null) {
                return false;
            }
            if (flow.type == FlowType.FALLTHROUGH) {
                return true;
            }
            return exists.getAddress().equals(flow.to);
        }

        protected Instruction nextInstruction(Flow flow, boolean isInDelaySlot) throws CancelledException {
            RegisterValue curCtxVal;
            this.state.monitor.checkCancelled();
            if (this.state.visited.contains(flow.to)) {
                return null;
            }
            this.recordContext(flow.to);
            if (!this.shouldDisassemble(flow)) {
                return null;
            }
            MemBuffer buffer = this.state.createBuffer(flow.to);
            RegisterValue newCtxVal = this.disassemblerContext.getRegisterValue(ReDisassembler.this.ctxRegister);
            if (Objects.equals(newCtxVal, curCtxVal = ReDisassembler.this.programContext.getRegisterValue(ReDisassembler.this.ctxRegister, flow.to)) && flow.type != FlowType.SEED) {
                return null;
            }
            ReDisassemblerContext ctx = new ReDisassemblerContext(ReDisassembler.this, this.state, flow);
            try {
                InstructionPrototype prototype = ReDisassembler.this.language.parse(buffer, ctx, false);
                return this.createInstruction(flow.to, prototype, buffer, ctx);
            }
            catch (UnknownInstructionException e) {
                this.block.setParseConflict(flow.from, this.disassemblerContext.getRegisterValue(this.disassemblerContext.getBaseContextRegister()), flow.to, e.getMessage());
                return null;
            }
            catch (InsufficientBytesException e) {
                this.block.setInstructionMemoryError(flow.to, flow.from, e.getMessage());
                return null;
            }
            catch (AddressOverflowException e) {
                this.block.setInstructionMemoryError(flow.to, flow.from, "Instruction does not fit within address space constraint");
                return null;
            }
        }

        protected Flow nextInstructionsWithDelays(Flow flow) throws CancelledException {
            Instruction instruction = this.nextInstruction(flow, false);
            if (instruction == null) {
                return null;
            }
            boolean hasFallthrough = instruction.hasFallthrough();
            try {
                flow = Flow.fallThrough(instruction);
                this.block.addInstruction(instruction);
                this.processInstruction(instruction);
                this.disassemblerContext.flowToAddress(flow.to);
                for (int remainingBytes = instruction.getPrototype().getDelaySlotByteCount(); remainingBytes > 0; remainingBytes -= instruction.getLength()) {
                    instruction = this.nextInstruction(flow, true);
                    if (instruction == null) {
                        return null;
                    }
                    flow = Flow.fallThrough(instruction);
                    this.block.addInstruction(instruction);
                    this.processInstruction(instruction);
                }
                return hasFallthrough ? flow : null;
            }
            catch (AddressOverflowException e) {
                this.block.setInstructionMemoryError(flow.to, flow.from, "Failed to properly process delay slot at end of address space");
                return null;
            }
        }

        protected void processInstruction(Instruction instruction) {
            this.state.visited.add(instruction.getMinAddress(), instruction.getMaxAddress());
            for (Address to : instruction.getFlows()) {
                this.recordContext(to);
                this.state.addFlow(Flow.branch(instruction, to));
            }
        }

        protected InstructionBlock disassembleBlock() throws CancelledException {
            Flow flow = this.entry;
            while (flow != null) {
                flow = this.nextInstructionsWithDelays(flow);
            }
            return this.block;
        }
    }

    record Flow(Address from, Address to, FlowType type) {
        static Flow seed(Address seed) {
            return new Flow(Address.NO_ADDRESS, seed, FlowType.SEED);
        }

        static Flow fallThrough(Instruction instruction) throws AddressOverflowException {
            return new Flow(instruction.getAddress(), instruction.getAddress().add(instruction.getLength()), FlowType.FALLTHROUGH);
        }

        static Flow branch(Instruction instruction, Address to) {
            return new Flow(instruction.getAddress(), to, FlowType.BRANCH);
        }

        Flow globalSet(Address address) {
            return new Flow(this.to, address, FlowType.GLOBALSET);
        }
    }

    static enum FlowType {
        SEED,
        FALLTHROUGH,
        BRANCH,
        GLOBALSET;

    }
}

