/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.ParamEntry;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParamListStandardOut;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.StorageClass;
import ghidra.program.model.lang.protorules.AssignAction;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class MultiSlotAssign
extends AssignAction {
    private StorageClass resourceType;
    private boolean consumeFromStack;
    private boolean consumeMostSig;
    private boolean enforceAlignment;
    private boolean justifyRight;
    private boolean adjacentEntries;
    private boolean allowBackfill;
    private ParamEntry[] tiles;
    private ParamEntry stackEntry;

    private void initializeEntries() throws InvalidInputException {
        this.tiles = this.resource.extractTiles(this.resourceType);
        this.stackEntry = this.resource.extractStack();
        if (this.tiles.length == 0) {
            throw new InvalidInputException("Could not find matching resources for action: join");
        }
        if (this.consumeFromStack && this.stackEntry == null) {
            throw new InvalidInputException("Cannot find matching <pentry> for action: join");
        }
    }

    protected MultiSlotAssign(ParamListStandard res) {
        super(res);
        this.resourceType = StorageClass.GENERAL;
        this.consumeFromStack = !(res instanceof ParamListStandardOut);
        this.consumeMostSig = false;
        this.enforceAlignment = false;
        this.justifyRight = false;
        this.adjacentEntries = true;
        this.allowBackfill = false;
        if (res.getEntry(0).isBigEndian()) {
            this.consumeMostSig = true;
            this.justifyRight = true;
        }
        this.stackEntry = null;
    }

    public MultiSlotAssign(StorageClass store, boolean stack, boolean mostSig, boolean align, boolean justRight, boolean backfill, ParamListStandard res) throws InvalidInputException {
        super(res);
        this.resourceType = store;
        this.consumeFromStack = stack;
        this.consumeMostSig = mostSig;
        this.enforceAlignment = align;
        this.justifyRight = justRight;
        this.adjacentEntries = true;
        this.allowBackfill = backfill;
        this.stackEntry = null;
        this.initializeEntries();
    }

    @Override
    public AssignAction clone(ParamListStandard newResource) throws InvalidInputException {
        return new MultiSlotAssign(this.resourceType, this.consumeFromStack, this.consumeMostSig, this.enforceAlignment, this.justifyRight, this.allowBackfill, newResource);
    }

    @Override
    public boolean isEquivalent(AssignAction op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        MultiSlotAssign otherAction = (MultiSlotAssign)op;
        if (this.consumeFromStack != otherAction.consumeFromStack || this.consumeMostSig != otherAction.consumeMostSig || this.enforceAlignment != otherAction.enforceAlignment || this.justifyRight != otherAction.justifyRight || this.adjacentEntries != otherAction.adjacentEntries || this.allowBackfill != otherAction.allowBackfill) {
            return false;
        }
        if (this.resourceType != otherAction.resourceType) {
            return false;
        }
        if (this.tiles.length != otherAction.tiles.length) {
            return false;
        }
        for (int i = 0; i < this.tiles.length; ++i) {
            if (this.tiles[i].isEquivalent(otherAction.tiles[i])) continue;
            return false;
        }
        if (this.stackEntry != null || otherAction.stackEntry != null) {
            if (this.stackEntry != null && otherAction.stackEntry != null) {
                if (!this.stackEntry.isEquivalent(otherAction.stackEntry)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean checkFit(int iter, int sizeLeft, int align, int resourcesConsumed, int[] tmpStatus) {
        int regSize;
        ParamEntry entry = this.tiles[iter];
        if (tmpStatus[entry.getGroup()] != 0) {
            return false;
        }
        if (this.enforceAlignment && align > (regSize = entry.getSize()) && resourcesConsumed % align != 0) {
            return false;
        }
        if (!this.adjacentEntries) {
            return true;
        }
        while (iter != this.tiles.length && sizeLeft > 0) {
            entry = this.tiles[iter];
            if (tmpStatus[entry.getGroup()] != 0) {
                return false;
            }
            sizeLeft -= entry.getSize();
        }
        return true;
    }

    @Override
    public int assignAddress(DataType dt, PrototypePieces proto, int pos, DataTypeManager dtManager, int[] status, ParameterPieces res) {
        Varnode vn;
        ParamEntry entry;
        int iter;
        int[] tmpStatus = (int[])status.clone();
        ArrayList<Varnode> pieces = new ArrayList<Varnode>();
        ParameterPieces param = new ParameterPieces();
        int sizeLeft = dt.getLength();
        int align = dt.getAlignment();
        int resourcesConsumed = 0;
        for (iter = 0; iter != this.tiles.length && !this.checkFit(iter, sizeLeft, align, resourcesConsumed, tmpStatus); ++iter) {
            entry = this.tiles[iter];
            if (!this.allowBackfill) {
                tmpStatus[entry.getGroup()] = -1;
            }
            resourcesConsumed += entry.getSize();
        }
        while (sizeLeft > 0 && iter != this.tiles.length) {
            entry = this.tiles[iter];
            ++iter;
            if (tmpStatus[entry.getGroup()] != 0) continue;
            int trialSize = entry.getSize();
            entry.getAddrBySlot(tmpStatus[entry.getGroup()], trialSize, align, param);
            tmpStatus[entry.getGroup()] = -1;
            vn = new Varnode(param.address, trialSize);
            pieces.add(vn);
            sizeLeft -= trialSize;
            align = 1;
        }
        boolean onePieceJoin = false;
        if (sizeLeft > 0) {
            if (!this.consumeFromStack) {
                return 1;
            }
            int grp = this.stackEntry.getGroup();
            tmpStatus[grp] = this.stackEntry.getAddrBySlot(tmpStatus[grp], sizeLeft, align, param);
            if (param.address == null) {
                return 1;
            }
            vn = new Varnode(param.address, sizeLeft);
            pieces.add(vn);
        } else if (sizeLeft < 0) {
            if (this.resourceType == StorageClass.FLOAT && pieces.size() == 1) {
                onePieceJoin = true;
            } else if (this.justifyRight) {
                Varnode vn2 = (Varnode)pieces.get(0);
                Address addr = vn2.getAddress().add(-sizeLeft);
                int sz = vn2.getSize() + sizeLeft;
                vn2 = new Varnode(addr, sz);
                pieces.set(0, vn2);
            } else {
                int end = pieces.size() - 1;
                vn = (Varnode)pieces.get(end);
                int sz = vn.getSize() + sizeLeft;
                vn = new Varnode(vn.getAddress(), sz);
                pieces.set(end, vn);
            }
        }
        System.arraycopy(tmpStatus, 0, status, 0, tmpStatus.length);
        res.type = dt;
        res.assignAddressFromPieces(pieces, this.consumeMostSig, onePieceJoin, this.resource.getLanguage());
        return 0;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_JOIN);
        if (this.resource.getEntry(0).isBigEndian() != this.justifyRight) {
            encoder.writeBool(AttributeId.ATTRIB_REVERSEJUSTIFY, true);
        }
        if (this.resourceType != StorageClass.GENERAL) {
            encoder.writeString(AttributeId.ATTRIB_STORAGE, this.resourceType.toString());
        }
        encoder.writeBool(AttributeId.ATTRIB_ALIGN, this.enforceAlignment);
        encoder.writeBool(AttributeId.ATTRIB_STACKSPILL, this.consumeFromStack);
        encoder.writeBool(AttributeId.ATTRIB_BACKFILL, this.allowBackfill);
        encoder.closeElement(ElementId.ELEM_JOIN);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_JOIN.name()});
        for (Map.Entry attrib : elem.getAttributes().entrySet()) {
            String name = (String)attrib.getKey();
            if (name.equals(AttributeId.ATTRIB_REVERSEJUSTIFY.name())) {
                if (!SpecXmlUtils.decodeBoolean((String)((String)attrib.getValue()))) continue;
                this.justifyRight = !this.justifyRight;
                continue;
            }
            if (name.equals(AttributeId.ATTRIB_STORAGE.name())) {
                this.resourceType = StorageClass.getClass((String)attrib.getValue());
                continue;
            }
            if (name.equals(AttributeId.ATTRIB_ALIGN.name())) {
                this.enforceAlignment = SpecXmlUtils.decodeBoolean((String)((String)attrib.getValue()));
                continue;
            }
            if (name.equals(AttributeId.ATTRIB_STACKSPILL.name())) {
                this.consumeFromStack = SpecXmlUtils.decodeBoolean((String)((String)attrib.getValue()));
                continue;
            }
            if (!name.equals(AttributeId.ATTRIB_BACKFILL.name())) continue;
            this.allowBackfill = SpecXmlUtils.decodeBoolean((String)((String)attrib.getValue()));
        }
        parser.end(elem);
        try {
            this.initializeEntries();
        }
        catch (InvalidInputException e) {
            throw new XmlParseException(e.getMessage());
        }
    }
}

