/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.DBHandle;
import db.DBParms;
import db.DBRecord;
import db.RecordIterator;
import db.Schema;
import db.Table;
import db.TableRecord;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

class MasterTable {
    private TableRecord masterRecord;
    private DBHandle dbh;
    private DBParms dbParms;
    private Table table;
    TableRecord[] tableRecords;
    private long nextTableNum = 0L;

    MasterTable(DBHandle dbh) throws IOException {
        this.dbh = dbh;
        this.dbParms = dbh.getDBParms();
        this.masterRecord = new TableRecord(0L, "MASTER", TableRecord.getTableRecordSchema(), -1);
        try {
            this.masterRecord.setRootBufferId(this.dbParms.get(DBParms.MASTER_TABLE_ROOT_BUFFER_ID_PARM));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException("Corrupt database parameters", e);
        }
        this.table = new Table(dbh, this.masterRecord);
        ArrayList<TableRecord> trList = new ArrayList<TableRecord>();
        RecordIterator it = this.table.iterator();
        while (it.hasNext()) {
            trList.add(new TableRecord(dbh, it.next()));
        }
        this.tableRecords = new TableRecord[trList.size()];
        trList.toArray(this.tableRecords);
        if (this.tableRecords.length > 0) {
            this.nextTableNum = this.tableRecords[this.tableRecords.length - 1].getTableNum() + 1L;
        }
    }

    TableRecord createTableRecord(String name, Schema tableSchema, int indexedColumn) throws IOException {
        TableRecord tableRecord = new TableRecord(this.nextTableNum++, name, tableSchema, indexedColumn);
        this.table.putRecord(tableRecord.getRecord());
        this.dbParms.set(DBParms.MASTER_TABLE_ROOT_BUFFER_ID_PARM, this.masterRecord.getRootBufferId());
        Object[] newList = new TableRecord[this.tableRecords.length + 1];
        System.arraycopy(this.tableRecords, 0, newList, 0, this.tableRecords.length);
        newList[this.tableRecords.length] = tableRecord;
        Arrays.sort(newList);
        this.tableRecords = newList;
        return tableRecord;
    }

    void deleteTableRecord(long tableNum) throws IOException {
        for (int i = 0; i < this.tableRecords.length; ++i) {
            if (this.tableRecords[i].getTableNum() != tableNum) continue;
            if (this.tableRecords[i].getRootBufferId() >= 0) {
                throw new IOException("Can not delete non-empty table");
            }
            this.table.deleteRecord(tableNum);
            this.tableRecords[i].invalidate();
            this.dbParms.set(DBParms.MASTER_TABLE_ROOT_BUFFER_ID_PARM, this.masterRecord.getRootBufferId());
            TableRecord[] newList = new TableRecord[this.tableRecords.length - 1];
            System.arraycopy(this.tableRecords, 0, newList, 0, i);
            System.arraycopy(this.tableRecords, i + 1, newList, i, this.tableRecords.length - i - 1);
            this.tableRecords = newList;
            return;
        }
        throw new IOException("Table not found");
    }

    TableRecord[] getTableRecords() {
        return this.tableRecords;
    }

    TableRecord[] refreshTableRecords() throws IOException {
        try {
            int masterRootId = this.dbParms.get(DBParms.MASTER_TABLE_ROOT_BUFFER_ID_PARM);
            if (this.masterRecord.getRootBufferId() != masterRootId) {
                this.masterRecord.setRootBufferId(masterRootId);
                this.table.tableRecordChanged();
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException("Corrupt database parameters", e);
        }
        ArrayList<TableRecord> trList = new ArrayList<TableRecord>();
        int ix = 0;
        int oldTableCnt = this.tableRecords.length;
        RecordIterator it = this.table.iterator();
        while (it.hasNext()) {
            DBRecord rec = it.next();
            long tablenum = rec.getKey();
            while (ix < this.tableRecords.length && tablenum > this.tableRecords[ix].getTableNum()) {
                this.tableRecords[ix++].invalidate();
            }
            if (ix == oldTableCnt || tablenum < this.tableRecords[ix].getTableNum()) {
                trList.add(new TableRecord(this.dbh, rec));
                continue;
            }
            if (tablenum != this.tableRecords[ix].getTableNum()) continue;
            this.tableRecords[ix].setRecord(this.dbh, rec);
            trList.add(this.tableRecords[ix++]);
        }
        while (ix < this.tableRecords.length) {
            this.tableRecords[ix++].invalidate();
        }
        this.tableRecords = trList.toArray(new TableRecord[trList.size()]);
        return this.tableRecords;
    }

    void flush() throws IOException {
        for (int i = 0; i < this.tableRecords.length; ++i) {
            DBRecord rec = this.tableRecords[i].getRecord();
            if (!rec.isDirty()) continue;
            this.table.putRecord(rec);
        }
    }

    void changeTableName(String oldName, String newName) {
        for (int i = 0; i < this.tableRecords.length; ++i) {
            if (!oldName.equals(this.tableRecords[i].getName())) continue;
            this.tableRecords[i].setName(newName);
        }
    }
}

