/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.art.ArtConstants;
import ghidra.file.formats.android.art.ArtHeader;
import ghidra.file.formats.android.art.UnsupportedArtVersionException;
import ghidra.file.formats.android.art.headers.ArtHeader_005;
import ghidra.file.formats.android.art.headers.ArtHeader_009;
import ghidra.file.formats.android.art.headers.ArtHeader_012;
import ghidra.file.formats.android.art.headers.ArtHeader_017;
import ghidra.file.formats.android.art.headers.ArtHeader_029;
import ghidra.file.formats.android.art.headers.ArtHeader_030;
import ghidra.file.formats.android.art.headers.ArtHeader_043;
import ghidra.file.formats.android.art.headers.ArtHeader_044;
import ghidra.file.formats.android.art.headers.ArtHeader_046;
import ghidra.file.formats.android.art.headers.ArtHeader_056;
import ghidra.file.formats.android.art.headers.ArtHeader_074;
import ghidra.file.formats.android.art.headers.ArtHeader_085;
import ghidra.file.formats.android.art.headers.ArtHeader_099;
import ghidra.file.formats.android.art.headers.ArtHeader_106;
import java.io.IOException;

public final class ArtHeaderFactory {
    public static final ArtHeader newArtHeader(BinaryReader reader) throws IOException, UnsupportedArtVersionException {
        String magic = new String(reader.readByteArray(0L, "art\n".length()));
        String version = reader.readAsciiString(4L, 4);
        if (magic.equals("art\n") && ArtConstants.isSupportedVersion(version)) {
            switch (version) {
                case "005": {
                    return new ArtHeader_005(reader);
                }
                case "009": {
                    return new ArtHeader_009(reader);
                }
                case "012": {
                    return new ArtHeader_012(reader);
                }
                case "017": {
                    return new ArtHeader_017(reader);
                }
                case "029": {
                    return new ArtHeader_029(reader);
                }
                case "030": {
                    return new ArtHeader_030(reader);
                }
                case "043": {
                    return new ArtHeader_043(reader);
                }
                case "044": {
                    return new ArtHeader_044(reader);
                }
                case "046": {
                    return new ArtHeader_046(reader);
                }
                case "056": {
                    return new ArtHeader_056(reader);
                }
                case "074": {
                    return new ArtHeader_074(reader);
                }
                case "085": {
                    return new ArtHeader_085(reader);
                }
                case "099": {
                    return new ArtHeader_099(reader);
                }
                case "106": {
                    return new ArtHeader_106(reader);
                }
            }
        }
        throw new UnsupportedArtVersionException(magic, version);
    }
}

