/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.cparser;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.cparser.CParserTask;
import ghidra.app.plugin.core.cparser.ParseDialog;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.cparser.C.CParserUtils;
import ghidra.app.util.cparser.CPP.ParseException;
import ghidra.framework.Application;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Analysis", shortDescription="C Code Parser", description="Parse C and C Header files, extracting data definitions and function signatures.")
public class CParserPlugin
extends ProgramPlugin {
    public static final String PARSE_ACTION_NAME = "Import C DataTypes";
    static final String USER_PROFILES_DIR = Application.getUserSettingsDirectory().getAbsolutePath() + File.separatorChar + "parserprofiles";
    private ParseDialog parseDialog;
    private File userProfileDir;
    private CParserUtils.CParseResults results;
    static final String DESCRIPTION = "Parse C and C Header files, extracting data definitions and function signatures.";

    public CParserPlugin(PluginTool plugintool) {
        super(plugintool);
        this.createActions();
        this.setUserProfileDir(USER_PROFILES_DIR);
    }

    void setUserProfileDir(String path) {
        this.userProfileDir = new File(path);
        this.userProfileDir.mkdir();
    }

    File getUserProfileDir() {
        return this.userProfileDir;
    }

    public boolean isSingleton() {
        return true;
    }

    public Program getProgram() {
        return this.currentProgram;
    }

    public void dispose() {
        if (this.parseDialog != null) {
            this.parseDialog.close();
            this.parseDialog = null;
        }
    }

    public void readDataState(SaveState saveState) {
        this.parseDialog = new ParseDialog(this);
        this.parseDialog.readState(saveState);
    }

    public void writeDataState(SaveState saveState) {
        if (this.parseDialog != null) {
            this.parseDialog.writeState(saveState);
        }
    }

    protected boolean canClose() {
        if (this.parseDialog != null) {
            this.parseDialog.closeProfile();
        }
        return true;
    }

    private void createActions() {
        DockingAction parseAction = new DockingAction(PARSE_ACTION_NAME, this.getName()){

            public void actionPerformed(ActionContext context) {
                CParserPlugin.this.showParseDialog();
            }
        };
        String[] menuPath = new String[]{"&File", "Parse C Source..."};
        MenuData menuData = new MenuData(menuPath, "Import/Export");
        menuData.setMenuSubGroup("d");
        parseAction.setMenuBarData(menuData);
        parseAction.setDescription(DESCRIPTION);
        parseAction.setHelpLocation(new HelpLocation(this.getName(), "Parse_C_Source"));
        parseAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)parseAction);
    }

    protected void showParseDialog() {
        if (this.parseDialog == null) {
            this.parseDialog = new ParseDialog(this);
        }
        this.parseDialog.setupForDisplay();
        this.tool.showDialog((DialogComponentProvider)this.parseDialog);
    }

    protected void parse(String[] filenames, String[] includePaths, String options, String languageIDString, String compilerSpecID, String dataFilename) {
        CParserTask parseTask = new CParserTask(this, dataFilename).setFileNames(filenames).setIncludePaths(includePaths).setOptions(options).setLanguageID(languageIDString).setCompilerID(compilerSpecID);
        this.getTool().execute((Task)parseTask, 500);
    }

    protected CParserUtils.CParseResults parse(String[] filenames, String[] includePaths, String options, DataTypeManager dtMgr, TaskMonitor monitor) throws ghidra.app.util.cparser.C.ParseException, ParseException {
        this.results = null;
        String[] args = this.parseOptions(options);
        DataTypeManager[] openDTmanagers = null;
        try {
            openDTmanagers = this.getOpenDTMgrs();
        }
        catch (CancelledException exc) {
            return null;
        }
        this.results = CParserUtils.parseHeaderFiles(openDTmanagers, filenames, includePaths, args, dtMgr, monitor);
        return this.results;
    }

    boolean isOpenInTool(DataTypeManager dtm) {
        DataTypeManagerService dtService = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        if (dtService == null) {
            return false;
        }
        for (DataTypeManager openDtm : dtService.getDataTypeManagers()) {
            if (dtm != openDtm) continue;
            return true;
        }
        return false;
    }

    private DataTypeManager[] getOpenDTMgrs() throws CancelledException {
        DataTypeManager[] openDTmanagers = null;
        DataTypeManagerService dtService = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        if (dtService == null) {
            return openDTmanagers;
        }
        openDTmanagers = dtService.getDataTypeManagers();
        ArrayList<DataTypeManager> list = new ArrayList<DataTypeManager>();
        Object htmlNamesList = "";
        for (DataTypeManager openDTmanager : openDTmanagers) {
            if (openDTmanager instanceof ProgramDataTypeManager) continue;
            list.add(openDTmanager);
            if (openDTmanager instanceof BuiltInDataTypeManager) continue;
            htmlNamesList = (String)htmlNamesList + "<li><b>" + HTMLUtilities.escapeHTML((String)openDTmanager.getName()) + "</b></li>";
        }
        openDTmanagers = list.toArray(new DataTypeManager[0]);
        if (openDTmanagers.length > 1) {
            int result = OptionDialog.showOptionDialog((Component)this.parseDialog.getComponent(), (String)"Use Open Archives?", (String)("<html>The following archives are currently open: <ul>" + (String)htmlNamesList + "</ul><p><b>The new archive will become dependent on these archives<br>for any datatypes already defined in them </b>(only unique <br>data types will be added to the new archive)."), (String)"Use Open Archives", (String)"Don't Use Open Archives", (int)3);
            if (result == 0) {
                throw new CancelledException("User Cancelled");
            }
            if (result == 2) {
                return null;
            }
        }
        return openDTmanagers;
    }

    public CParserUtils.CParseResults getParseResults() {
        return this.results;
    }

    public String getParseMessage() {
        return this.results != null ? this.results.cParseMessages() : "";
    }

    protected String getFormattedParseMessage(String errMsg) {
        String msg;
        Object message = "<html>";
        if (errMsg != null) {
            message = (String)message + errMsg + "\n\n";
            message = HTMLUtilities.toHTML((String)message);
        }
        String string = msg = this.results == null ? null : this.results.cParseMessages();
        if (msg != null && msg.length() != 0) {
            message = (String)message + "<b>CParser Messages:</b><br>\n" + HTMLUtilities.toHTML((String)msg) + "<br>\n<br>\n";
        }
        String string2 = msg = this.results == null ? null : this.results.cppParseMessages();
        if (msg != null && msg.length() != 0) {
            message = (String)message + "<b>PreProcessor Messages:</b><br>\n" + HTMLUtilities.toHTML((String)msg);
        }
        return message;
    }

    protected void parse(String[] filenames, String[] includePaths, String options) {
        if (this.currentProgram == null) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.parseDialog.getComponent(), (String)"No Open Program", (Object)"A program must be open to \"Parse to Program\"");
            return;
        }
        LanguageCompilerSpecPair languageCompilerSpecPair = this.currentProgram.getLanguageCompilerSpecPair();
        String procID = languageCompilerSpecPair.languageID.getIdAsString();
        String compilerID = languageCompilerSpecPair.compilerSpecID.getIdAsString();
        int result = OptionDialog.showOptionDialog((Component)this.parseDialog.getComponent(), (String)"Confirm", (String)("Parse C source to \"" + this.currentProgram.getDomainFile().getName() + "\"?\n\nUsing program architecture: " + procID + " / " + compilerID), (String)"Continue");
        if (result == 0) {
            return;
        }
        CParserTask parseTask = new CParserTask(this, (DataTypeManager)this.currentProgram.getDataTypeManager()).setFileNames(filenames).setIncludePaths(includePaths).setOptions(options);
        this.tool.execute((Task)parseTask);
    }

    ParseDialog getDialog() {
        return this.parseDialog;
    }

    private String[] parseOptions(String options) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer toker = new StringTokenizer(options, "\r\n");
        while (toker.hasMoreTokens()) {
            String val = toker.nextToken();
            val = val.trim();
            StringBuffer arg = new StringBuffer();
            boolean parseQuote = false;
            int index = 0;
            block5: while (index < val.length()) {
                char ch = val.charAt(index++);
                switch (ch) {
                    case '\"': {
                        parseQuote = !parseQuote;
                        continue block5;
                    }
                    case '-': {
                        String sarg;
                        if (parseQuote || (sarg = arg.toString().trim()).length() <= 0) break;
                        list.add(sarg);
                    }
                }
                arg.append(ch);
            }
            String sarg = arg.toString().trim();
            if (sarg.length() <= 0) continue;
            list.add(sarg);
        }
        return list.toArray(new String[list.size()]);
    }
}

