/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import generic.util.Path;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.framework.model.DomainFile;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;

public class RecentlyOpenedArchiveAction
extends DockingAction {
    private static final String EXTENSIONS_PATH_PREFIX = "$GHIDRA_HOME/Extensions/Ghidra";
    private final String projectName;
    private final String archivePath;
    private final DataTypeManagerPlugin plugin;

    public RecentlyOpenedArchiveAction(DataTypeManagerPlugin plugin, String archivePath, String menuGroup) {
        super(menuGroup + ": \"" + archivePath + "\"", plugin.getName(), false);
        this.plugin = plugin;
        String[] projectPathname = DataTypeManagerHandler.parseProjectPathname(archivePath);
        if (projectPathname == null) {
            this.projectName = null;
            this.archivePath = archivePath;
        } else {
            this.projectName = projectPathname[0];
            this.archivePath = projectPathname[1];
        }
        String menuPath = RecentlyOpenedArchiveAction.getMenuPath(archivePath);
        this.setMenuBarData(new MenuData(new String[]{menuGroup, menuPath}, null, menuGroup));
        this.setDescription("Opens the indicated archive in the data type manager.");
        this.setEnabled(true);
    }

    private static String getMenuPath(String filepath) {
        if (filepath.contains("/data/typeinfo/")) {
            return RecentlyOpenedArchiveAction.getTypeInfoRelativeName(filepath);
        }
        String[] projectPathname = DataTypeManagerHandler.parseProjectPathname(filepath);
        if (projectPathname == null) {
            return filepath;
        }
        return projectPathname[0] + ":" + projectPathname[1];
    }

    private static String getExtensionName(String fullPath) {
        if (!fullPath.startsWith(EXTENSIONS_PATH_PREFIX)) {
            return "";
        }
        int start = EXTENSIONS_PATH_PREFIX.length() + 1;
        int slashIndex = fullPath.indexOf("/", start);
        if (slashIndex < 0) {
            return "";
        }
        return fullPath.substring(start, slashIndex) + ": ";
    }

    private static String getTypeInfoRelativeName(String fullPath) {
        String[] parts = fullPath.split("/data/typeinfo/");
        String relativePath = parts[1];
        String extensionName = RecentlyOpenedArchiveAction.getExtensionName(fullPath);
        return extensionName + relativePath;
    }

    public void actionPerformed(ActionContext context) {
        if (this.projectName == null) {
            DataTypeManagerHandler archiveManager = this.plugin.getDataTypeManagerHandler();
            Path path = new Path(this.archivePath);
            OpenArchiveTask task = new OpenArchiveTask(archiveManager, path);
            new TaskLauncher((Task)task, (Component)this.plugin.getProvider().getComponent());
        } else {
            DomainFile df = this.plugin.getProjectArchiveFile(this.projectName, this.archivePath);
            if (df != null) {
                this.plugin.openArchive(df);
            } else {
                Msg.showError((Object)((Object)this), null, (String)"Project Archive Open Error", (Object)("Project data type archive not found: " + this.getMenuBarData().getMenuItemName()));
            }
        }
    }

    private class OpenArchiveTask
    extends Task {
        private final Path taskArchivePath;
        private final DataTypeManagerHandler archiveManager;

        OpenArchiveTask(DataTypeManagerHandler archiveManager, Path archivePath) {
            super("Opening Archive " + archivePath.getPath().getName(), false, false, true);
            this.archiveManager = archiveManager;
            this.taskArchivePath = archivePath;
        }

        public void run(TaskMonitor monitor) {
            try {
                this.archiveManager.openArchive(this.taskArchivePath.getPath(), false, true);
            }
            catch (Exception e) {
                DataTypeManagerHandler.handleArchiveFileException(RecentlyOpenedArchiveAction.this.plugin, this.taskArchivePath.getPath(), e);
            }
        }
    }
}

