/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.archive;

import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.InvalidatedListener;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;

public class DataTypeIndexer {
    private List<DataTypeManager> dataTypeManagers = new ArrayList<DataTypeManager>();
    private List<DataType> dataTypeList = Collections.emptyList();
    private DataTypeIndexUpdateListener listener = new DataTypeIndexUpdateListener();
    private volatile boolean isStale = true;

    public synchronized void addDataTypeManager(DataTypeManager dataTypeManager) {
        if (!this.dataTypeManagers.contains(dataTypeManager)) {
            dataTypeManager.addDataTypeManagerListener((DataTypeManagerChangeListener)this.listener);
            dataTypeManager.addInvalidatedListener((InvalidatedListener)this.listener);
            this.dataTypeManagers.add(dataTypeManager);
            this.markStale();
        }
    }

    public synchronized void removeDataTypeManager(DataTypeManager dataTypeManager) {
        if (this.dataTypeManagers.contains(dataTypeManager)) {
            dataTypeManager.removeDataTypeManagerListener((DataTypeManagerChangeListener)this.listener);
            dataTypeManager.removeInvalidatedListener((InvalidatedListener)this.listener);
            this.dataTypeManagers.remove(dataTypeManager);
            this.markStale();
        }
    }

    public synchronized List<DataType> getSortedDataTypeList() {
        List<DataType> newList = this.updateDataTypeList();
        if (this.isStale) {
            return newList;
        }
        this.dataTypeList = newList;
        return Collections.unmodifiableList(newList);
    }

    private List<DataType> updateDataTypeList() {
        if (!this.isStale) {
            return this.dataTypeList;
        }
        this.isStale = false;
        IndexerTask task = new IndexerTask();
        if (SwingUtilities.isEventDispatchThread()) {
            TaskLauncher.launch((Task)task);
        } else {
            task.run(TaskMonitor.DUMMY);
        }
        List<DataType> newList = task.getList();
        return newList;
    }

    private void markStale() {
        this.isStale = true;
        this.dataTypeList = Collections.emptyList();
    }

    private class DataTypeIndexUpdateListener
    implements DataTypeManagerChangeListener,
    InvalidatedListener {
        private DataTypeIndexUpdateListener() {
        }

        public void dataTypeManagerInvalidated(DataTypeManager dataTypeManager) {
            DataTypeIndexer.this.markStale();
        }

        public void categoryAdded(DataTypeManager dtm, CategoryPath path) {
            DataTypeIndexer.this.markStale();
        }

        public void categoryMoved(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
            DataTypeIndexer.this.markStale();
        }

        public void categoryRemoved(DataTypeManager dtm, CategoryPath path) {
            DataTypeIndexer.this.markStale();
        }

        public void categoryRenamed(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
            DataTypeIndexer.this.markStale();
        }

        public void dataTypeAdded(DataTypeManager dtm, DataTypePath path) {
            DataTypeIndexer.this.markStale();
        }

        public void dataTypeChanged(DataTypeManager dtm, DataTypePath path) {
            DataTypeIndexer.this.markStale();
        }

        public void dataTypeMoved(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
            DataTypeIndexer.this.markStale();
        }

        public void dataTypeRemoved(DataTypeManager dtm, DataTypePath path) {
            DataTypeIndexer.this.markStale();
        }

        public void dataTypeRenamed(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
            DataTypeIndexer.this.markStale();
        }

        public void dataTypeReplaced(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath, DataType newDataType) {
            DataTypeIndexer.this.markStale();
        }

        public void favoritesChanged(DataTypeManager dtm, DataTypePath path, boolean isFavorite) {
        }

        public void sourceArchiveAdded(DataTypeManager dtm, SourceArchive dataTypeSource) {
            DataTypeIndexer.this.markStale();
        }

        public void sourceArchiveChanged(DataTypeManager dtm, SourceArchive dataTypeSource) {
            DataTypeIndexer.this.markStale();
        }

        public void programArchitectureChanged(DataTypeManager dataTypeManager) {
            DataTypeIndexer.this.markStale();
        }

        public void restored(DataTypeManager dataTypeManager) {
            DataTypeIndexer.this.markStale();
        }
    }

    private class IndexerTask
    extends Task {
        private List<DataType> list;

        IndexerTask() {
            super("Data Type Indexer Task", false, true, true);
            this.list = new ArrayList<DataType>();
        }

        public void run(TaskMonitor monitor) {
            monitor.initialize((long)DataTypeIndexer.this.dataTypeManagers.size());
            monitor.setMessage("Preparing to index data types...");
            for (DataTypeManager dataTypeManager : DataTypeIndexer.this.dataTypeManagers) {
                monitor.setMessage("Searching " + dataTypeManager.getName());
                dataTypeManager.getAllDataTypes(this.list);
                monitor.incrementProgress(1L);
            }
            Collections.sort(this.list, new CaseInsensitiveDataTypeComparator(DataTypeIndexer.this));
        }

        List<DataType> getList() {
            return this.list;
        }
    }

    private class CaseInsensitiveDataTypeComparator
    implements Comparator<DataType> {
        private CaseInsensitiveDataTypeComparator(DataTypeIndexer dataTypeIndexer) {
        }

        @Override
        public int compare(DataType dt1, DataType dt2) {
            String dtmName2;
            String name2;
            String name1 = dt1.getName();
            int result = name1.compareToIgnoreCase(name2 = dt2.getName());
            if (result != 0) {
                return result;
            }
            result = name1.compareTo(name2);
            if (result != 0) {
                return -result;
            }
            String dtmName1 = dt1.getDataTypeManager().getName();
            result = dtmName1.compareToIgnoreCase(dtmName2 = dt2.getDataTypeManager().getName());
            if (result != 0) {
                return result;
            }
            CategoryPath cp1 = dt1.getCategoryPath();
            CategoryPath cp2 = dt2.getCategoryPath();
            String p1 = cp1.getPath();
            String p2 = cp2.getPath();
            return p1.compareToIgnoreCase(p2);
        }
    }
}

