/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugin.importer;

import docking.DialogComponentProvider;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.framework.plugintool.PluginTool;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugin.importer.LcsSelectionEvent;
import ghidra.plugin.importer.NewLanguagePanel;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;

public class ImporterLanguageDialog
extends DialogComponentProvider {
    private PluginTool tool;
    private Collection<LoadSpec> loadSpecs;
    private NewLanguagePanel languagePanel;
    private boolean wasDialogCancelled = false;
    private LanguageCompilerSpecPair defaultSelectedLanguage;

    public ImporterLanguageDialog(Collection<LoadSpec> loadSpecs, PluginTool tool, LanguageCompilerSpecPair defaultSelectedLanguage) {
        super("Language", true);
        this.loadSpecs = loadSpecs;
        this.tool = tool;
        this.defaultSelectedLanguage = defaultSelectedLanguage;
        this.setHelpLocation(new HelpLocation("ImporterPlugin", "language_picker_dialog"));
    }

    public void show(Component parent) {
        Swing.runIfSwingOrRunLater(() -> {
            this.build();
            this.tool.showDialog((DialogComponentProvider)this, parent);
        });
    }

    private void build() {
        this.languagePanel = new NewLanguagePanel();
        this.languagePanel.setRecommendedLcsPairsList(new ArrayList<LanguageCompilerSpecPair>());
        this.languagePanel.setShowAllLcsPairs(false);
        this.languagePanel.getAccessibleContext().setAccessibleName("Language");
        this.languagePanel.setBorder(BorderFactory.createTitledBorder(" Select Language and Compiler Specification "));
        this.languagePanel.addSelectionListener(e -> {
            this.validateFormInput();
            if (e.getType() == LcsSelectionEvent.Type.PICKED && this.isOKEnabled()) {
                this.okCallback();
            }
        });
        this.initialize();
        this.addWorkPanel(this.languagePanel);
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        this.setOkEnabled(false);
        if (this.defaultSelectedLanguage != null) {
            this.languagePanel.setSelectedLcsPair(this.defaultSelectedLanguage);
        }
        this.validateFormInput();
    }

    private void initialize() {
        List<LanguageCompilerSpecPair> pairs = ImporterUtilities.getPairs(this.loadSpecs);
        this.languagePanel.setRecommendedLcsPairsList(pairs);
        this.languagePanel.setShowAllLcsPairs(pairs.isEmpty());
        this.languagePanel.setEnabled(true);
        this.selectPreferredLanguage();
    }

    protected void okCallback() {
        if (this.validateFormInput()) {
            this.close();
        }
    }

    protected void cancelCallback() {
        this.wasDialogCancelled = true;
        super.cancelCallback();
    }

    private boolean validateFormInput() {
        this.setOkEnabled(false);
        if (this.languagePanel.getSelectedLcsPair() == null) {
            this.setStatusText("Please select a language.");
            return false;
        }
        this.setStatusText("");
        this.setOkEnabled(true);
        return true;
    }

    private void selectPreferredLanguage() {
        ArrayList<LoadSpec> preferredLoadSpecs = new ArrayList<LoadSpec>();
        for (LoadSpec loadSpec : this.loadSpecs) {
            if (!loadSpec.isPreferred()) continue;
            preferredLoadSpecs.add(loadSpec);
        }
        if (preferredLoadSpecs.size() == 1) {
            this.languagePanel.setRecommendedLcsPair(((LoadSpec)preferredLoadSpecs.get(0)).getLanguageCompilerSpec());
        } else {
            this.languagePanel.setRecommendedLcsPair(null);
        }
    }

    LanguageCompilerSpecPair getSelectedLanguage() {
        if (this.wasDialogCancelled) {
            return null;
        }
        return this.languagePanel.getSelectedLcsPair();
    }
}

