/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization;

import ghidra.graph.visualization.GraphRenderer;
import ghidra.service.graph.AttributedEdge;
import java.util.Comparator;

public class EdgeComparator
implements Comparator<AttributedEdge> {
    private GraphRenderer renderer;

    public EdgeComparator(GraphRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public int compare(AttributedEdge edge1, AttributedEdge edge2) {
        String edgeType1 = edge1.getEdgeType();
        String edgeType2 = edge2.getEdgeType();
        if (edgeType1 == null && edgeType2 == null) {
            return 0;
        }
        if (edgeType1 == null) {
            return 1;
        }
        if (edgeType2 == null) {
            return -1;
        }
        Integer priority1 = this.renderer.getEdgePriority(edgeType1);
        Integer priority2 = this.renderer.getEdgePriority(edgeType2);
        return priority1.compareTo(priority2);
    }
}

