/*
 * Decompiled with CFR 0.152.
 */
package generic.theme.laf;

import generic.theme.Gui;
import generic.theme.laf.FontChangeListener;
import java.awt.Component;
import java.awt.Font;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ComponentFontRegistry {
    private Set<StyledComponent> components = ConcurrentHashMap.newKeySet();
    private String fontId;

    public ComponentFontRegistry(String fontId) {
        this.fontId = fontId;
    }

    public void addComponent(Component component) {
        this.addComponent(component, 0);
    }

    public void addComponent(Component component, int fontStyle) {
        StyledComponent sc = new StyledComponent(component, fontStyle);
        sc.setFont(Gui.getFont(this.fontId));
        this.components.add(sc);
    }

    public void removeComponent(Component component) {
        Iterator<StyledComponent> it = this.components.iterator();
        while (it.hasNext()) {
            StyledComponent sc = it.next();
            if (!sc.matches(component)) continue;
            it.remove();
            break;
        }
    }

    public void updateComponentFonts() {
        Font font = Gui.getFont(this.fontId);
        ArrayList<StyledComponent> copy = new ArrayList<StyledComponent>(this.components);
        for (StyledComponent c : copy) {
            if (!c.isValid()) {
                this.components.remove(c);
                continue;
            }
            c.setFont(font);
        }
    }

    private class StyledComponent {
        private int fontStyle;
        private WeakReference<Component> componentReference;

        StyledComponent(Component component, int fontStyle) {
            this.fontStyle = fontStyle;
            this.componentReference = new WeakReference<Component>(component);
        }

        boolean matches(Component c) {
            return this.componentReference.refersTo(c);
        }

        boolean isValid() {
            return !this.componentReference.refersTo(null);
        }

        void setFont(Font font) {
            Component component = (Component)this.componentReference.get();
            if (component == null) {
                return;
            }
            Font existingFont = component.getFont();
            Font styledFont = font;
            int style = this.fontStyle;
            if (style != 0) {
                styledFont = font.deriveFont(style);
            }
            if (Objects.equals(existingFont, styledFont)) {
                return;
            }
            if (component instanceof FontChangeListener) {
                FontChangeListener fontListener = (FontChangeListener)((Object)component);
                fontListener.fontChanged(ComponentFontRegistry.this.fontId, styledFont);
            } else {
                component.setFont(styledFont);
            }
        }
    }
}

