/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.client.tracermi;

import com.google.protobuf.ByteString;
import ghidra.app.plugin.core.debug.client.tracermi.ProtobufSocket;
import ghidra.app.plugin.core.debug.client.tracermi.RmiBatch;
import ghidra.app.plugin.core.debug.client.tracermi.RmiMethodRegistry;
import ghidra.app.plugin.core.debug.client.tracermi.RmiRemoteMethod;
import ghidra.app.plugin.core.debug.client.tracermi.RmiRemoteMethodParameter;
import ghidra.app.plugin.core.debug.client.tracermi.RmiReplyHandlerThread;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTrace;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTraceObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.RegisterValue;
import ghidra.rmi.trace.TraceRmi;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.target.schema.SchemaContext;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.model.target.schema.XmlSchemaContext;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jdom.JDOMException;

public class RmiClient {
    private final ProtobufSocket<TraceRmi.RootMessage> socket;
    private final String description;
    private int nextTraceId = 0;
    private volatile RmiBatch currentBatch = null;
    Map<Integer, RmiTrace> traces = new HashMap<Integer, RmiTrace>();
    private SchemaContext schemaContext;
    private RmiReplyHandlerThread handler;
    private static RmiMethodRegistry methodRegistry;
    private Deque<RequestResult> requests = new LinkedList<RequestResult>();

    public static TraceObjectSchema loadSchema(String resourceName, String rootName) {
        try {
            InputStream resourceAsStream = RmiClient.class.getResourceAsStream(resourceName);
            XmlSchemaContext schemaContext = XmlSchemaContext.deserialize((InputStream)resourceAsStream);
            return schemaContext.getSchema(schemaContext.name(rootName));
        }
        catch (IOException | JDOMException e) {
            throw new AssertionError((Object)e);
        }
    }

    public RmiClient(SocketChannel channel, String description) {
        this.socket = new ProtobufSocket<TraceRmi.RootMessage>(channel, TraceRmi.RootMessage::parseFrom);
        this.description = description;
        this.handler = new RmiReplyHandlerThread(this, this.socket);
        this.handler.start();
    }

    public String getDescription() {
        return this.description + " at " + this.socket.getRemoteAddress();
    }

    public void close() {
        this.handler.close();
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestResult send(TraceRmi.RootMessage msg) {
        try {
            RequestResult result = new RequestResult(msg);
            Deque<RequestResult> deque = this.requests;
            synchronized (deque) {
                this.socket.send(msg);
                this.requests.push(result);
            }
            RmiBatch cb = this.currentBatch;
            if (cb != null) {
                cb.append(result);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public RmiTrace createTrace(String path, LanguageID language, CompilerSpecID compiler) {
        if (compiler == null) {
            compiler = new CompilerSpecID("default");
        }
        int traceId = this.nextTraceId++;
        RequestResult result = this.send(TraceRmi.RootMessage.newBuilder().setRequestCreateTrace(TraceRmi.RequestCreateTrace.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setLanguage(TraceRmi.Language.newBuilder().setId(language.getIdAsString())).setCompiler(TraceRmi.Compiler.newBuilder().setId(compiler.getIdAsString())).setPath(TraceRmi.FilePath.newBuilder().setPath(path))).build());
        RmiTrace trace = new RmiTrace(this, traceId, result);
        this.traces.put(traceId, trace);
        return trace;
    }

    public void closeTrace(int id) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestCloseTrace(TraceRmi.RequestCloseTrace.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(id))).build());
        this.traces.remove(id);
    }

    public void saveTrace(int id) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestSaveTrace(TraceRmi.RequestSaveTrace.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(id))).build());
    }

    public void startTx(int traceId, String desc, boolean undoable, int txId) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestStartTx(TraceRmi.RequestStartTx.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setTxid(TraceRmi.TxId.newBuilder().setId(txId)).setDescription(desc).setUndoable(undoable)).build());
    }

    public void endTx(int traceId, int txId, boolean abort) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestEndTx(TraceRmi.RequestEndTx.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setTxid(TraceRmi.TxId.newBuilder().setId(txId)).setAbort(abort)).build());
    }

    public void snapshot(int traceId, String desc, String datetime, long snap) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestSnapshot(TraceRmi.RequestSnapshot.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setSnap(TraceRmi.Snap.newBuilder().setSnap(snap)).setDatetime(datetime).setDescription(desc)).build());
    }

    public void createOverlaySpace(int traceId, String base, String name) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestCreateOverlay(TraceRmi.RequestCreateOverlaySpace.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setBaseSpace(base).setName(name)).build());
    }

    public void putBytes(int traceId, long snap, Address start, byte[] data) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestPutBytes(TraceRmi.RequestPutBytes.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setSnap(TraceRmi.Snap.newBuilder().setSnap(snap)).setStart(TraceRmi.Addr.newBuilder().setSpace(start.getAddressSpace().getName()).setOffset(start.getOffset())).setData(ByteString.copyFrom((byte[])data))).build());
    }

    public void setMemoryState(int traceId, long snap, AddressRange range, TraceRmi.MemoryState state) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestSetMemoryState(TraceRmi.RequestSetMemoryState.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setSnap(TraceRmi.Snap.newBuilder().setSnap(snap)).setRange(TraceRmi.AddrRange.newBuilder().setSpace(range.getAddressSpace().getName()).setOffset(range.getMinAddress().getOffset()).setExtend(range.getLength() - 1L)).setState(state)).build());
    }

    public void deleteBytes(int traceId, long snap, AddressRange range) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestDeleteBytes(TraceRmi.RequestDeleteBytes.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setSnap(TraceRmi.Snap.newBuilder().setSnap(snap)).setRange(TraceRmi.AddrRange.newBuilder().setSpace(range.getAddressSpace().getName()).setOffset(range.getMinAddress().getOffset()).setExtend(range.getLength() - 1L))).build());
    }

    public void putRegisters(int traceId, long snap, String ppath, RegisterValue[] values) {
        TraceRmi.RequestPutRegisterValue.Builder builder = TraceRmi.RequestPutRegisterValue.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setSnap(TraceRmi.Snap.newBuilder().setSnap(snap)).setSpace(ppath);
        for (int i = 0; i < values.length; ++i) {
            RegisterValue rv = values[i];
            ByteString val = ByteString.copyFrom((byte[])rv.toBytes());
            rv.getUnsignedValue();
            builder.addValues(i, TraceRmi.RegVal.newBuilder().setName(rv.getRegister().getName()).setValue(val));
        }
        this.send(TraceRmi.RootMessage.newBuilder().setRequestPutRegisterValue(builder).build());
    }

    public void deleteRegisters(int traceId, long snap, String ppath, String[] names) {
        TraceRmi.RequestDeleteRegisterValue.Builder builder = TraceRmi.RequestDeleteRegisterValue.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setSnap(TraceRmi.Snap.newBuilder().setSnap(snap)).setSpace(ppath);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            builder.addNames(name);
        }
        this.send(TraceRmi.RootMessage.newBuilder().setRequestDeleteRegisterValue(builder).build());
    }

    public void createRootObject(int traceId, SchemaContext schemContext, String schema) {
        this.schemaContext = schemContext;
        String xmlCtx = XmlSchemaContext.serialize((SchemaContext)schemContext);
        this.send(TraceRmi.RootMessage.newBuilder().setRequestCreateRootObject(TraceRmi.RequestCreateRootObject.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setSchemaContext(xmlCtx).setRootSchema(schema)).build());
    }

    RequestResult createObject(int traceId, String path) {
        return this.send(TraceRmi.RootMessage.newBuilder().setRequestCreateObject(TraceRmi.RequestCreateObject.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setPath(TraceRmi.ObjPath.newBuilder().setPath(path))).build());
    }

    public void insertObject(int traceId, String path, Lifespan span, TraceRmi.Resolution r) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestInsertObject(TraceRmi.RequestInsertObject.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setObject(TraceRmi.ObjSpec.newBuilder().setPath(TraceRmi.ObjPath.newBuilder().setPath(path))).setSpan(TraceRmi.Span.newBuilder().setMin(span.lmin()).setMax(span.lmax())).setResolution(r)).build());
    }

    public void insertObject(int traceId, long id, Lifespan span, TraceRmi.Resolution r) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestInsertObject(TraceRmi.RequestInsertObject.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setObject(TraceRmi.ObjSpec.newBuilder().setId(id)).setSpan(TraceRmi.Span.newBuilder().setMin(span.lmin()).setMax(span.lmax())).setResolution(r)).build());
    }

    public void removeObject(int traceId, String path, Lifespan span, boolean tree) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestRemoveObject(TraceRmi.RequestRemoveObject.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setObject(TraceRmi.ObjSpec.newBuilder().setPath(TraceRmi.ObjPath.newBuilder().setPath(path))).setSpan(TraceRmi.Span.newBuilder().setMin(span.lmin()).setMax(span.lmax())).setTree(tree)).build());
    }

    public void removeObject(int traceId, long id, Lifespan span, boolean tree) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestRemoveObject(TraceRmi.RequestRemoveObject.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setObject(TraceRmi.ObjSpec.newBuilder().setId(id)).setSpan(TraceRmi.Span.newBuilder().setMin(span.lmin()).setMax(span.lmax())).setTree(tree)).build());
    }

    public void setValue(int traceId, String ppath, Lifespan span, String key, Object value, String resolution) {
        TraceRmi.Resolution r = resolution == null ? TraceRmi.Resolution.CR_ADJUST : TraceRmiResolution.valueOf((String)resolution).description;
        this.send(TraceRmi.RootMessage.newBuilder().setRequestSetValue(TraceRmi.RequestSetValue.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setValue(TraceRmi.ValSpec.newBuilder().setSpan(TraceRmi.Span.newBuilder().setMin(span.lmin()).setMax(span.lmax())).setParent(TraceRmi.ObjSpec.newBuilder().setPath(TraceRmi.ObjPath.newBuilder().setPath(ppath))).setKey(key).setValue(this.buildValue(value))).setResolution(r)).build());
    }

    public void retainValues(int traceId, String ppath, Lifespan span, TraceRmi.ValueKinds kinds, Set<String> keys) {
        TraceRmi.RequestRetainValues.Builder builder = TraceRmi.RequestRetainValues.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setObject(TraceRmi.ObjSpec.newBuilder().setPath(TraceRmi.ObjPath.newBuilder().setPath(ppath))).setSpan(TraceRmi.Span.newBuilder().setMin(span.lmin()).setMax(span.lmax())).setKinds(kinds).addAllKeys(keys);
        this.send(TraceRmi.RootMessage.newBuilder().setRequestRetainValues(builder).build());
    }

    public void getObject(int traceId, String path) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestGetObject(TraceRmi.RequestGetObject.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setObject(TraceRmi.ObjSpec.newBuilder().setPath(TraceRmi.ObjPath.newBuilder().setPath(path)))).build());
    }

    RequestResult getValues(int traceId, Lifespan span, String pattern) {
        return this.send(TraceRmi.RootMessage.newBuilder().setRequestGetValues(TraceRmi.RequestGetValues.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setSpan(TraceRmi.Span.newBuilder().setMin(span.lmin()).setMax(span.lmax())).setPattern(TraceRmi.ObjPath.newBuilder().setPath(pattern))).build());
    }

    RequestResult getValuesIntersecting(int traceId, Lifespan span, AddressRange range, String key) {
        return this.send(TraceRmi.RootMessage.newBuilder().setRequestGetValuesIntersecting(TraceRmi.RequestGetValuesIntersecting.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setBox(TraceRmi.Box.newBuilder().setSpan(TraceRmi.Span.newBuilder().setMin(span.lmin()).setMax(span.lmax())).setRange(TraceRmi.AddrRange.newBuilder().setSpace(range.getAddressSpace().getName()).setOffset(range.getMinAddress().getOffset()).setExtend(range.getLength()))).setKey(key)).build());
    }

    public RmiTraceObject proxyObjectId(int traceId, Long id) {
        return RmiTraceObject.fromId(this.traces.get(traceId), id);
    }

    public RmiTraceObject proxyObjectPath(int traceId, String path) {
        return RmiTraceObject.fromPath(this.traces.get(traceId), path);
    }

    public RmiTraceObject proxyObjectPath(int traceId, Long id, String path) {
        return new RmiTraceObject(this.traces.get(traceId), id, path);
    }

    private TraceRmi.Value.Builder buildValue(Object value) {
        TraceRmi.Value.Builder builder = TraceRmi.Value.newBuilder();
        if (value == null) {
            return builder.setNullValue(TraceRmi.Null.newBuilder());
        }
        if (value instanceof String) {
            String str = (String)value;
            return builder.setStringValue(str);
        }
        if (value instanceof Boolean) {
            Boolean bval = (Boolean)value;
            return builder.setBoolValue(bval);
        }
        if (value instanceof Short) {
            Short sval = (Short)value;
            return builder.setShortValue(sval.shortValue());
        }
        if (value instanceof Integer) {
            Integer ival = (Integer)value;
            return builder.setIntValue(ival);
        }
        if (value instanceof Long) {
            Long lval = (Long)value;
            return builder.setLongValue(lval);
        }
        if (value instanceof ByteString) {
            ByteString bstr = (ByteString)value;
            return builder.setBytesValue(bstr);
        }
        if (value instanceof Byte) {
            Byte b = (Byte)value;
            return builder.setByteValue(b.byteValue());
        }
        if (value instanceof Character) {
            Character c = (Character)value;
            return builder.setCharValue(c.charValue());
        }
        if (value instanceof Address) {
            Address address = (Address)value;
            TraceRmi.Addr.Builder addr = TraceRmi.Addr.newBuilder().setSpace(address.getAddressSpace().getName()).setOffset(address.getOffset());
            return builder.setAddressValue(addr);
        }
        if (value instanceof AddressRange) {
            AddressRange range = (AddressRange)value;
            TraceRmi.AddrRange.Builder rng = TraceRmi.AddrRange.newBuilder().setSpace(range.getAddressSpace().getName()).setOffset(range.getMinAddress().getOffset()).setExtend(range.getLength() - 1L);
            return builder.setRangeValue(rng);
        }
        if (value instanceof RmiTraceObject) {
            RmiTraceObject obj = (RmiTraceObject)value;
            return builder.setChildSpec(TraceRmi.ObjSpec.newBuilder().setPath(TraceRmi.ObjPath.newBuilder().setPath(obj.getPath())));
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.get(0) instanceof String) {
                TraceRmi.StringArr.Builder b = TraceRmi.StringArr.newBuilder().addAllArr(list);
                return builder.setStringArrValue(b.build());
            }
            if (list.get(0) instanceof Boolean) {
                TraceRmi.BoolArr.Builder b = TraceRmi.BoolArr.newBuilder().addAllArr(list);
                return builder.setBoolArrValue(b.build());
            }
            if (list.get(0) instanceof Short) {
                ArrayList<Integer> newList = new ArrayList<Integer>();
                for (Object object : list) {
                    newList.add(((Short)object).intValue());
                }
                TraceRmi.ShortArr.Builder b = TraceRmi.ShortArr.newBuilder().addAllArr(newList);
                return builder.setShortArrValue(b.build());
            }
            if (list.get(0) instanceof Integer) {
                TraceRmi.IntArr.Builder b = TraceRmi.IntArr.newBuilder().addAllArr(list);
                return builder.setIntArrValue(b.build());
            }
            if (list.get(0) instanceof Long) {
                TraceRmi.LongArr.Builder b = TraceRmi.LongArr.newBuilder().addAllArr(list);
                return builder.setLongArrValue(b.build());
            }
        }
        throw new RuntimeException("Unhandled type for buildValue: " + String.valueOf(value));
    }

    public void activate(int traceId, String path) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestActivate(TraceRmi.RequestActivate.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setObject(TraceRmi.ObjSpec.newBuilder().setPath(TraceRmi.ObjPath.newBuilder().setPath(path)))).build());
    }

    public void disassemble(int traceId, long snap, Address start) {
        this.send(TraceRmi.RootMessage.newBuilder().setRequestDisassemble(TraceRmi.RequestDisassemble.newBuilder().setOid(TraceRmi.DomObjId.newBuilder().setId(traceId)).setSnap(TraceRmi.Snap.newBuilder().setSnap(snap)).setStart(TraceRmi.Addr.newBuilder().setSpace(start.getAddressSpace().getName()).setOffset(start.getOffset()))).build());
    }

    public void negotiate(String desc) {
        TraceRmi.RequestNegotiate.Builder builder = TraceRmi.RequestNegotiate.newBuilder().setVersion("11.4").setDescription(desc);
        int i = 0;
        for (RmiRemoteMethod m : methodRegistry.getMap().values()) {
            TraceRmi.Method method = this.buildMethod(m);
            builder.addMethods(i++, method);
        }
        this.send(TraceRmi.RootMessage.newBuilder().setRequestNegotiate(builder).build());
    }

    private TraceRmi.Method buildMethod(RmiRemoteMethod method) {
        TraceRmi.Method.Builder builder = TraceRmi.Method.newBuilder().setName(method.getName()).setAction(method.getAction()).setDisplay(method.getDisplay()).setDescription(method.getDescription()).setOkText(method.getOkText()).setIcon(method.getIcon());
        int i = 0;
        for (RmiRemoteMethodParameter p : method.getParameters()) {
            TraceRmi.MethodParameter param = this.buildParameter(p);
            builder.addParameters(i++, param);
        }
        return builder.build();
    }

    private TraceRmi.MethodParameter buildParameter(RmiRemoteMethodParameter param) {
        return TraceRmi.MethodParameter.newBuilder().setName(param.getName()).setDisplay(param.getDisplay()).setDescription(param.getDescription()).setType(param.getType()).setDefaultValue(this.buildValue(param.getDefaultValue())).setRequired(param.isRequired()).build();
    }

    public TraceRmi.XReplyInvokeMethod handleInvokeMethod(int traceId, TraceRmi.XRequestInvokeMethod req) {
        int i;
        RmiRemoteMethod rm = this.getMethod(req.getName());
        Object[] arglist = new Object[req.getArgumentsCount()];
        Method m = rm.getMethod();
        HashMap<String, RmiRemoteMethodParameter[]> argmap = new HashMap<String, RmiRemoteMethodParameter[]>();
        for (i = 0; i < req.getArgumentsCount(); ++i) {
            RmiRemoteMethodParameter[] arg = req.getArguments(i);
            argmap.put(arg.getName(), arg);
        }
        i = 0;
        for (RmiRemoteMethodParameter p : rm.getParameters()) {
            TraceRmi.MethodArgument arg = (TraceRmi.MethodArgument)argmap.get(p.getName());
            if (arg == null) continue;
            Object obj = this.argToObject(traceId, arg.getValue());
            arglist[i++] = obj;
        }
        try {
            Object ret = m.invoke((Object)rm.getContainer(), arglist);
            if (ret != null) {
                return TraceRmi.XReplyInvokeMethod.newBuilder().setReturnValue(this.buildValue(ret)).build();
            }
            return TraceRmi.XReplyInvokeMethod.newBuilder().setReturnValue(this.buildValue(true)).build();
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            String message = e.getMessage();
            if (message != null) {
                Msg.error((Object)this, (Object)("Error handling method invocation:" + message));
                return TraceRmi.XReplyInvokeMethod.newBuilder().setError(message).build();
            }
            return TraceRmi.XReplyInvokeMethod.newBuilder().setError(e.toString()).build();
        }
    }

    Object argToObject(int traceId, TraceRmi.Value value) {
        if (value.hasStringValue()) {
            return value.getStringValue();
        }
        if (value.hasStringArrValue()) {
            return value.getStringArrValue().getArrList();
        }
        if (value.hasBoolValue()) {
            return value.getBoolValue();
        }
        if (value.hasBoolArrValue()) {
            return value.getBoolArrValue().getArrList();
        }
        if (value.hasCharValue()) {
            return value.getCharValue();
        }
        if (value.hasCharArrValue()) {
            return value.getCharArrValue();
        }
        if (value.hasShortValue()) {
            return value.getShortValue();
        }
        if (value.hasShortArrValue()) {
            return value.getShortArrValue().getArrList();
        }
        if (value.hasIntValue()) {
            return value.getIntValue();
        }
        if (value.hasIntArrValue()) {
            return value.getIntArrValue().getArrList();
        }
        if (value.hasLongValue()) {
            return value.getLongValue();
        }
        if (value.hasLongArrValue()) {
            return value.getLongArrValue().getArrList();
        }
        if (value.hasAddressValue()) {
            return this.decodeAddr(traceId, value.getAddressValue());
        }
        if (value.hasRangeValue()) {
            return this.decodeRange(traceId, value.getRangeValue());
        }
        if (value.hasByteValue()) {
            return value.getByteValue();
        }
        if (value.hasBytesValue()) {
            return value.getBytesValue();
        }
        if (value.hasNullValue()) {
            return value.getNullValue();
        }
        TraceRmi.ObjDesc desc = value.getChildDesc();
        String path = desc.getPath().getPath();
        return this.proxyObjectPath(traceId, path);
    }

    String argToType(TraceRmi.Value value) {
        if (value.hasStringValue()) {
            return "STRING";
        }
        if (value.hasStringArrValue()) {
            return "STRING_ARR";
        }
        if (value.hasBoolValue()) {
            return "BOOL";
        }
        if (value.hasBoolArrValue()) {
            return "BOOL_ARR";
        }
        if (value.hasCharValue()) {
            return "CHAR";
        }
        if (value.hasCharArrValue()) {
            return "CHAR_ARR";
        }
        if (value.hasShortValue()) {
            return "SHORT";
        }
        if (value.hasShortArrValue()) {
            return "SHORT_ARR";
        }
        if (value.hasIntValue()) {
            return "INT";
        }
        if (value.hasIntArrValue()) {
            return "INT_ARR";
        }
        if (value.hasLongValue()) {
            return "LONG";
        }
        if (value.hasLongArrValue()) {
            return "LONG_ARR";
        }
        if (value.hasAddressValue()) {
            return "ADDRESS";
        }
        if (value.hasRangeValue()) {
            return "RANGE";
        }
        if (value.hasByteValue()) {
            return "BYTE";
        }
        if (value.hasBytesValue()) {
            return "BYTE_ARR";
        }
        if (value.hasNullValue()) {
            return "NULL";
        }
        return "OBJECT";
    }

    private Address decodeAddr(int id, TraceRmi.Addr addr) {
        RmiTrace trace = this.traces.get(id);
        return trace.memoryMapper.genAddr(addr.getSpace(), addr.getOffset());
    }

    private AddressRange decodeRange(int id, TraceRmi.AddrRange rng) {
        RmiTrace trace = this.traces.get(id);
        Address start = trace.memoryMapper.genAddr(rng.getSpace(), rng.getOffset());
        return new AddressRangeImpl(start, start.add(rng.getExtend()));
    }

    public void setRegistry(RmiMethodRegistry methodRegistry) {
        RmiClient.methodRegistry = methodRegistry;
    }

    public RmiRemoteMethod getMethod(String name) {
        return methodRegistry.getMap().get(name);
    }

    public RmiBatch startBatch() {
        if (this.currentBatch == null) {
            this.currentBatch = new RmiBatch(this);
        }
        this.currentBatch.inc();
        return this.currentBatch;
    }

    boolean hasBatch() {
        return this.currentBatch != null;
    }

    void endBatch(RmiBatch batch) throws InterruptedException, ExecutionException {
        if (this.currentBatch.dec() == 0) {
            RmiBatch cb = this.currentBatch;
            this.currentBatch = null;
            cb.results();
        }
    }

    public TraceObjectSchema getSchema(String schema) {
        return this.schemaContext.getSchema(new TraceObjectSchema.SchemaName(schema));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResult pollRequest() {
        Deque<RequestResult> deque = this.requests;
        synchronized (deque) {
            return this.requests.poll();
        }
    }

    static class RequestResult
    extends CompletableFuture<Object> {
        public final TraceRmi.RootMessage request;

        public RequestResult(TraceRmi.RootMessage req) {
            this.request = req;
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            if (Swing.isSwingThread()) {
                throw new AssertionError((Object)"Refusing indefinite wait on Swing thread");
            }
            return super.get();
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (Swing.isSwingThread() && unit.toSeconds(timeout) > 1L) {
                throw new AssertionError((Object)"Refusing a timeout > 1 second on Swing thread");
            }
            return super.get(timeout, unit);
        }
    }

    public static enum TraceRmiResolution {
        RES_ADJUST("adjust", TraceRmi.Resolution.CR_ADJUST),
        RES_DENY("deny", TraceRmi.Resolution.CR_DENY),
        RES_TRUNCATE("truncate", TraceRmi.Resolution.CR_TRUNCATE);

        public final String val;
        public final TraceRmi.Resolution description;

        private TraceRmiResolution(String val, TraceRmi.Resolution description) {
            this.val = val;
            this.description = description;
        }
    }

    public static enum TraceRmiValueKinds {
        ATTRIBUTES("attributes", TraceRmi.ValueKinds.VK_ATTRIBUTES),
        ELEMENTS("elements", TraceRmi.ValueKinds.VK_ELEMENTS),
        BOTH("both", TraceRmi.ValueKinds.VK_BOTH);

        public final String val;
        public final TraceRmi.ValueKinds description;

        private TraceRmiValueKinds(String val, TraceRmi.ValueKinds description) {
            this.val = val;
            this.description = description;
        }
    }

    public static class RmiException
    extends RuntimeException {
        public RmiException(String message) {
            super(message);
        }
    }
}

