/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import ghidra.app.plugin.core.debug.gui.tracermi.launcher.AbstractTraceRmiLaunchOffer;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.ScriptAttributesParser;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLauncherServicePlugin;
import ghidra.debug.api.ValStr;
import ghidra.debug.api.tracermi.LaunchParameter;
import ghidra.debug.api.tracermi.TerminalSession;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public abstract class AbstractScriptTraceRmiLaunchOffer
extends AbstractTraceRmiLaunchOffer {
    protected final File script;
    protected final String configName;
    protected final ScriptAttributesParser.ScriptAttributes attrs;

    public AbstractScriptTraceRmiLaunchOffer(TraceRmiLauncherServicePlugin plugin, Program program, File script, String configName, ScriptAttributesParser.ScriptAttributes attrs) {
        super(plugin, program);
        this.script = script;
        this.configName = configName;
        this.attrs = attrs;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getTitle() {
        return this.attrs.title();
    }

    public String getDescription() {
        return this.attrs.description();
    }

    public List<String> getMenuPath() {
        return this.attrs.menuPath();
    }

    public String getMenuGroup() {
        return this.attrs.menuGroup();
    }

    public String getMenuOrder() {
        return this.attrs.menuOrder();
    }

    @Override
    public Icon getIcon() {
        return this.attrs.icon();
    }

    public HelpLocation getHelpLocation() {
        return this.attrs.helpLocation();
    }

    public Map<String, LaunchParameter<?>> getParameters() {
        return this.attrs.parameters();
    }

    @Override
    protected int getConnectionTimeoutMillis() {
        return this.attrs.timeoutMillis();
    }

    protected void prepareSubprocess(List<String> commandLine, Map<String, String> env, Map<String, ValStr<?>> args, SocketAddress address) {
        ScriptAttributesParser.processArguments(commandLine, env, this.script, this.attrs.parameters(), args, address);
    }

    @Override
    protected void launchBackEnd(TaskMonitor monitor, Map<String, TerminalSession> sessions, Map<String, ValStr<?>> args, SocketAddress address) throws Exception {
        ArrayList<String> commandLine = new ArrayList<String>();
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        this.prepareSubprocess(commandLine, env, args, address);
        if (this.program != null) {
            ValStr<?> valStr;
            LaunchParameter<?> imageParameter = this.imageParameter();
            if (imageParameter != null && (valStr = args.get(imageParameter.name())) != null && !valStr.str().contains(this.program.getName())) {
                Msg.warn((Object)this, (Object)("Possible mismatch for " + this.program.getName() + ": " + valStr.str()));
            }
            env.put("GHIDRA_LANGUAGE_ID", this.program.getLanguageID().toString());
        }
        for (Map.Entry<String, ScriptAttributesParser.TtyCondition> ent : this.attrs.extraTtys().entrySet()) {
            if (!ent.getValue().isActive(args)) continue;
            AbstractTraceRmiLaunchOffer.NullPtyTerminalSession ns = this.nullPtyTerminal();
            env.put(ent.getKey(), ns.name());
            sessions.put(ent.getKey(), ns);
        }
        sessions.put("Shell", this.runInTerminal(commandLine, env, this.script.getParentFile(), sessions.values()));
    }

    public LaunchParameter<?> imageParameter() {
        return this.attrs.imageOpt();
    }
}

