/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.rmi.jpda;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import ghidra.app.plugin.core.debug.client.tracermi.RmiClient;
import ghidra.app.plugin.core.debug.client.tracermi.RmiMethodRegistry;
import ghidra.app.plugin.core.debug.client.tracermi.RmiMethods;
import ghidra.app.plugin.core.debug.client.tracermi.RmiRemoteMethod;
import ghidra.dbg.jdi.manager.impl.DebugStatus;
import ghidra.dbg.jdi.manager.impl.JdiManagerImpl;
import ghidra.dbg.jdi.rmi.jpda.JdiArch;
import ghidra.dbg.jdi.rmi.jpda.JdiCommands;
import ghidra.dbg.jdi.rmi.jpda.JdiHooks;
import ghidra.dbg.jdi.rmi.jpda.JdiMethods;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.trace.model.target.schema.PrimitiveTraceObjectSchema;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.Map;

public class JdiConnector {
    private static final int STATIC_METHOD_SEPARATION = 3;
    public static final long BLOCK_SIZE = 4096L;
    public static final long DEFAULT_SECTION = 0L;
    public static final String ATTR_DISPLAY = "_display";
    public static final String ATTR_STATE = "_state";
    public static final String ATTR_MODULE_NAME = "_module_name";
    public static final String ATTR_ARCH = "_arch";
    public static final String ATTR_DEBUGGER = "_debugger";
    public static final String ATTR_OS = "_os";
    public static final String ATTR_ENDIAN = "_endian";
    public static final String ATTR_ACCESSIBLE = "_accessible";
    public static final String ATTR_ADDRESS = "Address";
    public static final String ATTR_ALIVE = "Alive";
    public static final String ATTR_CLASS = "Class";
    public static final String ATTR_COMMAND_LINE = "CommandLine";
    public static final String ATTR_COUNT = "Count";
    public static final String ATTR_ENABLED = "Enabled";
    public static final String ATTR_EXECUTABLE = "Executable";
    public static final String ATTR_EXIT_CODE = "ExitCode";
    public static final String ATTR_INDEX = "Index";
    public static final String ATTR_INSTANCE = "Instance";
    public static final String ATTR_LENGTH = "Length";
    public static final String ATTR_LINENO = "LineNo";
    public static final String ATTR_LOCATION = "Location";
    public static final String ATTR_NAME = "Name";
    public static final String ATTR_PC = "PC";
    public static final String ATTR_PLATFORM_ONLY = "PlatformOnly";
    public static final String ATTR_RANGE = "Range";
    public static final String ATTR_RANGE_CP = "RangeCP";
    public static final String ATTR_SIGNATURE = "Signature";
    public static final String ATTR_THREAD = "Thread";
    public static final String ATTR_TYPE = "Type";
    public static final String ATTR_VALUE = "Value";
    public static final String ATTR_EXCLUDE = "Exclude";
    public static final String ATTR_INCLUDE = "Include";
    private final JdiManagerImpl manager;
    private final JdiArch arch;
    private final JdiHooks hooks;
    private final JdiMethods methods;
    private final JdiCommands commands;
    final Map<String, Object> objectRegistry = new HashMap<String, Object>();
    final Map<Object, String> reverseRegistry = new HashMap<Object, String>();
    final RmiMethodRegistry remoteMethodRegistry = new RmiMethodRegistry();
    final Map<Object, Boolean> scopeRegistry = new HashMap<Object, Boolean>();
    protected final AddressSpace ram = new GenericAddressSpace("ram", 64, 1, 0);
    protected Long ramIndex = 4096L;
    protected final AddressSpace pool = new GenericAddressSpace("constantPool", 64, 1, 0);
    protected Long poolIndex = 0L;
    public final AddressRangeImpl defaultRange;
    private final Map<String, AddressRange> addressRangeByMethod = new HashMap<String, AddressRange>();
    private final Map<String, Method> methodsByKey = new HashMap<String, Method>();
    private final Map<ReferenceType, AddressRange> addressRangeByClass = new HashMap<ReferenceType, AddressRange>();
    private final Map<ReferenceType, AddressRange> cpAddressRangeByClass = new HashMap<ReferenceType, AddressRange>();
    private final Map<String, DebugStatus> returnStatusMap = new HashMap<String, DebugStatus>();
    final TraceObjectSchema rootSchema;
    private Map<String, String> env;

    public JdiConnector(JdiManagerImpl manager, Map<String, String> env) {
        this(manager);
        this.env = env;
        this.commands.ghidraTraceConnect(env.get("GHIDRA_TRACE_RMI_ADDR"));
        this.commands.ghidraTraceStart(env.get("OPT_TARGET_CLASS"));
    }

    public JdiConnector(JdiManagerImpl manager) {
        this.manager = manager;
        Address start = this.ram.getAddress(0L);
        this.defaultRange = new AddressRangeImpl(start, start.add(4095L));
        this.rootSchema = RmiClient.loadSchema((String)"jdi_schema.xml", (String)"Debugger");
        this.arch = new JdiArch(this);
        this.commands = new JdiCommands(this);
        this.methods = new JdiMethods(this, this.commands);
        this.hooks = new JdiHooks(this, this.commands);
        this.hooks.installHooks();
    }

    public JdiManagerImpl getJdi() {
        return this.manager;
    }

    public JdiArch getArch() {
        return this.arch;
    }

    public JdiCommands getCommands() {
        return this.commands;
    }

    public JdiMethods getMethods() {
        return this.methods;
    }

    public JdiHooks getHooks() {
        return this.hooks;
    }

    public RmiClient getClient() {
        return this.commands.state.client;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public void registerRemoteMethod(JdiMethods methods, java.lang.reflect.Method m, String name) {
        RmiMethodRegistry.TraceMethod annot = m.getAnnotation(RmiMethodRegistry.TraceMethod.class);
        if (annot == null) {
            return;
        }
        int pcount = m.getParameterCount();
        if (pcount < 1) {
            return;
        }
        PrimitiveTraceObjectSchema schema = PrimitiveTraceObjectSchema.ANY;
        RmiRemoteMethod method = new RmiRemoteMethod(this.rootSchema.getContext(), name, annot.action(), annot.display(), annot.description(), annot.okText(), annot.icon(), (TraceObjectSchema)schema, (RmiMethods)methods, m);
        this.remoteMethodRegistry.putMethod(name, method);
    }

    public AddressSpace getAddressSpace(String name) {
        switch (name) {
            case "ram": {
                return this.ram;
            }
            case "constantPool": {
                return this.pool;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressRange putAddressRange(ReferenceType cls, AddressSet set) {
        Map<ReferenceType, AddressRange> map = this.addressRangeByClass;
        synchronized (map) {
            if (set.isEmpty()) {
                this.addressRangeByClass.put(cls, (AddressRange)this.defaultRange);
                return this.defaultRange;
            }
            AddressRangeImpl range = new AddressRangeImpl(set.getMinAddress(), set.getMaxAddress());
            this.addressRangeByClass.put(cls, (AddressRange)range);
            return range;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressRange getAddressRange(ReferenceType cls) {
        if (cls == null) {
            return this.defaultRange;
        }
        Map<ReferenceType, AddressRange> map = this.addressRangeByClass;
        synchronized (map) {
            return this.addressRangeByClass.get(cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceType getReferenceTypeForAddress(Address address) {
        Map<ReferenceType, AddressRange> map = this.addressRangeByClass;
        synchronized (map) {
            for (ReferenceType ref : this.addressRangeByClass.keySet()) {
                AddressRange range = this.addressRangeByClass.get(ref);
                if (!range.contains(address)) continue;
                return ref;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressRange getPoolAddressRange(ReferenceType cls, int sz) {
        if (cls == null) {
            return this.defaultRange;
        }
        Map<ReferenceType, AddressRange> map = this.cpAddressRangeByClass;
        synchronized (map) {
            AddressRange range = this.cpAddressRangeByClass.get(cls);
            if (range == null) {
                this.registerConstantPool(cls, sz);
                range = this.cpAddressRangeByClass.get(cls);
            }
            return range;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConstantPool(ReferenceType declaringType, int sz) {
        Map<ReferenceType, AddressRange> map = this.cpAddressRangeByClass;
        synchronized (map) {
            if (!this.cpAddressRangeByClass.containsKey(declaringType) && this.manager.getCurrentVM().canGetConstantPool()) {
                long length = sz == 0 ? 2L : (long)sz;
                Address start = this.pool.getAddress(this.poolIndex.longValue());
                AddressRangeImpl range = new AddressRangeImpl(start, start.add(length - 1L));
                if (!this.cpAddressRangeByClass.containsKey(declaringType)) {
                    this.cpAddressRangeByClass.put(declaringType, (AddressRange)range);
                    this.poolIndex = this.poolIndex + length;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceType getReferenceTypeForPoolAddress(Address address) {
        Map<ReferenceType, AddressRange> map = this.cpAddressRangeByClass;
        synchronized (map) {
            for (ReferenceType ref : this.cpAddressRangeByClass.keySet()) {
                AddressRange range = this.cpAddressRangeByClass.get(ref);
                if (!range.contains(address)) continue;
                return ref;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressRange getAddressRange(Method method) {
        if (method == null) {
            return this.defaultRange;
        }
        Map<String, AddressRange> map = this.addressRangeByMethod;
        synchronized (map) {
            AddressRange range = this.addressRangeByMethod.get(JdiConnector.methodToKey(method));
            if (range == null) {
                return this.defaultRange;
            }
            return range;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethodForAddress(Address address) {
        Map<String, AddressRange> map = this.addressRangeByMethod;
        synchronized (map) {
            for (String methodName : this.addressRangeByMethod.keySet()) {
                AddressRange range = this.addressRangeByMethod.get(methodName);
                if (!range.contains(address)) continue;
                return this.methodsByKey.get(methodName);
            }
            return null;
        }
    }

    public Address getAddressFromLocation(Location location) {
        AddressRange addressRange = this.getAddressRange(location.method());
        if (addressRange == null) {
            return this.getAddressSpace("ram").getAddress(-1L);
        }
        long codeIndex = location.codeIndex();
        return addressRange.getMinAddress().add(codeIndex < 0L ? 0L : codeIndex);
    }

    public Location getLocation(Address address) {
        Method method = this.getMethodForAddress(address);
        long codeIndex = address.subtract(this.getAddressRange(method).getMinAddress());
        return method.locationOfCodeIndex(codeIndex);
    }

    public static String methodToKey(Method method) {
        return method.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AddressRange registerAddressesForMethod(Method method) {
        byte[] bytecodes = method.bytecodes();
        if (bytecodes == null) {
            return null;
        }
        int length = bytecodes.length;
        if (length <= 0) {
            return null;
        }
        Map<String, AddressRange> map = this.addressRangeByMethod;
        synchronized (map) {
            Address start = this.ram.getAddress(this.ramIndex.longValue());
            AddressRangeImpl range = new AddressRangeImpl(start, start.add((long)(length - 1)));
            String key = JdiConnector.methodToKey(method);
            if (!this.methodsByKey.containsKey(key)) {
                this.methodsByKey.put(key, method);
            }
            if (!this.addressRangeByMethod.containsKey(key)) {
                this.addressRangeByMethod.put(key, (AddressRange)range);
                this.ramIndex = range.getMaxAddress().getUnsignedOffset() + 3L;
                return range;
            }
            return this.addressRangeByMethod.get(key);
        }
    }

    public String recordPath(Object obj, String path, String key) {
        path = ((String)path).endsWith("]") ? (String)path + "." + key : (String)path + this.key(key);
        this.objectRegistry.put((String)path, obj);
        if (!this.reverseRegistry.containsKey(obj)) {
            this.reverseRegistry.put(obj, (String)path);
        }
        return path;
    }

    public Object objForPath(String path) {
        return this.objectRegistry.get(path);
    }

    public String pathForObj(Object obj) {
        if (!this.reverseRegistry.containsKey(obj)) {
            if (this.objectRegistry.containsValue(obj)) {
                Msg.error((Object)this, (Object)("MISSING path for " + String.valueOf(obj)));
            }
            return null;
        }
        return this.reverseRegistry.get(obj);
    }

    public boolean getScope(Object ctxt) {
        Boolean scope = this.scopeRegistry.get(ctxt);
        if (scope == null) {
            scope = true;
        }
        return scope;
    }

    public void toggleScope(Object ctxt) {
        Boolean scope = this.scopeRegistry.get(ctxt);
        if (scope == null) {
            scope = true;
        }
        this.scopeRegistry.put(ctxt, scope == false);
    }

    private String sanitize(String name) {
        if (name == null) {
            return name;
        }
        name = name.replace("[", "");
        name = name.replace("]", "");
        return name;
    }

    public String key(String key) {
        return "[" + this.sanitize(key) + "]";
    }

    public DebugStatus getReturnStatus(String eventName) {
        return this.returnStatusMap.get(eventName);
    }

    public void setReturnStatus(String eventName, String statusString) {
        DebugStatus status = DebugStatus.BREAK;
        try {
            status = DebugStatus.valueOf(statusString.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.returnStatusMap.put(eventName, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bumpRamIndex() {
        Map<String, AddressRange> map = this.addressRangeByMethod;
        synchronized (map) {
            if (this.ramIndex % 4096L != 0L) {
                this.ramIndex = (this.ramIndex / 4096L + 1L) * 4096L;
            }
        }
    }
}

