/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.rmi.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ModuleReference;
import com.sun.jdi.MonitorInfo;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.DuplicateRequestException;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.MonitorContendedEnterRequest;
import com.sun.jdi.request.MonitorContendedEnteredRequest;
import com.sun.jdi.request.MonitorWaitRequest;
import com.sun.jdi.request.MonitorWaitedRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import com.sun.jdi.request.VMDeathRequest;
import ghidra.app.plugin.core.debug.client.tracermi.MemoryMapper;
import ghidra.app.plugin.core.debug.client.tracermi.RmiMethodRegistry;
import ghidra.app.plugin.core.debug.client.tracermi.RmiMethods;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTraceObject;
import ghidra.app.plugin.core.debug.client.tracermi.RmiTransaction;
import ghidra.dbg.jdi.rmi.jpda.JdiCommands;
import ghidra.dbg.jdi.rmi.jpda.JdiConnector;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.rmi.trace.TraceRmi;
import ghidra.trace.model.target.iface.TraceObjectMethod;
import ghidra.util.Msg;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JdiMethods
implements RmiMethods {
    private JdiConnector connector;
    private JdiCommands cmds;

    public JdiMethods(JdiConnector connector, JdiCommands cmds) {
        this.connector = connector;
        this.cmds = cmds;
        this.registerMethods();
    }

    public void registerMethods() {
        Class<?> cls = this.getClass();
        for (Method m : cls.getMethods()) {
            RmiMethodRegistry.TraceMethod annot = m.getAnnotation(RmiMethodRegistry.TraceMethod.class);
            if (annot == null) continue;
            this.connector.registerRemoteMethod(this, m, m.getName());
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh VM")
    public void refresh_vm(@TraceObjectMethod.Param(schema="VirtualMachine", name="vm") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshVM");){
            String path = obj.getPath();
            VirtualMachine vm = (VirtualMachine)this.getObjectFromPath(path);
            this.cmds.putVMDetails(path, vm);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh process")
    public void refresh_process(@TraceObjectMethod.Param(schema="ProcessRef", name="process") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshProcess");){
            String path = obj.getPath();
            Process proc = (Process)this.getObjectFromPath(path);
            this.cmds.putProcessDetails(path, proc);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh thread groups")
    public void refresh_thread_groups(@TraceObjectMethod.Param(schema="ThreadGroupReferenceContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshThreadGroups");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            Object parent = this.getObjectFromPath(ppath);
            if (parent instanceof VirtualMachine) {
                VirtualMachine vm = (VirtualMachine)parent;
                this.cmds.putThreadGroupContainer(ppath, vm.topLevelThreadGroups());
            }
            if (parent instanceof ThreadGroupReference) {
                ThreadGroupReference group = (ThreadGroupReference)parent;
                this.cmds.putThreadGroupContainer(ppath, group.threadGroups());
            }
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh thread group")
    public void refresh_thread_group_proxy(@TraceObjectMethod.Param(schema="ThreadGroupReferenceProxy", name="proxy") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshThreadGroup");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            Object parent = this.getObjectFromPath(ppath);
            if (parent instanceof ThreadGroupReference) {
                ThreadGroupReference group = (ThreadGroupReference)parent;
                this.cmds.putThreadGroupReference(path, group.parent());
            }
            if (parent instanceof ThreadReference) {
                ThreadReference ref = (ThreadReference)parent;
                this.cmds.putThreadGroupReference(path, ref.threadGroup());
            }
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh thread group")
    public void refresh_thread_group(@TraceObjectMethod.Param(schema="ThreadGroupReference", name="group") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshThreadGroup");){
            String path = obj.getPath();
            ThreadGroupReference ref = (ThreadGroupReference)this.getObjectFromPath(path);
            this.cmds.putThreadGroupReferenceDetails(path, ref);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh threads")
    public void refresh_threads(@TraceObjectMethod.Param(schema="ThreadContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshThreads");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            VirtualMachine vm = (VirtualMachine)this.getObjectFromPath(ppath);
            this.cmds.putThreadContainer(ppath, vm.allThreads(), false);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh threads")
    public void refresh_threadrefs(@TraceObjectMethod.Param(schema="ThreadReferenceContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshThreads");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            Object parent = this.getObjectFromPath(ppath);
            if (parent instanceof ThreadGroupReference) {
                ThreadGroupReference group = (ThreadGroupReference)parent;
                if (path.endsWith(".Threads")) {
                    this.cmds.putThreadContainer(ppath, group.threads(), true);
                }
            }
            if (parent instanceof ObjectReference) {
                ObjectReference ref = (ObjectReference)parent;
                if (!path.endsWith(".Threads")) {
                    try {
                        this.cmds.putThreadContainer(ppath, ref.waitingThreads(), true);
                    }
                    catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh thread")
    public void refresh_thread(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshThread");){
            String path = obj.getPath();
            ThreadReference ref = (ThreadReference)this.getObjectFromPath(path);
            this.cmds.putThreadReferenceDetails(path, ref);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh stack")
    public void refresh_stack(@TraceObjectMethod.Param(schema="Stack", name="stack") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshStack");){
            this.cmds.ghidraTracePutFrames();
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh registers")
    public void refresh_registers(@TraceObjectMethod.Param(schema="RegisterContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshRegisters");){
            this.cmds.ghidraTracePutFrames();
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh modules")
    public void refresh_modules(@TraceObjectMethod.Param(schema="ModuleReferenceContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshModules");){
            this.cmds.putModuleReferenceContainer();
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh module")
    public void refresh_module(@TraceObjectMethod.Param(schema="ModuleReference", name="module") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshModule");){
            String path = obj.getPath();
            ModuleReference ref = (ModuleReference)this.getObjectFromPath(path);
            this.cmds.putModuleReferenceDetails(path, ref);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh monitor info")
    public void refresh_monitors(@TraceObjectMethod.Param(schema="MonitorInfoContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshMonitorInfo");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            ThreadReference ref = (ThreadReference)this.getObjectFromPath(ppath);
            this.cmds.putMonitorInfoContainer(path, ref.ownedMonitorsAndFrames());
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh monitor info")
    public void refresh_monitor_info(@TraceObjectMethod.Param(schema="MonitorInfo", name="monitor_info") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshMonitorInfo");){
            String path = obj.getPath();
            MonitorInfo mi = (MonitorInfo)this.getObjectFromPath(path);
            this.cmds.putMonitorInfoDetails(path, mi);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh fields")
    public void refresh_canonical_fields(@TraceObjectMethod.Param(schema="CanonicalFieldContainer", name="container") RmiTraceObject obj) {
        this.refresh_fields(obj);
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh fields")
    public void refresh_fields(@TraceObjectMethod.Param(schema="FieldContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshFields");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            Object parent = this.getObjectFromPath(ppath);
            if (parent instanceof ReferenceType) {
                ReferenceType refType = (ReferenceType)parent;
                this.cmds.putFieldContainer(path, refType);
            } else if (parent instanceof ObjectReference) {
                ObjectReference ref = (ObjectReference)parent;
                this.cmds.putVariableContainer(path, ref);
            }
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh objects")
    public void refresh_objects(@TraceObjectMethod.Param(schema="ObjectReferenceContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshObjects");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            Object parent = this.getObjectFromPath(ppath);
            if (parent instanceof ReferenceType) {
                ReferenceType refType = (ReferenceType)parent;
                this.cmds.putObjectContainer(path, refType.instances(this.cmds.MAX_REFS));
            }
            if (parent instanceof ThreadReference) {
                ThreadReference thread = (ThreadReference)parent;
                try {
                    if (path.endsWith("OwnedMonitors")) {
                        this.cmds.putObjectContainer(path, thread.ownedMonitors());
                    }
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    // empty catch block
                }
            }
            if (parent instanceof ObjectReference) {
                ObjectReference ref = (ObjectReference)parent;
                if (path.endsWith("ReferringObjects")) {
                    this.cmds.putObjectContainer(path, ref.referringObjects(this.cmds.MAX_REFS));
                }
            }
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh object")
    public void refresh_object_proxy(@TraceObjectMethod.Param(schema="ObjectReferenceProxy", name="proxy") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshObject");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            Object parent = this.getObjectFromPath(ppath);
            if (parent instanceof ThreadReference) {
                ThreadReference thread = (ThreadReference)parent;
                if (path.endsWith("CurrentContendedMonitor")) {
                    try {
                        this.cmds.putObjectReference(path, thread.currentContendedMonitor());
                    }
                    catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                        // empty catch block
                    }
                }
            }
            if (parent instanceof StackFrame) {
                StackFrame frame = (StackFrame)parent;
                this.cmds.putObjectReference(path, frame.thisObject());
            }
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh object")
    public void refresh_object(@TraceObjectMethod.Param(schema="ObjectReference", name="object") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshInstance");){
            String path = obj.getPath();
            ObjectReference method = (ObjectReference)this.getObjectFromPath(path);
            this.cmds.putObjectReferenceDetails(path, method);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh methods")
    public void refresh_canonical_methods(@TraceObjectMethod.Param(schema="CanonicalMethodContainer", name="container") RmiTraceObject obj) {
        this.refresh_methods(obj);
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh methods")
    public void refresh_methods(@TraceObjectMethod.Param(schema="MethodContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshMethods");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            ReferenceType refType = (ReferenceType)this.getObjectFromPath(ppath);
            this.cmds.putMethodContainer(path, refType);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh method")
    public void refresh_method(@TraceObjectMethod.Param(schema="Method", name="method") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshMethod");){
            String path = obj.getPath();
            com.sun.jdi.Method method = (com.sun.jdi.Method)this.getObjectFromPath(path);
            this.cmds.putMethodDetails(path, method, false);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh arguments")
    public void refresh_arguments(@TraceObjectMethod.Param(schema="ArgumentContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshArguments");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            com.sun.jdi.Method method = (com.sun.jdi.Method)this.getObjectFromPath(ppath);
            this.cmds.putMethodTypeContainer(path, method);
        }
    }

    @RmiMethodRegistry.TraceMethod(display="Load class")
    public boolean find_canonical_class(@TraceObjectMethod.Param(schema="CanonicalReferenceTypeContainer", description="Container", display="Container", name="container") RmiTraceObject obj, @TraceObjectMethod.Param(description="Class to open", display="Class", name="find") String targetClass) {
        return this.find_class(obj, targetClass);
    }

    @RmiMethodRegistry.TraceMethod(display="Load class")
    public boolean find_class(@TraceObjectMethod.Param(schema="ReferenceTypeContainer", description="Container", display="Container", name="container") RmiTraceObject obj, @TraceObjectMethod.Param(description="Class to open", display="Class", name="find") String targetClass) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("FindClass");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            Object parent = this.getObjectFromPath(ppath);
            if (parent instanceof VirtualMachine) {
                VirtualMachine vm = (VirtualMachine)parent;
                boolean bl = this.cmds.loadReferenceType(path, vm.allClasses(), targetClass);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @RmiMethodRegistry.TraceMethod(display="Refresh memory")
    public void refresh_memory(@TraceObjectMethod.Param(schema="Memory", name="memory") RmiTraceObject obj) {
        this.refresh_reference_types(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Refresh reference types")
    public void refresh_canonical_reference_types(@TraceObjectMethod.Param(schema="CanonicalReferenceTypeContainer", name="container") RmiTraceObject obj) {
        this.refresh_reference_types(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Refresh reference types")
    public void refresh_reference_types(@TraceObjectMethod.Param(schema="ReferenceTypeContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshReferenceTypes");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            Object parent = this.getObjectFromPath(ppath);
            if (parent instanceof VirtualMachine) {
                VirtualMachine vm = (VirtualMachine)parent;
                this.cmds.putReferenceTypeContainer(path, vm.allClasses());
            }
            if (parent instanceof ClassLoaderReference) {
                ClassLoaderReference ref = (ClassLoaderReference)parent;
                if (path.endsWith("DefinedClasses")) {
                    this.cmds.putReferenceTypeContainer(path, ref.definedClasses());
                }
                if (path.endsWith("VisibleClasses")) {
                    this.cmds.putReferenceTypeContainer(path, ref.visibleClasses());
                }
            }
            if (parent instanceof ClassType) {
                ClassType ct = (ClassType)parent;
                if (path.endsWith("AllInterfaces")) {
                    this.cmds.putInterfaceTypes(path, ct.allInterfaces());
                }
                if (path.endsWith("Interfaces")) {
                    this.cmds.putInterfaceTypes(path, ct.interfaces());
                }
                if (path.endsWith("SubClasses")) {
                    this.cmds.putClassTypes(path, ct.subclasses());
                }
            }
            if (parent instanceof InterfaceType) {
                InterfaceType it = (InterfaceType)parent;
                if (path.endsWith("Implementors")) {
                    this.cmds.putClassTypes(path, it.implementors());
                }
                if (path.endsWith("SubInterfaces")) {
                    this.cmds.putInterfaceTypes(path, it.subinterfaces());
                }
                if (path.endsWith("SuperInterfaces")) {
                    this.cmds.putInterfaceTypes(path, it.superinterfaces());
                }
            }
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh reference type")
    public void refresh_reference_type_proxy(@TraceObjectMethod.Param(schema="ReferenceTypeProxy", name="proxy") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshReferenceType");){
            ObjectReference ref;
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            Object parent = this.getObjectFromPath(ppath);
            if (parent instanceof ObjectReference) {
                ref = (ObjectReference)parent;
                this.cmds.putReferenceType(path, ref.referenceType(), false);
            }
            if (parent instanceof ClassObjectReference) {
                ref = (ClassObjectReference)parent;
                if (path.endsWith("ReflectedType")) {
                    this.cmds.putReferenceType(path, ref.reflectedType(), false);
                }
            }
            if (parent instanceof ClassType) {
                ClassType ct = (ClassType)parent;
                this.cmds.putReferenceType(path, ct.superclass(), false);
            }
            if (parent instanceof com.sun.jdi.Method) {
                com.sun.jdi.Method method = (com.sun.jdi.Method)parent;
                this.cmds.putReferenceType(path, method.declaringType(), false);
            }
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh reference type")
    public void refresh_canonical_reference_type(@TraceObjectMethod.Param(schema="CanonicalReferenceType", name="container") RmiTraceObject obj) {
        this.refresh_reference_type(obj);
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh reference type")
    public void refresh_reference_type(@TraceObjectMethod.Param(schema="ReferenceType", name="reference_type") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshReferenceType");){
            String path = obj.getPath();
            ReferenceType refType = (ReferenceType)this.getObjectFromPath(path);
            this.cmds.putReferenceType(path, refType, false);
        }
    }

    @RmiMethodRegistry.TraceMethod(display="Load reference type")
    public void load_reftype(@TraceObjectMethod.Param(schema="ReferenceType", name="reference_type") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshReferenceType");){
            VirtualMachine vm = this.connector.getJdi().getCurrentVM();
            String path = obj.getPath();
            String mempath = this.cmds.getPath(vm) + ".Classes";
            ReferenceType refType = (ReferenceType)this.getObjectFromPath(path);
            this.cmds.putReferenceType(mempath, refType, true);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh variables")
    public void refresh_canonical_variables(@TraceObjectMethod.Param(schema="CanonicalVariableContainer", name="container") RmiTraceObject obj) {
        this.refresh_variables(obj);
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh variables")
    public void refresh_variables(@TraceObjectMethod.Param(schema="VariableContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshVariables");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            Object parent = this.getObjectFromPath(ppath);
            try {
                if (parent instanceof com.sun.jdi.Method) {
                    com.sun.jdi.Method method = (com.sun.jdi.Method)parent;
                    if (path.endsWith("Arguments")) {
                        this.cmds.putLocalVariableContainer(path, method.arguments());
                    }
                    if (path.endsWith("Variables")) {
                        this.cmds.putLocalVariableContainer(path, method.variables());
                    }
                }
                if (parent instanceof StackFrame) {
                    StackFrame frame = (StackFrame)parent;
                    Map<LocalVariable, Value> map = frame.getValues(frame.visibleVariables());
                    this.cmds.putLocalVariableContainer(path, map);
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh variable")
    public void refresh_variable(@TraceObjectMethod.Param(schema="Variable", name="variable") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshVariable");){
            String path = obj.getPath();
            Object object = this.getObjectFromPath(path);
            if (object instanceof LocalVariable) {
                LocalVariable var = (LocalVariable)object;
                this.cmds.putLocalVariableDetails(path, var);
            }
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh locations")
    public void refresh_locations(@TraceObjectMethod.Param(schema="LocationContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshLocations");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            Object parent = this.getObjectFromPath(ppath);
            if (parent instanceof com.sun.jdi.Method) {
                com.sun.jdi.Method method = (com.sun.jdi.Method)parent;
                this.cmds.putLocationContainer(path, method);
            }
            if (parent instanceof ReferenceType) {
                ReferenceType ref = (ReferenceType)parent;
                this.cmds.putLocationContainer(path, ref);
            }
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh location")
    public void refresh_location(@TraceObjectMethod.Param(schema="Location", name="location") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshLocation");){
            String path = obj.getPath();
            Location loc = (Location)this.getObjectFromPath(path);
            this.cmds.putLocationDetails(path, loc);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh breakpoints")
    public void refresh_breakpoints(@TraceObjectMethod.Param(schema="BreakpointContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshBreakpoints");){
            this.cmds.putBreakpoints();
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh events")
    public void refresh_events(@TraceObjectMethod.Param(schema="EventContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshEvents");){
            this.cmds.putEvents();
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh values")
    public void refresh_values(@TraceObjectMethod.Param(schema="ValueContainer", name="container") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshValues");){
            String path = obj.getPath();
            String ppath = this.cmds.getParentPath(path);
            Object parent = this.getObjectFromPath(ppath);
            if (parent instanceof ArrayReference) {
                ArrayReference arr = (ArrayReference)parent;
                this.cmds.putValueContainer(path, arr.getValues());
            }
        }
    }

    @RmiMethodRegistry.TraceMethod(action="refresh", display="Refresh value")
    public void refresh_value(@TraceObjectMethod.Param(schema="Value", name="value") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshLocation");){
            String path = obj.getPath();
            Value val = (Value)this.getObjectFromPath(path);
            this.cmds.putValueDetailsByType(path, val);
        }
    }

    @RmiMethodRegistry.TraceMethod(display="Set value")
    public void set_value_lvar(@TraceObjectMethod.Param(schema="Variable", description="Variable", display="Variable", name="variable") RmiTraceObject obj, @TraceObjectMethod.Param(description="Value", display="Value", name="value") String value) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshLocation");){
            String path = obj.getPath();
            LocalVariable lvar = (LocalVariable)this.getObjectFromPath(path);
            this.cmds.modifyValue(lvar, value);
        }
    }

    @RmiMethodRegistry.TraceMethod(display="Set value")
    public void set_value_field(@TraceObjectMethod.Param(schema="Field", description="Field", display="Field", name="field") RmiTraceObject obj, @TraceObjectMethod.Param(description="Value", display="Value", name="value") String value) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("RefreshLocation");){
            String path = obj.getPath();
            Field field = (Field)this.getObjectFromPath(path);
            this.cmds.modifyValue(field, value);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="activate", display="Activate")
    public void activate(@TraceObjectMethod.Param(schema="OBJECT", name="object") RmiTraceObject obj) {
        try (RmiTransaction tx = this.cmds.state.trace.openTx("Activate");){
            String path = obj.getPath();
            this.cmds.activate(path);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="kill", display="Terminate")
    public void kill(@TraceObjectMethod.Param(schema="VirtualMachine", name="vm") RmiTraceObject obj) {
        VirtualMachine vm = (VirtualMachine)this.getObjectFromPath(obj.getPath());
        vm.exit(143);
        try {
            this.connector.getJdi().sendInterruptNow();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RmiMethodRegistry.TraceMethod(action="resume", display="Resume")
    public void resume_vm(@TraceObjectMethod.Param(schema="VirtualMachine", name="vm") RmiTraceObject obj) {
        VirtualMachine vm = (VirtualMachine)this.getObjectFromPath(obj.getPath());
        vm.resume();
        this.connector.getHooks().setState(vm);
    }

    @RmiMethodRegistry.TraceMethod(action="resume", display="Resume")
    public void resume_thread(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        ThreadReference thread = (ThreadReference)this.getObjectFromPath(obj.getPath());
        thread.resume();
        this.connector.getHooks().setState(thread.virtualMachine());
    }

    @RmiMethodRegistry.TraceMethod(action="interrupt", display="Suspend")
    public void suspend_vm(@TraceObjectMethod.Param(schema="VirtualMachine", name="vm") RmiTraceObject obj) {
        VirtualMachine vm = (VirtualMachine)this.getObjectFromPath(obj.getPath());
        vm.suspend();
        this.connector.getHooks().setState(vm);
    }

    @RmiMethodRegistry.TraceMethod(action="interrupt", display="Suspend")
    public void suspend_thread(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        ThreadReference thread = (ThreadReference)this.getObjectFromPath(obj.getPath());
        thread.suspend();
        this.connector.getHooks().setState(thread.virtualMachine());
    }

    @RmiMethodRegistry.TraceMethod(action="step_into", display="Step into")
    public void step_vm_into(@TraceObjectMethod.Param(schema="VirtualMachine", name="vm") RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        List<ThreadReference> threads = this.getThreadsFromValue(obj);
        for (ThreadReference thread : threads) {
            try {
                StepRequest stepReq = vm.eventRequestManager().createStepRequest(thread, -1, 1);
                stepReq.enable();
            }
            catch (DuplicateRequestException duplicateRequestException) {}
        }
        vm.resume();
    }

    @RmiMethodRegistry.TraceMethod(action="step_over", display="Step over")
    public void step_vm_over(@TraceObjectMethod.Param(schema="VirtualMachine", name="vm") RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        List<ThreadReference> threads = this.getThreadsFromValue(obj);
        for (ThreadReference thread : threads) {
            try {
                StepRequest stepReq = vm.eventRequestManager().createStepRequest(thread, -1, 2);
                stepReq.enable();
            }
            catch (DuplicateRequestException duplicateRequestException) {}
        }
        vm.resume();
    }

    @RmiMethodRegistry.TraceMethod(action="step_out", display="Step out")
    public void step_vm_out(@TraceObjectMethod.Param(schema="VirtualMachine", name="vm") RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        List<ThreadReference> threads = this.getThreadsFromValue(obj);
        for (ThreadReference thread : threads) {
            try {
                StepRequest stepReq = vm.eventRequestManager().createStepRequest(thread, -1, 3);
                stepReq.enable();
            }
            catch (DuplicateRequestException duplicateRequestException) {}
        }
        vm.resume();
    }

    @RmiMethodRegistry.TraceMethod(action="step_into", display="Step into")
    public void step_into(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        ThreadReference thread = (ThreadReference)this.getObjectFromPath(obj.getPath());
        StepRequest stepReq = vm.eventRequestManager().createStepRequest(thread, -1, 1);
        stepReq.enable();
        vm.resume();
    }

    @RmiMethodRegistry.TraceMethod(action="step_over", display="Step over")
    public void step_over(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        ThreadReference thread = (ThreadReference)this.getObjectFromPath(obj.getPath());
        StepRequest stepReq = vm.eventRequestManager().createStepRequest(thread, -1, 2);
        stepReq.enable();
        vm.resume();
    }

    @RmiMethodRegistry.TraceMethod(action="step_out", display="Step out")
    public void step_out(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        ThreadReference thread = (ThreadReference)this.getObjectFromPath(obj.getPath());
        StepRequest stepReq = vm.eventRequestManager().createStepRequest(thread, -1, 3);
        stepReq.enable();
        vm.resume();
    }

    @RmiMethodRegistry.TraceMethod(display="Thread Interrupt")
    public void thread_interrupt(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        Object object = this.getObjectFromPath(obj.getPath());
        if (object instanceof ThreadReference) {
            ThreadReference thread = (ThreadReference)object;
            thread.interrupt();
            this.connector.getHooks().setState(thread.virtualMachine());
        }
    }

    @RmiMethodRegistry.TraceMethod(action="step_ext", display="Pop stack")
    public void pop_stack(@TraceObjectMethod.Param(schema="StackFrame", name="frame") RmiTraceObject obj) {
        StackFrame frame = (StackFrame)this.getObjectFromPath(obj.getPath());
        ThreadReference thread = frame.thread();
        try {
            thread.popFrames(frame);
        }
        catch (IncompatibleThreadStateException e) {
            Msg.out((Object)"Incompatible thread state for pop");
        }
    }

    @RmiMethodRegistry.TraceMethod(display="Break on execute")
    public void break_location(@TraceObjectMethod.Param(schema="Location", name="location") RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof Location) {
            Location loc = (Location)ctxt;
            BreakpointRequest brkReq = vm.eventRequestManager().createBreakpointRequest(loc);
            brkReq.enable();
            this.cmds.putBreakpoints();
        }
    }

    @RmiMethodRegistry.TraceMethod(display="Break on access")
    public void break_access(@TraceObjectMethod.Param(schema="Field", name="field") RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof Field) {
            Field field = (Field)ctxt;
            AccessWatchpointRequest brkReq = vm.eventRequestManager().createAccessWatchpointRequest(field);
            brkReq.enable();
            this.cmds.putBreakpoints();
        }
    }

    @RmiMethodRegistry.TraceMethod(display="Break on modify")
    public void break_modify(@TraceObjectMethod.Param(schema="Field", name="field") RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof Field) {
            Field field = (Field)ctxt;
            ModificationWatchpointRequest brkReq = vm.eventRequestManager().createModificationWatchpointRequest(field);
            brkReq.enable();
            this.cmds.putBreakpoints();
        }
    }

    @RmiMethodRegistry.TraceMethod(display="Break on exception")
    public void break_exception(@TraceObjectMethod.Param(schema="ReferenceType", description="Reference Type (Class)", display="Type", name="reference_type") RmiTraceObject obj, @TraceObjectMethod.Param(description="Caught exceptions will be notified", display="NotifyCaught", name="notify_caught") boolean notifyCaught, @TraceObjectMethod.Param(description="Uncaught exceptions will be notified", display="NotifyUncaught", name="notify_uncaught") boolean notifyUncaught) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof ReferenceType) {
            ReferenceType reftype = (ReferenceType)ctxt;
            ExceptionRequest excReq = vm.eventRequestManager().createExceptionRequest(reftype, notifyCaught, notifyUncaught);
            excReq.enable();
            this.cmds.putEvents();
        }
    }

    private void break_started(RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        ThreadStartRequest brkReq = vm.eventRequestManager().createThreadStartRequest();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof ThreadReference) {
            ThreadReference ref = (ThreadReference)ctxt;
            brkReq.putProperty("Thread", ref);
            brkReq.addThreadFilter(ref);
        }
        brkReq.enable();
        this.cmds.putEvents();
    }

    @RmiMethodRegistry.TraceMethod(display="Break on thread start")
    public void break_started_container(@TraceObjectMethod.Param(schema="EventContainer", name="container") RmiTraceObject obj) {
        this.break_started(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on thread start")
    public void break_started_thread(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        this.break_started(obj);
    }

    private void break_death(RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        ThreadDeathRequest brkReq = vm.eventRequestManager().createThreadDeathRequest();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof ThreadReference) {
            ThreadReference ref = (ThreadReference)ctxt;
            brkReq.putProperty("Thread", ref);
            brkReq.addThreadFilter(ref);
        }
        brkReq.enable();
        this.cmds.putEvents();
    }

    @RmiMethodRegistry.TraceMethod(display="Break on thread exit")
    public void break_death_container(@TraceObjectMethod.Param(schema="EventContainer", name="container") RmiTraceObject obj) {
        this.break_death(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on thread exit")
    public void break_death_thread(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        this.break_death(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on VM death")
    public void break_vm_death(@TraceObjectMethod.Param(schema="VirtualMachine", name="vm") RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        VMDeathRequest brkReq = vm.eventRequestManager().createVMDeathRequest();
        brkReq.enable();
        this.cmds.putEvents();
    }

    private void break_enter(RmiTraceObject obj) {
        ObjectReference ref;
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        MethodEntryRequest brkReq = vm.eventRequestManager().createMethodEntryRequest();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof ReferenceType) {
            ReferenceType reftype = (ReferenceType)ctxt;
            brkReq.putProperty("Class", reftype);
            brkReq.addClassFilter(reftype);
        }
        if (ctxt instanceof ObjectReference) {
            ref = (ObjectReference)ctxt;
            brkReq.putProperty("Instance", ref);
            brkReq.addInstanceFilter(ref);
        }
        if (ctxt instanceof ThreadReference) {
            ref = (ThreadReference)ctxt;
            brkReq.putProperty("Thread", ref);
            brkReq.addThreadFilter((ThreadReference)ref);
        }
        brkReq.enable();
        this.cmds.putEvents();
    }

    @RmiMethodRegistry.TraceMethod(display="Break on method enter")
    public void break_enter_container(@TraceObjectMethod.Param(schema="EventContainer", name="container") RmiTraceObject obj) {
        this.break_enter(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on method enter")
    public void break_enter_reftype(@TraceObjectMethod.Param(schema="ReferenceType", name="class") RmiTraceObject obj) {
        this.break_enter(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on method enter")
    public void break_enter_instance(@TraceObjectMethod.Param(schema="ObjectReference", name="instance") RmiTraceObject obj) {
        this.break_enter(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on method enter")
    public void break_enter_thread(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        this.break_enter(obj);
    }

    private void break_exit(RmiTraceObject obj) {
        ObjectReference ref;
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        MethodExitRequest brkReq = vm.eventRequestManager().createMethodExitRequest();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof ReferenceType) {
            ReferenceType reftype = (ReferenceType)ctxt;
            brkReq.putProperty("Class", reftype);
            brkReq.addClassFilter(reftype);
        }
        if (ctxt instanceof ObjectReference) {
            ref = (ObjectReference)ctxt;
            brkReq.putProperty("Instance", ref);
            brkReq.addInstanceFilter(ref);
        }
        if (ctxt instanceof ThreadReference) {
            ref = (ThreadReference)ctxt;
            brkReq.putProperty("Thread", ref);
            brkReq.addThreadFilter((ThreadReference)ref);
        }
        brkReq.enable();
        this.cmds.putEvents();
    }

    @RmiMethodRegistry.TraceMethod(display="Break on method exit")
    public void break_exit_container(@TraceObjectMethod.Param(schema="EventContainer", name="container") RmiTraceObject obj) {
        this.break_exit(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on method exit")
    public void break_exit_reftype(@TraceObjectMethod.Param(schema="ReferenceType", name="class") RmiTraceObject obj) {
        this.break_exit(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on method exit")
    public void break_exit_instance(@TraceObjectMethod.Param(schema="ObjectReference", name="instance") RmiTraceObject obj) {
        this.break_exit(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on method exit")
    public void break_exit_thread(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        this.break_exit(obj);
    }

    private void break_load(RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        ClassPrepareRequest brkReq = vm.eventRequestManager().createClassPrepareRequest();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof ReferenceType) {
            ReferenceType reftype = (ReferenceType)ctxt;
            brkReq.putProperty("Class", reftype);
            brkReq.addClassFilter(reftype);
        }
        brkReq.enable();
        this.cmds.putEvents();
    }

    @RmiMethodRegistry.TraceMethod(display="Break on class load")
    public void break_load_container(@TraceObjectMethod.Param(schema="EventContainer", name="container") RmiTraceObject obj) {
        this.break_load(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on class load")
    public void break_load_reftype(@TraceObjectMethod.Param(schema="ReferenceType", name="class") RmiTraceObject obj) {
        this.break_load(obj);
    }

    private void break_unload(RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        ClassUnloadRequest brkReq = vm.eventRequestManager().createClassUnloadRequest();
        brkReq.enable();
        this.cmds.putEvents();
    }

    @RmiMethodRegistry.TraceMethod(display="Break on class unload")
    public void break_unload_container(@TraceObjectMethod.Param(schema="EventContainer", name="container") RmiTraceObject obj) {
        this.break_unload(obj);
    }

    private void break_mon_enter_contention(RmiTraceObject obj) {
        ObjectReference ref;
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        MonitorContendedEnterRequest brkReq = vm.eventRequestManager().createMonitorContendedEnterRequest();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof ReferenceType) {
            ReferenceType reftype = (ReferenceType)ctxt;
            brkReq.putProperty("Class", reftype);
            brkReq.addClassFilter(reftype);
        }
        if (ctxt instanceof ObjectReference) {
            ref = (ObjectReference)ctxt;
            brkReq.putProperty("Instance", ref);
            brkReq.addInstanceFilter(ref);
        }
        if (ctxt instanceof ThreadReference) {
            ref = (ThreadReference)ctxt;
            brkReq.putProperty("Thread", ref);
            brkReq.addThreadFilter((ThreadReference)ref);
        }
        brkReq.enable();
        this.cmds.putEvents();
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor contended enter")
    public void break_mon_enter_contention_container(@TraceObjectMethod.Param(schema="EventContainer", name="container") RmiTraceObject obj) {
        this.break_mon_enter_contention(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor contended enter")
    public void break_mon_enter_contention_reftype(@TraceObjectMethod.Param(schema="ReferenceType", name="class") RmiTraceObject obj) {
        this.break_mon_enter_contention(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor contended enter")
    public void break_mon_enter_contention_instance(@TraceObjectMethod.Param(schema="ObjectReference", name="instance") RmiTraceObject obj) {
        this.break_mon_enter_contention(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor contended enter")
    public void break_mon_enter_contention_thread(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        this.break_mon_enter_contention(obj);
    }

    private void break_mon_entered_contention(RmiTraceObject obj) {
        ObjectReference ref;
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        MonitorContendedEnteredRequest brkReq = vm.eventRequestManager().createMonitorContendedEnteredRequest();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof ReferenceType) {
            ReferenceType reftype = (ReferenceType)ctxt;
            brkReq.putProperty("Class", reftype);
            brkReq.addClassFilter(reftype);
        }
        if (ctxt instanceof ObjectReference) {
            ref = (ObjectReference)ctxt;
            brkReq.putProperty("Instance", ref);
            brkReq.addInstanceFilter(ref);
        }
        if (ctxt instanceof ThreadReference) {
            ref = (ThreadReference)ctxt;
            brkReq.putProperty("Thread", ref);
            brkReq.addThreadFilter((ThreadReference)ref);
        }
        brkReq.enable();
        this.cmds.putEvents();
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor contented entered")
    public void break_mon_entered_contention_container(@TraceObjectMethod.Param(schema="EventContainer", name="container") RmiTraceObject obj) {
        this.break_mon_entered_contention(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor contented entered")
    public void break_mon_entered_contention_reftype(@TraceObjectMethod.Param(schema="ReferenceType", name="class") RmiTraceObject obj) {
        this.break_mon_entered_contention(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor contented entered")
    public void break_mon_entered_contention_instance(@TraceObjectMethod.Param(schema="ObjectReference", name="instance") RmiTraceObject obj) {
        this.break_mon_entered_contention(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor contented entered")
    public void break_mon_entered_contention_thread(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        this.break_mon_entered_contention(obj);
    }

    private void break_mon_wait(RmiTraceObject obj) {
        ObjectReference ref;
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        MonitorWaitRequest brkReq = vm.eventRequestManager().createMonitorWaitRequest();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof ReferenceType) {
            ReferenceType reftype = (ReferenceType)ctxt;
            brkReq.putProperty("Class", reftype);
            brkReq.addClassFilter(reftype);
        }
        if (ctxt instanceof ObjectReference) {
            ref = (ObjectReference)ctxt;
            brkReq.putProperty("Instance", ref);
            brkReq.addInstanceFilter(ref);
        }
        if (ctxt instanceof ThreadReference) {
            ref = (ThreadReference)ctxt;
            brkReq.putProperty("Thread", ref);
            brkReq.addThreadFilter((ThreadReference)ref);
        }
        brkReq.enable();
        this.cmds.putEvents();
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor wait")
    public void break_mon_wait_container(@TraceObjectMethod.Param(schema="EventContainer", name="container") RmiTraceObject obj) {
        this.break_mon_wait(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor wait")
    public void break_mon_wait_reftype(@TraceObjectMethod.Param(schema="ReferenceType", name="class") RmiTraceObject obj) {
        this.break_mon_wait(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor wait")
    public void break_mon_wait_instance(@TraceObjectMethod.Param(schema="ObjectReference", name="instance") RmiTraceObject obj) {
        this.break_mon_wait(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor wait")
    public void break_mon_wait_thread(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        this.break_mon_wait(obj);
    }

    private void break_mon_waited(RmiTraceObject obj) {
        ObjectReference ref;
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        MonitorWaitedRequest brkReq = vm.eventRequestManager().createMonitorWaitedRequest();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof ReferenceType) {
            ReferenceType reftype = (ReferenceType)ctxt;
            brkReq.putProperty("Class", reftype);
            brkReq.addClassFilter(reftype);
        }
        if (ctxt instanceof ObjectReference) {
            ref = (ObjectReference)ctxt;
            brkReq.putProperty("Instance", ref);
            brkReq.addInstanceFilter(ref);
        }
        if (ctxt instanceof ThreadReference) {
            ref = (ThreadReference)ctxt;
            brkReq.putProperty("Thread", ref);
            brkReq.addThreadFilter((ThreadReference)ref);
        }
        brkReq.enable();
        this.cmds.putEvents();
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor waited")
    public void break_mon_waited_container(@TraceObjectMethod.Param(schema="EventContainer", name="container") RmiTraceObject obj) {
        this.break_mon_waited(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor waited")
    public void break_mon_waited_reftype(@TraceObjectMethod.Param(schema="ReferenceType", name="class") RmiTraceObject obj) {
        this.break_mon_waited(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor waited")
    public void break_mon_waited_instance(@TraceObjectMethod.Param(schema="ObjectReference", name="instance") RmiTraceObject obj) {
        this.break_mon_waited(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Break on monitor waited")
    public void break_mon_waited_thread(@TraceObjectMethod.Param(schema="Thread", name="thread") RmiTraceObject obj) {
        this.break_mon_waited(obj);
    }

    @RmiMethodRegistry.TraceMethod(display="Add count filter")
    public void add_count_filter(@TraceObjectMethod.Param(schema="Event", description="Event", display="Event", name="event") RmiTraceObject obj, @TraceObjectMethod.Param(description="Count", display="MaxCount", name="count") int count) {
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof EventRequest) {
            EventRequest req = (EventRequest)ctxt;
            req.disable();
            req.addCountFilter(count);
            this.cmds.setValue(obj.getPath(), "Count", count);
            req.enable();
            this.cmds.putEvents();
        }
    }

    @RmiMethodRegistry.TraceMethod(display="Set class filter")
    public void set_class_filter(@TraceObjectMethod.Param(schema="Event", description="Event", display="Event", name="event") RmiTraceObject obj, @TraceObjectMethod.Param(description="Filter Pattern", display="Filter", name="filter") String filter, @TraceObjectMethod.Param(description="Exclude", display="Exclude", name="exclude") boolean exclude) {
        EventRequest req;
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof MethodEntryRequest) {
            req = (MethodEntryRequest)ctxt;
            req.disable();
            if (exclude) {
                req.addClassExclusionFilter(filter);
                this.cmds.setValue(obj.getPath(), "Exclude", filter);
            } else {
                req.addClassFilter(filter);
                this.cmds.setValue(obj.getPath(), "Include", filter);
            }
            req.enable();
        }
        if (ctxt instanceof MethodExitRequest) {
            req = (MethodExitRequest)ctxt;
            req.disable();
            if (exclude) {
                req.addClassExclusionFilter(filter);
                this.cmds.setValue(obj.getPath(), "Exclude", filter);
            } else {
                req.addClassFilter(filter);
                this.cmds.setValue(obj.getPath(), "Include", filter);
            }
            req.enable();
        }
        if (ctxt instanceof ClassPrepareRequest) {
            req = (ClassPrepareRequest)ctxt;
            req.disable();
            if (exclude) {
                req.addClassExclusionFilter(filter);
                this.cmds.setValue(obj.getPath(), "Exclude", filter);
            } else {
                req.addClassFilter(filter);
                this.cmds.setValue(obj.getPath(), "Include", filter);
            }
            req.enable();
        }
        if (ctxt instanceof ClassUnloadRequest) {
            req = (ClassUnloadRequest)ctxt;
            req.disable();
            if (exclude) {
                req.addClassExclusionFilter(filter);
                this.cmds.setValue(obj.getPath(), "Exclude", filter);
            } else {
                req.addClassFilter(filter);
                this.cmds.setValue(obj.getPath(), "Include", filter);
            }
            req.enable();
        }
        if (ctxt instanceof MonitorContendedEnterRequest) {
            req = (MonitorContendedEnterRequest)ctxt;
            req.disable();
            if (exclude) {
                req.addClassExclusionFilter(filter);
                this.cmds.setValue(obj.getPath(), "Exclude", filter);
            } else {
                req.addClassFilter(filter);
                this.cmds.setValue(obj.getPath(), "Include", filter);
            }
            req.enable();
        }
        if (ctxt instanceof MonitorContendedEnteredRequest) {
            req = (MonitorContendedEnteredRequest)ctxt;
            req.disable();
            if (exclude) {
                req.addClassExclusionFilter(filter);
                this.cmds.setValue(obj.getPath(), "Exclude", filter);
            } else {
                req.addClassFilter(filter);
                this.cmds.setValue(obj.getPath(), "Include", filter);
            }
            req.enable();
        }
        if (ctxt instanceof MonitorWaitRequest) {
            req = (MonitorWaitRequest)ctxt;
            req.disable();
            if (exclude) {
                req.addClassExclusionFilter(filter);
                this.cmds.setValue(obj.getPath(), "Exclude", filter);
            } else {
                req.addClassFilter(filter);
                this.cmds.setValue(obj.getPath(), "Include", filter);
            }
            req.enable();
        }
        if (ctxt instanceof MonitorWaitedRequest) {
            req = (MonitorWaitedRequest)ctxt;
            req.disable();
            if (exclude) {
                req.addClassExclusionFilter(filter);
                this.cmds.setValue(obj.getPath(), "Exclude", filter);
            } else {
                req.addClassFilter(filter);
                this.cmds.setValue(obj.getPath(), "Include", filter);
            }
            req.enable();
        }
        this.cmds.putEvents();
    }

    @RmiMethodRegistry.TraceMethod(display="Set source filter")
    public void set_source_filter(@TraceObjectMethod.Param(schema="Event", description="Event", display="Event", name="event") RmiTraceObject obj, @TraceObjectMethod.Param(description="Source Name Pattern", display="SourceName", name="source_name") String srcname) {
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof ClassPrepareRequest) {
            ClassPrepareRequest req = (ClassPrepareRequest)ctxt;
            req.disable();
            req.addSourceNameFilter(srcname);
            this.cmds.setValue(obj.getPath(), "SourceMatches", srcname);
            req.enable();
        }
        this.cmds.putEvents();
    }

    @RmiMethodRegistry.TraceMethod(display="Set platform filter")
    public void set_platform_filter(@TraceObjectMethod.Param(schema="Event", name="event") RmiTraceObject obj) {
        EventRequest req;
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof ThreadStartRequest) {
            req = (ThreadStartRequest)ctxt;
            req.disable();
            req.addPlatformThreadsOnlyFilter();
            this.cmds.setValue(obj.getPath(), "PlatformOnly", true);
            req.enable();
        }
        if (ctxt instanceof ThreadDeathRequest) {
            req = (ThreadDeathRequest)ctxt;
            req.disable();
            req.addPlatformThreadsOnlyFilter();
            this.cmds.setValue(obj.getPath(), "PlatformOnly", true);
            req.enable();
        }
        this.cmds.putEvents();
    }

    @RmiMethodRegistry.TraceMethod(action="toggle", display="Toggle breakpoint")
    public void toggle_breakpoint(@TraceObjectMethod.Param(schema="BreakpointSpec", name="breakpoint") RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof Field) {
            Field field = (Field)ctxt;
            ModificationWatchpointRequest brkReq = vm.eventRequestManager().createModificationWatchpointRequest(field);
            brkReq.enable();
        }
        if (ctxt instanceof EventRequest) {
            EventRequest req = (EventRequest)ctxt;
            if (req.isEnabled()) {
                req.disable();
            } else {
                req.enable();
            }
        }
        this.cmds.putBreakpoints();
    }

    @RmiMethodRegistry.TraceMethod(action="delete", display="Delete breakpoint")
    public void delete_breakpoint(@TraceObjectMethod.Param(schema="BreakpointSpec", name="breakpoint") RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof EventRequest) {
            EventRequest req = (EventRequest)ctxt;
            vm.eventRequestManager().deleteEventRequest(req);
        }
        this.cmds.putBreakpoints();
    }

    @RmiMethodRegistry.TraceMethod(action="toggle", display="Toggle event")
    public void toggle_event(@TraceObjectMethod.Param(schema="Event", name="event") RmiTraceObject obj) {
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof EventRequest) {
            EventRequest req = (EventRequest)ctxt;
            if (req.isEnabled()) {
                req.disable();
            } else {
                req.enable();
            }
            this.cmds.putEvents();
        }
    }

    @RmiMethodRegistry.TraceMethod(action="delete", display="Delete Event")
    public void delete_event(@TraceObjectMethod.Param(schema="Event", name="event") RmiTraceObject obj) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        Object ctxt = this.getObjectFromPath(obj.getPath());
        if (ctxt instanceof EventRequest) {
            EventRequest req = (EventRequest)ctxt;
            vm.eventRequestManager().deleteEventRequest(req);
        }
        this.cmds.putEvents();
    }

    @RmiMethodRegistry.TraceMethod(action="toggle", display="Toggle scope")
    public void toggle_scope_canonical_methods(@TraceObjectMethod.Param(schema="CanonicalMethodContainer", name="container") RmiTraceObject obj) {
        this.toggle_scope_methods(obj);
    }

    @RmiMethodRegistry.TraceMethod(action="toggle", display="Toggle scope")
    public void toggle_scope_methods(@TraceObjectMethod.Param(schema="MethodContainer", name="container") RmiTraceObject obj) {
        String ppath = this.cmds.getParentPath(obj.getPath());
        Object parent = this.getObjectFromPath(ppath);
        this.connector.toggleScope(parent);
        this.refresh_methods(obj);
    }

    @RmiMethodRegistry.TraceMethod(action="toggle", display="Toggle scope")
    public void toggle_scope_canonical_fields(@TraceObjectMethod.Param(schema="CanonicalFieldContainer", name="container") RmiTraceObject obj) {
        this.toggle_scope_fields(obj);
    }

    @RmiMethodRegistry.TraceMethod(action="toggle", display="Toggle scope")
    public void toggle_scope_fields(@TraceObjectMethod.Param(schema="FieldContainer", name="container") RmiTraceObject obj) {
        String ppath = this.cmds.getParentPath(obj.getPath());
        Object parent = this.getObjectFromPath(ppath);
        this.connector.toggleScope(parent);
        if (obj.getPath().endsWith("Fields")) {
            this.refresh_fields(obj);
        }
        if (obj.getPath().endsWith("Variables")) {
            this.refresh_fields(obj);
        }
    }

    @RmiMethodRegistry.TraceMethod(action="read_mem", display="Read Memory")
    public long read_mem(@TraceObjectMethod.Param(schema="VirtualMachine", description="VirtualMachine", display="VirtualMachine", name="vm") RmiTraceObject obj, @TraceObjectMethod.Param(description="Range", display="Range", name="range") AddressRange range) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        MemoryMapper mapper = this.cmds.state.trace.memoryMapper;
        Address start = mapper.mapBack(range.getMinAddress());
        try (RmiTransaction tx = this.cmds.state.trace.openTx("ReadMemory");){
            this.cmds.putMem(start, range.getLength(), true);
            this.cmds.putMemState(start, range.getLength(), TraceRmi.MemoryState.MS_KNOWN, true);
        }
        catch (Exception e) {
            this.cmds.putMemState(start, range.getLength(), TraceRmi.MemoryState.MS_ERROR, true);
        }
        return range.getLength();
    }

    @RmiMethodRegistry.TraceMethod(display="Invoke method (no args)")
    public void execute_on_instance(@TraceObjectMethod.Param(schema="ObjectReference", description="Object Reference", display="Object", name="object") RmiTraceObject obj, @TraceObjectMethod.Param(description="Thread Name", display="ThreadName", name="thread_name") String threadName, @TraceObjectMethod.Param(description="Method Name", display="MethodName", name="method_name") String methodName) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        ObjectReference ref = (ObjectReference)this.getObjectFromPath(obj.getPath());
        List<com.sun.jdi.Method> methods = ref.referenceType().methodsByName(methodName);
        if (methods.size() > 1) {
            Msg.warn((Object)this, (Object)("Method " + methodName + " is not unique - using first variant"));
        }
        for (ThreadReference thread : vm.allThreads()) {
            if (!thread.name().equals(threadName)) continue;
            this.cmds.execute(ref, thread, methods.get(0), new ArrayList<Value>(), 0);
        }
    }

    @RmiMethodRegistry.TraceMethod(display="Invoke static method (no args)")
    public void execute_on_class(@TraceObjectMethod.Param(schema="ReferenceType", description="Class", display="Class", name="class") RmiTraceObject obj, @TraceObjectMethod.Param(description="Thread Name", display="ThreadName", name="thread_name") String threadName, @TraceObjectMethod.Param(description="Method Name", display="MethodName", name="method_name") String methodName) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        ReferenceType reftype = (ReferenceType)this.getObjectFromPath(obj.getPath());
        if (reftype instanceof ClassType) {
            ClassType cls = (ClassType)reftype;
            List<com.sun.jdi.Method> methods = cls.methodsByName(methodName);
            if (methods.size() > 1) {
                Msg.warn((Object)this, (Object)("Method " + methodName + " is not unique - using first variant"));
            }
            if (!methods.get(0).isStatic()) {
                Msg.error((Object)this, (Object)("Method " + methodName + " is not static"));
                return;
            }
            for (ThreadReference thread : vm.allThreads()) {
                if (!thread.name().equals(threadName)) continue;
                this.cmds.execute(cls, thread, methods.get(0), new ArrayList<Value>(), 0);
            }
        }
    }

    @RmiMethodRegistry.TraceMethod(display="Invoke method (no args)")
    public void execute_method(@TraceObjectMethod.Param(schema="Method", description="Method", display="Method", name="method") RmiTraceObject obj, @TraceObjectMethod.Param(description="Instance Pattern", display="InstancePattern", name="instance_pattern") String instancePattern, @TraceObjectMethod.Param(description="Thread Name", display="ThreadName", name="thread_name") String threadName) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        String path = obj.getPath();
        com.sun.jdi.Method method = (com.sun.jdi.Method)this.getObjectFromPath(path);
        ReferenceType declaringType = method.declaringType();
        List<ObjectReference> instances = declaringType.instances(0L);
        for (ObjectReference ref : instances) {
            if (!ref.toString().contains(instancePattern)) continue;
            for (ThreadReference thread : vm.allThreads()) {
                if (!thread.name().equals(threadName)) continue;
                this.cmds.execute(ref, thread, method, new ArrayList<Value>(), 0);
            }
        }
    }

    @RmiMethodRegistry.TraceMethod(display="Invoke static method (no args)")
    public void execute_static_method(@TraceObjectMethod.Param(schema="Method", description="Method", display="Method", name="method") RmiTraceObject obj, @TraceObjectMethod.Param(description="Thread Name", display="ThreadName", name="thread_name") String threadName) {
        VirtualMachine vm = this.connector.getJdi().getCurrentVM();
        String path = obj.getPath();
        com.sun.jdi.Method method = (com.sun.jdi.Method)this.getObjectFromPath(path);
        if (!method.isStatic()) {
            Msg.error((Object)this, (Object)("Method " + method.name() + " is not static"));
            return;
        }
        ReferenceType reftype = method.declaringType();
        if (reftype instanceof ClassType) {
            ClassType ct = (ClassType)reftype;
            for (ThreadReference thread : vm.allThreads()) {
                if (!thread.name().equals(threadName)) continue;
                this.cmds.execute(ct, thread, method, new ArrayList<Value>(), 0);
            }
        }
    }

    private List<ThreadReference> getThreadsFromValue(RmiTraceObject obj) {
        Object object = this.getObjectFromPath(obj.getPath());
        if (object instanceof VirtualMachine) {
            VirtualMachine vm = (VirtualMachine)object;
            return vm.allThreads();
        }
        ArrayList<ThreadReference> threads = new ArrayList<ThreadReference>();
        if (object instanceof ThreadReference) {
            ThreadReference thread = (ThreadReference)object;
            threads.add(thread);
        } else {
            threads.add(this.connector.getJdi().getCurrentThread());
        }
        return threads;
    }

    private Object getObjectFromPath(String path) {
        return this.connector.objForPath(path);
    }
}

