/*
 * Decompiled with CFR 0.152.
 */
package docking.actions;

import docking.DockingUtils;
import docking.Tool;
import docking.action.ActionContextProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.actions.ActionAdapter;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.xml.GenericXMLOutputter;
import ghidra.util.xml.XmlUtilities;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.commons.collections4.map.LazyMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import util.CollectionUtils;
import utilities.util.reflection.ReflectionUtilities;

public class KeyBindingUtils {
    private static final String NO_KEYBINDING_NAME = "none";
    private static final String LAST_KEY_BINDING_EXPORT_DIRECTORY = "LastKeyBindingExportDirectory";
    private static final String RELEASED = "released";
    private static final String TYPED = "typed";
    private static final String PRESSED = "pressed";
    private static final String SHIFT = "Shift";
    private static final String CTRL = "Ctrl";
    private static final String CONTROL = "Control";
    private static final String ALT = "Alt";
    private static final String META = "Meta";
    private static final String MODIFIER_SEPARATOR = "-";
    private static final Logger log = LogManager.getLogger(KeyBindingUtils.class);
    public static final String PREFERENCES_FILE_EXTENSION = ".kbxml";
    private static final GhidraFileFilter FILE_FILTER = new GhidraFileFilter(){

        public boolean accept(File pathname, GhidraFileChooserModel model) {
            return pathname.isDirectory() || pathname.getName().endsWith(KeyBindingUtils.PREFERENCES_FILE_EXTENSION);
        }

        public String getDescription() {
            return "Key Bindings XML Files";
        }
    };

    private KeyBindingUtils() {
    }

    public static ToolOptions importKeyBindings() {
        InputStream inputStream = KeyBindingUtils.getInputStreamForFile(KeyBindingUtils.getStartingDir());
        return KeyBindingUtils.createOptionsforKeybindings(inputStream);
    }

    public static ToolOptions createOptionsforKeybindings(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        ToolOptions newKeyBindingOptions = null;
        SAXBuilder builder = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
        Element rootElement = null;
        try {
            rootElement = builder.build(inputStream).getRootElement();
        }
        catch (JDOMException e) {
            Msg.showError((Object)log, null, (String)"Error Loading Key Bindings", (Object)"Unable to build XML data.", (Throwable)e);
        }
        catch (IOException e) {
            Msg.showError((Object)log, null, (String)"Error Loading Key Bindings", (Object)"Unable to build XML data.", (Throwable)e);
        }
        if (rootElement != null) {
            newKeyBindingOptions = new ToolOptions(rootElement);
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return newKeyBindingOptions;
    }

    public static void exportKeyBindings(ToolOptions keyBindingOptions) {
        OutputStream outputStream = KeyBindingUtils.getOutputStreamForFile(KeyBindingUtils.getStartingDir());
        if (outputStream == null) {
            return;
        }
        Element rootElement = keyBindingOptions.getXmlRoot(true);
        Document document = new Document(rootElement);
        GenericXMLOutputter xmlOutputter = new GenericXMLOutputter();
        try {
            xmlOutputter.output(document, outputStream);
        }
        catch (IOException ioe) {
            Msg.showError((Object)log, null, (String)"Error Saving Key Bindings", (Object)"Unable to save key bindings as XML data.", (Throwable)ioe);
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void retargetEvent(Component newSource, KeyEvent e) {
        if (e.getSource() == newSource) {
            return;
        }
        KeyEvent newEvent = new KeyEvent(newSource, e.getID(), e.getWhen(), e.getModifiersEx(), e.getKeyCode(), e.getKeyChar(), e.getKeyLocation());
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (newSource.isShowing()) {
            kfm.dispatchEvent(newEvent);
        } else {
            kfm.redispatchEvent(newSource, newEvent);
        }
        if (newEvent.isConsumed()) {
            e.consume();
        }
    }

    public static void registerAction(JComponent component, DockingAction action) {
        KeyStroke keyBinding = action.getKeyBinding();
        KeyBindingUtils.registerAction(component, keyBinding, new ActionAdapter(action), 0);
    }

    public static void registerAction(JComponent component, DockingAction action, ActionContextProvider contextProvider) {
        KeyStroke keyBinding = action.getKeyBinding();
        KeyBindingUtils.registerAction(component, keyBinding, new ActionAdapter(action, contextProvider), 0);
    }

    public static void registerAction(JComponent component, DockingAction action, ActionContextProvider contextProvider, int focusCondition) {
        KeyStroke keyBinding = action.getKeyBinding();
        KeyBindingUtils.registerAction(component, keyBinding, new ActionAdapter(action, contextProvider), focusCondition);
    }

    public static void registerAction(JComponent component, KeyStroke keyStroke, Action action, int focusCondition) {
        if (keyStroke == null) {
            Msg.debug(KeyBindingUtils.class, (Object)("Attempted to register an action without providing a keystroke - action: " + String.valueOf(action.getValue("Name"))));
            return;
        }
        InputMap im = component.getInputMap(focusCondition);
        if (im == null) {
            return;
        }
        ActionMap am = component.getActionMap();
        if (am == null) {
            return;
        }
        Object keyText = im.get(keyStroke);
        if (keyText == null || keyText.equals(NO_KEYBINDING_NAME)) {
            keyText = action.getValue("Name");
            if (keyText == null) {
                Msg.error(KeyBindingUtils.class, (Object)"Action must have a name to be registered", (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
                return;
            }
            im.put(keyStroke, keyText);
        }
        am.put(keyText, action);
    }

    public static void clearKeyBinding(JComponent component, DockingActionIf action) {
        KeyStroke keyBinding = action.getKeyBinding();
        if (keyBinding == null) {
            return;
        }
        KeyBindingUtils.clearKeyBinding(component, keyBinding);
    }

    public static void clearKeyBinding(JComponent component, KeyStroke keyStroke) {
        KeyBindingUtils.clearKeyBinding(component, keyStroke, 0);
        KeyBindingUtils.clearKeyBinding(component, keyStroke, 1);
    }

    public static void clearKeyBinding(JComponent component, KeyStroke keyStroke, int focusCondition) {
        InputMap inputMap = component.getInputMap(focusCondition);
        if (inputMap != null) {
            inputMap.put(keyStroke, NO_KEYBINDING_NAME);
        }
    }

    public static void clearKeyBinding(JComponent component, String actionName) {
        InputMap inputMap = component.getInputMap(0);
        if (inputMap == null) {
            return;
        }
        KeyStroke keyStroke = null;
        KeyStroke[] keys = inputMap.allKeys();
        if (keys == null) {
            Msg.debug(KeyBindingUtils.class, (Object)("Cannot remove action by name; does not exist: '" + actionName + "' on component: " + component.getClass().getSimpleName()));
            return;
        }
        for (KeyStroke ks : keys) {
            Object object = inputMap.get(ks);
            if (!actionName.equals(object)) continue;
            keyStroke = ks;
            break;
        }
        if (keyStroke != null) {
            KeyBindingUtils.clearKeyBinding(component, keyStroke);
        }
    }

    public static Action getAction(JComponent component, KeyStroke keyStroke, int focusCondition) {
        InputMap inputMap = component.getInputMap(focusCondition);
        ActionMap actionMap = component.getActionMap();
        if (inputMap == null || actionMap == null) {
            return null;
        }
        Object binding = inputMap.get(keyStroke);
        return binding == null ? null : actionMap.get(binding);
    }

    public static Map<String, List<DockingActionIf>> getAllActionsByFullName(Tool tool) {
        LazyMap result = LazyMap.lazyMap(new HashMap(), s -> new LinkedList());
        Set<DockingActionIf> actions = tool.getAllActions();
        for (DockingActionIf action : actions) {
            if (KeyBindingUtils.isIgnored(action)) continue;
            ((List)result.get(action.getFullName())).add(action);
        }
        return result;
    }

    public static Set<DockingActionIf> getKeyBindingActionsForOwner(Tool tool, String owner) {
        HashMap<String, DockingActionIf> deduper = new HashMap<String, DockingActionIf>();
        Set<DockingActionIf> actions = tool.getDockingActionsByOwnerName(owner);
        for (DockingActionIf action : actions) {
            if (KeyBindingUtils.isIgnored(action)) continue;
            deduper.put(action.getFullName(), action);
        }
        return CollectionUtils.asSet(deduper.values());
    }

    public static Set<DockingActionIf> getActions(Set<DockingActionIf> allActions, String owner, String name) {
        return allActions.stream().filter(a -> a.getOwner().equals(owner)).filter(a -> a.getName().equals(name)).collect(Collectors.toSet());
    }

    public static Action adaptDockingActionToNonContextAction(DockingAction action) {
        return new ActionAdapter(action);
    }

    public static KeyStroke validateKeyStroke(KeyStroke keyStroke) {
        int eventType;
        if (keyStroke == null) {
            return null;
        }
        int modifiers = keyStroke.getModifiers();
        if ((modifiers & 0x80) == 128) {
            modifiers ^= 0x80;
            modifiers |= DockingUtils.CONTROL_KEY_MODIFIER_MASK;
        }
        if ((modifiers & 2) == 2) {
            modifiers ^= 2;
            modifiers |= DockingUtils.CONTROL_KEY_MODIFIER_MASK;
        }
        if ((modifiers & 2) == 2) {
            modifiers ^= 2;
            modifiers |= DockingUtils.CONTROL_KEY_MODIFIER_MASK;
        }
        if ((modifiers & 1) == 1) {
            modifiers ^= 1;
            modifiers |= 0x40;
        }
        if ((modifiers & 8) == 8) {
            modifiers ^= 8;
            modifiers |= 0x200;
        }
        if ((modifiers & 4) == 4) {
            modifiers ^= 4;
            modifiers |= 0x100;
        }
        if ((eventType = keyStroke.getKeyEventType()) == 400) {
            return KeyStroke.getKeyStroke(Character.valueOf(keyStroke.getKeyChar()), modifiers);
        }
        boolean isOnKeyRelease = keyStroke.isOnKeyRelease();
        return KeyStroke.getKeyStroke(keyStroke.getKeyCode(), modifiers, isOnKeyRelease);
    }

    public static String parseKeyStroke(KeyStroke keyStroke) {
        int metaIndex;
        int shiftIndex;
        int altIndex;
        if (keyStroke == null) {
            return "";
        }
        String keyPressSuffix = "-P";
        String keyString = keyStroke.toString();
        int type = keyStroke.getKeyEventType();
        if (type == 400) {
            return String.valueOf(keyStroke.getKeyChar());
        }
        int firstIndex = keyString.lastIndexOf(32) + 1;
        int ctrlIndex = KeyBindingUtils.indexOf(keyString, CTRL, firstIndex);
        if (ctrlIndex >= 0) {
            firstIndex = ctrlIndex + CTRL.length();
        }
        if ((altIndex = KeyBindingUtils.indexOf(keyString, ALT, firstIndex)) >= 0) {
            firstIndex = altIndex + ALT.length();
        }
        if ((shiftIndex = KeyBindingUtils.indexOf(keyString, SHIFT, firstIndex)) >= 0) {
            firstIndex = shiftIndex + SHIFT.length();
        }
        if ((metaIndex = KeyBindingUtils.indexOf(keyString, META, firstIndex)) >= 0) {
            firstIndex = metaIndex + META.length();
        }
        int lastIndex = keyString.length();
        if (keyString.endsWith("-P")) {
            lastIndex -= "-P".length();
        }
        if (lastIndex >= 0) {
            keyString = keyString.substring(firstIndex, lastIndex);
        }
        int modifiers = keyStroke.getModifiers();
        StringBuilder buffy = new StringBuilder();
        if (KeyBindingUtils.isShift(modifiers)) {
            buffy.insert(0, "Shift-");
            keyString = StringUtils.removeIgnoreCase((String)keyString, (String)SHIFT);
        }
        if (KeyBindingUtils.isAlt(modifiers)) {
            buffy.insert(0, "Alt-");
            keyString = StringUtils.removeIgnoreCase((String)keyString, (String)ALT);
        }
        if (KeyBindingUtils.isControl(modifiers)) {
            buffy.insert(0, "Ctrl-");
            keyString = StringUtils.removeIgnoreCase((String)keyString, (String)CONTROL);
        }
        if (KeyBindingUtils.isMeta(modifiers)) {
            buffy.insert(0, "Meta-");
            keyString = StringUtils.removeIgnoreCase((String)keyString, (String)META);
        }
        buffy.append(keyString);
        String text = buffy.toString().trim();
        if (text.endsWith(MODIFIER_SEPARATOR)) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    private static int indexOf(String source, String search, int offset) {
        return StringUtils.indexOfIgnoreCase((CharSequence)source, (CharSequence)search, (int)offset);
    }

    private static boolean isShift(int mask) {
        return (mask & 0x40) != 0 || (mask & 1) != 0;
    }

    private static boolean isAlt(int mask) {
        return (mask & 0x200) != 0 || (mask & 8) != 0;
    }

    private static boolean isControl(int mask) {
        return (mask & 0x80) != 0 || (mask & 2) != 0;
    }

    private static boolean isMeta(int mask) {
        return (mask & 0x100) != 0 || (mask & 4) != 0;
    }

    public static KeyStroke parseKeyStroke(String keyStroke) {
        if (StringUtils.isBlank((CharSequence)keyStroke)) {
            return null;
        }
        ArrayList<String> pieces = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(keyStroke, "- ");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (pieces.contains(token)) continue;
            pieces.add(token);
        }
        StringBuilder buffy = new StringBuilder();
        Iterator iterator = pieces.iterator();
        while (iterator.hasNext()) {
            String piece = (String)iterator.next();
            if (StringUtils.indexOfIgnoreCase((CharSequence)piece, (CharSequence)SHIFT) != -1) {
                buffy.append("shift ");
                iterator.remove();
                continue;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)piece, (CharSequence)CTRL) != -1) {
                buffy.append("ctrl ");
                iterator.remove();
                continue;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)piece, (CharSequence)CONTROL) != -1) {
                buffy.append("ctrl ");
                iterator.remove();
                continue;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)piece, (CharSequence)ALT) != -1) {
                buffy.append("alt ");
                iterator.remove();
                continue;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)piece, (CharSequence)META) != -1) {
                buffy.append("meta ");
                iterator.remove();
                continue;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)piece, (CharSequence)PRESSED) != -1) {
                iterator.remove();
                continue;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)piece, (CharSequence)TYPED) != -1) {
                iterator.remove();
                continue;
            }
            if (StringUtils.indexOfIgnoreCase((CharSequence)piece, (CharSequence)RELEASED) == -1) continue;
            iterator.remove();
        }
        buffy.append(PRESSED).append(' ');
        int leftover = pieces.size();
        if (leftover > 1 || leftover == 0) {
            Msg.warn(KeyBindingUtils.class, (Object)("Invalid keystroke string found.  Expected format of '[modifier] ... key'.  Found: '" + keyStroke + "'"));
            if (leftover == 0) {
                return null;
            }
        }
        String key = (String)pieces.get(0);
        buffy.append(key.toUpperCase());
        return KeyStroke.getKeyStroke(buffy.toString());
    }

    private static boolean isIgnored(DockingActionIf action) {
        return !action.getKeyBindingType().isManaged();
    }

    private static InputStream getInputStreamForFile(File startingDir) {
        File selectedFile = KeyBindingUtils.getFileFromUser(startingDir);
        if (selectedFile == null) {
            return null;
        }
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(selectedFile));
        }
        catch (FileNotFoundException fnfe) {
            Msg.showError((Object)log, null, (String)"File Not Found", (Object)("Cannot find file " + selectedFile.getAbsolutePath()), (Throwable)fnfe);
            return KeyBindingUtils.getInputStreamForFile(selectedFile);
        }
        return inputStream;
    }

    private static OutputStream getOutputStreamForFile(File startingDir) {
        File selectedFile = KeyBindingUtils.getFileFromUser(startingDir);
        if (selectedFile == null) {
            return null;
        }
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(selectedFile));
        }
        catch (FileNotFoundException fnfe) {
            Msg.showError((Object)log, null, (String)"File Not Found", (Object)("Cannot find file " + selectedFile.getAbsolutePath()), (Throwable)fnfe);
            return KeyBindingUtils.getOutputStreamForFile(selectedFile);
        }
        return outputStream;
    }

    private static File getStartingDir() {
        File dir;
        String lastDirectoryPath = Preferences.getProperty((String)LAST_KEY_BINDING_EXPORT_DIRECTORY);
        if (lastDirectoryPath != null && (dir = new File(lastDirectoryPath)).isDirectory()) {
            return dir;
        }
        return new File(System.getProperty("user.home"));
    }

    private static File getFileFromUser(File startingDir) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeComponent = kfm.getActiveWindow();
        GhidraFileChooser fileChooser = new GhidraFileChooser(activeComponent);
        fileChooser.setTitle("Please Select A File");
        fileChooser.setFileFilter(FILE_FILTER);
        fileChooser.setApproveButtonText("OK");
        fileChooser.setCurrentDirectory(startingDir);
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile != null && !selectedFile.getName().endsWith(PREFERENCES_FILE_EXTENSION)) {
            selectedFile = new File(selectedFile.getAbsolutePath() + PREFERENCES_FILE_EXTENSION);
        }
        Preferences.setProperty((String)LAST_KEY_BINDING_EXPORT_DIRECTORY, (String)fileChooser.getCurrentDirectory().getAbsolutePath());
        fileChooser.dispose();
        return selectedFile;
    }
}

