/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.jungrapht.visualization.control.AbstractGraphMousePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPopupGraphMousePlugin
extends AbstractGraphMousePlugin
implements MouseListener {
    private static Logger log = LoggerFactory.getLogger(AbstractGraphMousePlugin.class);
    private static int MENU_SHORTCUT = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
    protected int modifiers;

    public AbstractPopupGraphMousePlugin() {
        this(MENU_SHORTCUT);
    }

    public AbstractPopupGraphMousePlugin(int modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        log.trace("mousePressed in {}", (Object)this.getClass().getName());
        if (e.isPopupTrigger()) {
            this.handlePopup(e);
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        log.trace("mouseReleased in {}", (Object)this.getClass().getName());
        if (e.isPopupTrigger()) {
            this.handlePopup(e);
            e.consume();
        }
    }

    protected abstract void handlePopup(MouseEvent var1);

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

