/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.Map;
import javax.swing.JComponent;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.renderers.BiModalRenderer;
import org.jungrapht.visualization.renderers.ModalRenderer;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.transform.BidirectionalTransformer;
import org.jungrapht.visualization.transform.Lens;
import org.jungrapht.visualization.transform.LensTransformer;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;
import org.jungrapht.visualization.transform.shape.TransformingGraphics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiModalSelectionRenderer<V, E>
extends BiModalRenderer<V, E> {
    private static final Logger log = LoggerFactory.getLogger(BiModalSelectionRenderer.class);
    BiModalRenderer<V, E> other;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    protected BiModalSelectionRenderer(Builder<V, E, ?, ?> builder) {
        this(builder.component, builder.rendererMap, builder.modeSourceRenderer);
    }

    protected BiModalSelectionRenderer(JComponent component, Map<ModalRenderer.Mode, Renderer<V, E>> rendererMap, BiModalRenderer<V, E> modeSourceRenderer) {
        super(component, rendererMap);
        this.other = modeSourceRenderer;
    }

    @Override
    public void renderVertex(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, V v) {
        GraphicsDecorator graphicsDecorator = renderContext.getGraphicsContext();
        if (graphicsDecorator instanceof TransformingGraphics) {
            TransformingGraphics transformingGraphics = (TransformingGraphics)graphicsDecorator;
            BidirectionalTransformer bidirectionalTransformer = transformingGraphics.getTransformer();
            if (bidirectionalTransformer instanceof LensTransformer) {
                LensTransformer magnifyTransformer = (LensTransformer)bidirectionalTransformer;
                Lens lens = magnifyTransformer.getLens();
                Point p = (Point)layoutModel.apply(v);
                Point2D.Double layoutPoint = new Point2D.Double(p.x, p.y);
                Point2D viewPoint = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, layoutPoint);
                RectangularShape lensShape = lens.getLensShape();
                if (lensShape.contains(viewPoint)) {
                    double magnification = magnifyTransformer.getLens().getMagnification();
                    double product = magnification * magnifyTransformer.getScale();
                    ModalRenderer.Mode mode = this.other.getModeFor(() -> product);
                    ((Renderer)this.rendererMap.get(mode)).renderVertex(renderContext, layoutModel, v);
                } else {
                    ((Renderer)this.rendererMap.get(this.other.getMode())).renderVertex(renderContext, layoutModel, v);
                }
            }
        } else {
            ((Renderer)this.rendererMap.get(this.other.getMode())).renderVertex(renderContext, layoutModel, v);
        }
    }

    public static class Builder<V, E, T extends BiModalSelectionRenderer<V, E>, B extends Builder<V, E, T, B>>
    extends BiModalRenderer.Builder<V, E, T, B> {
        protected BiModalRenderer<V, E> modeSourceRenderer;

        public B modeSourceRenderer(BiModalRenderer<V, E> modeSourceRenderer) {
            this.modeSourceRenderer = modeSourceRenderer;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new BiModalSelectionRenderer(this);
        }
    }
}

