/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.analyzers;

import ghidra.app.analyzers.FunctionStartAnalyzer;
import ghidra.app.analyzers.Patterns;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.util.constraint.ProgramDecisionTree;

public class FunctionStartPreFuncAnalyzer
extends FunctionStartAnalyzer {
    protected static final String FUNCTION_START_PRE_SEARCH = "Function Start Pre Search";
    private static final String DESCRIPTION = "Search for architecture/compiler specific patterns that are better found before any code is disassembled, such as known patterns for ARM functions that handle switch tables and don't return.";
    private static ProgramDecisionTree prePatternDecisitionTree;

    private static ProgramDecisionTree initializePatternDecisionTree() {
        if (prePatternDecisitionTree == null) {
            prePatternDecisitionTree = Patterns.getPatternDecisionTree("prepatternconstraints.xml");
        }
        return prePatternDecisitionTree;
    }

    @Override
    public ProgramDecisionTree getPatternDecisionTree() {
        return FunctionStartPreFuncAnalyzer.initializePatternDecisionTree();
    }

    public FunctionStartPreFuncAnalyzer() {
        super(FUNCTION_START_PRE_SEARCH, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.BLOCK_ANALYSIS.after());
        this.setDefaultEnablement(true);
        this.setSupportsOneTimeAnalysis();
    }
}

