/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.breakpoint;

import generic.theme.GIcon;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import resources.MultiIcon;

public interface LogicalBreakpoint {
    public static final String ENABLED_BOOKMARK_TYPE = "BreakpointEnabled";
    public static final String DISABLED_BOOKMARK_TYPE = "BreakpointDisabled";
    public static final String NAME_MARKER_ENABLED = "Enabled Breakpoint";
    public static final String NAME_MARKER_DISABLED = "Disabled Breakpoint";
    public static final String NAME_MARKER_MIXED = "Mixed Breakpoint";
    public static final String NAME_MARKER_INEFF_EN = "Ineffective Enabled Breakpoint";
    public static final String NAME_MARKER_INEFF_DIS = "Ineffective Disabled Breakpoint";
    public static final String NAME_MARKER_INEFF_MIX = "Ineffective Mixed Breakpoint";
    public static final String NAME_MARKER_INCON_EN = "Inconsistent Enabled Breakpoint";
    public static final String NAME_MARKER_INCON_DIS = "Inconsistent Disabled Breakpoint";
    public static final String NAME_MARKER_INCON_MIX = "Inconsistent Mixed Breakpoint";
    public static final Icon ICON_OVERLAY_INCONSISTENT = new GIcon("icon.debugger.breakpoint.overlay.inconsistent");
    public static final Icon ICON_MARKER_ENABLED = new GIcon("icon.debugger.breakpoint.marker.enabled");
    public static final Icon ICON_MARKER_DISABLED = new GIcon("icon.debugger.breakpoint.marker.disabled");
    public static final Icon ICON_MARKER_MIXED = new GIcon("icon.debugger.breakpoint.marker.mixed");
    public static final Icon ICON_MARKER_INEFF_EN = new GIcon("icon.debugger.breakpoint.marker.ineffective.enabled");
    public static final Icon ICON_MARKER_INEFF_DIS = new GIcon("icon.debugger.breakpoint.marker.ineffective.disabled");
    public static final Icon ICON_MARKER_INEFF_MIX = new GIcon("icon.debugger.breakpoint.marker.ineffective.mixed");
    public static final Icon ICON_MARKER_INCON_EN = new MultiIcon(ICON_MARKER_ENABLED, new Icon[]{ICON_OVERLAY_INCONSISTENT});
    public static final Icon ICON_MARKER_INCON_DIS = new MultiIcon(ICON_MARKER_DISABLED, new Icon[]{ICON_OVERLAY_INCONSISTENT});
    public static final Icon ICON_MARKER_INCON_MIX = new MultiIcon(ICON_MARKER_MIXED, new Icon[]{ICON_OVERLAY_INCONSISTENT});

    public boolean isEmpty();

    public Set<TraceBreakpointKind> getKinds();

    default public Program getProgram() {
        ProgramLocation loc = this.getProgramLocation();
        return loc == null ? null : loc.getProgram();
    }

    public Bookmark getProgramBookmark();

    public String getName();

    public void setName(String var1);

    public String getEmuSleigh();

    public void setEmuSleigh(String var1);

    public ProgramLocation getProgramLocation();

    public long getLength();

    public Set<TraceBreakpoint> getTraceBreakpoints();

    public Set<TraceBreakpoint> getTraceBreakpoints(Trace var1);

    public Set<Trace> getMappedTraces();

    public Set<Trace> getParticipatingTraces();

    public Address getTraceAddress(Trace var1);

    public DomainObject getDomainObject();

    public Address getAddress();

    public State computeStateForProgram(Program var1);

    public State computeStateForTrace(Trace var1);

    public State computeStateForLocation(TraceBreakpoint var1);

    public State computeState();

    public void enableForProgram();

    public void disableForProgram();

    public void deleteForProgram();

    public CompletableFuture<Void> enableForTrace(Trace var1);

    public CompletableFuture<Void> disableForTrace(Trace var1);

    public CompletableFuture<Void> deleteForTrace(Trace var1);

    public String generateStatusEnable(Trace var1);

    public CompletableFuture<Void> enable();

    public CompletableFuture<Void> disable();

    public CompletableFuture<Void> delete();

    public static enum State {
        NONE(null, null, null, null),
        ENABLED(Mode.ENABLED, Consistency.NORMAL, "Enabled Breakpoint", ICON_MARKER_ENABLED),
        DISABLED(Mode.DISABLED, Consistency.NORMAL, "Disabled Breakpoint", ICON_MARKER_DISABLED),
        MIXED(Mode.MIXED, Consistency.NORMAL, "Mixed Breakpoint", ICON_MARKER_MIXED),
        INEFFECTIVE_ENABLED(Mode.ENABLED, Consistency.INEFFECTIVE, "Ineffective Enabled Breakpoint", ICON_MARKER_INEFF_EN),
        INEFFECTIVE_DISABLED(Mode.DISABLED, Consistency.INEFFECTIVE, "Ineffective Disabled Breakpoint", ICON_MARKER_INEFF_DIS),
        INEFFECTIVE_MIXED(Mode.MIXED, Consistency.INEFFECTIVE, "Ineffective Mixed Breakpoint", ICON_MARKER_INEFF_MIX),
        INCONSISTENT_ENABLED(Mode.ENABLED, Consistency.INCONSISTENT, "Inconsistent Enabled Breakpoint", ICON_MARKER_INCON_EN),
        INCONSISTENT_DISABLED(Mode.DISABLED, Consistency.INCONSISTENT, "Inconsistent Disabled Breakpoint", ICON_MARKER_INCON_DIS),
        INCONSISTENT_MIXED(Mode.MIXED, Consistency.INCONSISTENT, "Inconsistent Mixed Breakpoint", ICON_MARKER_INCON_MIX);

        public final Mode mode;
        public final Consistency consistency;
        public final String display;
        public final Icon icon;

        private State(Mode mode, Consistency consistency, String display, Icon icon) {
            this.mode = mode;
            this.consistency = consistency;
            this.display = display;
            this.icon = icon;
        }

        public static State fromFields(Mode mode, Consistency consistency) {
            if (mode == null && consistency == null) {
                return NONE;
            }
            switch (mode.ordinal()) {
                case 0: {
                    switch (consistency.ordinal()) {
                        case 0: {
                            return ENABLED;
                        }
                        case 1: {
                            return INEFFECTIVE_ENABLED;
                        }
                        case 2: {
                            return INCONSISTENT_ENABLED;
                        }
                    }
                }
                case 1: {
                    switch (consistency.ordinal()) {
                        case 0: {
                            return DISABLED;
                        }
                        case 1: {
                            return INEFFECTIVE_DISABLED;
                        }
                        case 2: {
                            return INCONSISTENT_DISABLED;
                        }
                    }
                }
                case 2: {
                    switch (consistency.ordinal()) {
                        case 0: {
                            return MIXED;
                        }
                        case 1: {
                            return INEFFECTIVE_MIXED;
                        }
                        case 2: {
                            return INCONSISTENT_MIXED;
                        }
                    }
                }
            }
            throw new AssertionError();
        }

        public State sameAdddress(State that) {
            if (this == NONE) {
                return that;
            }
            if (that == NONE) {
                return this;
            }
            Mode mode = this.mode.sameAddress(that.mode);
            Consistency consistency = this.consistency.sameAddress(that.consistency);
            return State.fromFields(mode, consistency);
        }

        public static State sameAddress(Collection<State> col) {
            State result = NONE;
            for (State state : col) {
                result = result.sameAdddress(state);
            }
            return result;
        }

        public State getToggled(boolean mapped) {
            if (mapped && this.isIneffective()) {
                return ENABLED;
            }
            return this.isDisabled() ? ENABLED : DISABLED;
        }

        public boolean isNormal() {
            return this.consistency == Consistency.NORMAL;
        }

        public boolean isEnabled() {
            return this.mode != Mode.DISABLED;
        }

        boolean isDisabled() {
            return this.mode != Mode.ENABLED;
        }

        public boolean isEffective() {
            return this.consistency != Consistency.INEFFECTIVE;
        }

        public boolean isIneffective() {
            return this.consistency == Consistency.INEFFECTIVE;
        }
    }

    public static enum Consistency {
        NORMAL,
        INEFFECTIVE,
        INCONSISTENT;


        public Consistency sameAddress(Consistency that) {
            return Consistency.values()[Math.max(this.ordinal(), that.ordinal())];
        }
    }

    public static enum Mode {
        ENABLED,
        DISABLED,
        MIXED;


        public Mode sameAddress(Mode that) {
            if (this == Objects.requireNonNull(that)) {
                return this;
            }
            return MIXED;
        }
    }

    public static enum TraceMode {
        NONE{

            @Override
            public TraceMode combine(TraceMode that) {
                return that;
            }
        }
        ,
        MISSING{

            @Override
            public TraceMode combine(TraceMode that) {
                return MISSING;
            }
        }
        ,
        ENABLED{

            @Override
            public TraceMode combine(TraceMode that) {
                switch (that) {
                    case NONE: 
                    case ENABLED: {
                        return ENABLED;
                    }
                    case DISABLED: 
                    case MIXED: {
                        return MIXED;
                    }
                    case MISSING: {
                        return MISSING;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        DISABLED{

            @Override
            public TraceMode combine(TraceMode that) {
                switch (that) {
                    case NONE: 
                    case DISABLED: {
                        return DISABLED;
                    }
                    case ENABLED: 
                    case MIXED: {
                        return MIXED;
                    }
                    case MISSING: {
                        return MISSING;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        MIXED{

            @Override
            public TraceMode combine(TraceMode that) {
                switch (that) {
                    case NONE: 
                    case ENABLED: 
                    case DISABLED: 
                    case MIXED: {
                        return MIXED;
                    }
                    case MISSING: {
                        return MISSING;
                    }
                }
                throw new AssertionError();
            }
        };


        public static TraceMode fromBool(boolean enabled) {
            return enabled ? ENABLED : DISABLED;
        }

        public abstract TraceMode combine(TraceMode var1);
    }

    public static enum Perspective {
        LOGICAL,
        TRACE;

    }

    public static enum ProgramMode {
        NONE{

            @Override
            public State combineTrace(TraceMode traceMode, Perspective perspective) {
                switch (traceMode) {
                    case NONE: {
                        return State.NONE;
                    }
                    case MISSING: {
                        return State.NONE;
                    }
                    case ENABLED: {
                        return State.INCONSISTENT_ENABLED;
                    }
                    case DISABLED: {
                        return State.INCONSISTENT_DISABLED;
                    }
                    case MIXED: {
                        return State.INCONSISTENT_MIXED;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        MISSING{

            @Override
            public State combineTrace(TraceMode traceMode, Perspective perspective) {
                switch (traceMode) {
                    case NONE: {
                        return State.NONE;
                    }
                    case MISSING: {
                        return State.NONE;
                    }
                    case ENABLED: {
                        return State.INCONSISTENT_ENABLED;
                    }
                    case DISABLED: {
                        return State.INCONSISTENT_DISABLED;
                    }
                    case MIXED: {
                        return State.INCONSISTENT_MIXED;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        ENABLED{

            @Override
            public State combineTrace(TraceMode traceMode, Perspective perspective) {
                switch (traceMode) {
                    case NONE: 
                    case MISSING: {
                        switch (perspective) {
                            case LOGICAL: {
                                return State.INEFFECTIVE_ENABLED;
                            }
                            case TRACE: {
                                return State.NONE;
                            }
                        }
                    }
                    case ENABLED: {
                        return State.ENABLED;
                    }
                    case DISABLED: {
                        switch (perspective) {
                            case LOGICAL: {
                                return State.INCONSISTENT_ENABLED;
                            }
                            case TRACE: {
                                return State.INCONSISTENT_DISABLED;
                            }
                        }
                    }
                    case MIXED: {
                        switch (perspective) {
                            case LOGICAL: {
                                return State.INCONSISTENT_ENABLED;
                            }
                            case TRACE: {
                                return State.INCONSISTENT_MIXED;
                            }
                        }
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        DISABLED{

            @Override
            public State combineTrace(TraceMode traceMode, Perspective perspective) {
                switch (traceMode) {
                    case NONE: 
                    case MISSING: {
                        switch (perspective) {
                            case LOGICAL: {
                                return State.INEFFECTIVE_DISABLED;
                            }
                            case TRACE: {
                                return State.NONE;
                            }
                        }
                    }
                    case ENABLED: {
                        switch (perspective) {
                            case LOGICAL: {
                                return State.INCONSISTENT_DISABLED;
                            }
                            case TRACE: {
                                return State.INCONSISTENT_ENABLED;
                            }
                        }
                    }
                    case DISABLED: {
                        return State.DISABLED;
                    }
                    case MIXED: {
                        switch (perspective) {
                            case LOGICAL: {
                                return State.INCONSISTENT_DISABLED;
                            }
                            case TRACE: {
                                return State.INCONSISTENT_MIXED;
                            }
                        }
                        return State.INCONSISTENT_MIXED;
                    }
                }
                throw new AssertionError();
            }
        };


        public abstract State combineTrace(TraceMode var1, Perspective var2);
    }
}

