/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.AbstractRenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;

public class UnresolvableConfigurationResult
extends AbstractRenderableDependency {
    private final Object id;
    private final String name;
    private final Set<? extends RenderableDependency> children;

    public static UnresolvableConfigurationResult of(Configuration configuration) {
        return new UnresolvableConfigurationResult(configuration.getClass().getName() + configuration.hashCode(), configuration.getName(), UnresolvableConfigurationResult.unresolvableChildren(configuration));
    }

    private static Set<? extends RenderableDependency> unresolvableChildren(Configuration configuration) {
        DependencySet dependencies = configuration.getDependencies();
        if (dependencies.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<UnresolvableRenderableDependency> children = new LinkedHashSet<UnresolvableRenderableDependency>();
        for (Dependency dependency : dependencies) {
            children.add(new UnresolvableRenderableDependency(dependency.getClass().getName() + dependency.hashCode(), dependency instanceof ProjectDependency ? UnresolvableConfigurationResult.projectDependencyLabel((ProjectDependency)dependency) : UnresolvableConfigurationResult.moduleDependencyLabel(dependency)));
        }
        return children;
    }

    private static String projectDependencyLabel(ProjectDependency dependency) {
        return "project " + dependency.getName();
    }

    private static String moduleDependencyLabel(Dependency dependency) {
        return Joiner.on((String)":").join((Iterable)Stream.of(dependency.getGroup(), dependency.getName(), dependency.getVersion()).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private UnresolvableConfigurationResult(Object id, String name, Set<? extends RenderableDependency> children) {
        this.id = id;
        this.name = name;
        this.children = children;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RenderableDependency.ResolutionState getResolutionState() {
        return RenderableDependency.ResolutionState.UNRESOLVED;
    }

    @Override
    public Set<? extends RenderableDependency> getChildren() {
        return this.children;
    }

    private static final class UnresolvableRenderableDependency
    extends AbstractRenderableDependency {
        private final Object id;
        private final String name;

        public UnresolvableRenderableDependency(Object id, String name) {
            this.id = id;
            this.name = name;
        }

        @Override
        public Object getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

