/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller;

import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.BrokerIdAndEpoch;

class BrokerHeartbeatTracker {
    private final Time time;
    private final long sessionTimeoutNs;
    private final ConcurrentHashMap<BrokerIdAndEpoch, Long> contactTimes;

    BrokerHeartbeatTracker(Time time, long sessionTimeoutNs) {
        this.time = time;
        this.sessionTimeoutNs = sessionTimeoutNs;
        this.contactTimes = new ConcurrentHashMap();
    }

    Time time() {
        return this.time;
    }

    void updateContactTime(BrokerIdAndEpoch idAndEpoch) {
        this.updateContactTime(idAndEpoch, this.time.nanoseconds());
    }

    void updateContactTime(BrokerIdAndEpoch idAndEpoch, long timeNs) {
        this.contactTimes.put(idAndEpoch, timeNs);
    }

    OptionalLong contactTime(BrokerIdAndEpoch idAndEpoch) {
        Long value = this.contactTimes.get(idAndEpoch);
        if (value == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(value);
    }

    Optional<BrokerIdAndEpoch> maybeRemoveExpired() {
        return this.maybeRemoveExpired(this.time.nanoseconds());
    }

    Optional<BrokerIdAndEpoch> maybeRemoveExpired(long nowNs) {
        Iterator<Map.Entry<BrokerIdAndEpoch, Long>> iterator = this.contactTimes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BrokerIdAndEpoch, Long> entry = iterator.next();
            if (!this.isExpired(entry.getValue(), nowNs)) continue;
            iterator.remove();
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    boolean isExpired(long timeNs, long nowNs) {
        return nowNs > timeNs && timeNs + this.sessionTimeoutNs < nowNs;
    }

    boolean hasValidSession(BrokerIdAndEpoch idAndEpoch) {
        Long timeNs = this.contactTimes.get(idAndEpoch);
        if (timeNs == null) {
            return false;
        }
        return !this.isExpired(timeNs, this.time.nanoseconds());
    }
}

