/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Optional;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaMetadataLog$FullTruncation$;
import kafka.raft.KafkaMetadataLog$UnknownReason$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.MetadataLogConfig;
import org.apache.kafka.raft.OffsetMetadata;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.SegmentPosition;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.NotifyingRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.MapOps;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0011Uf\u0001B<y\u0005uD!\"!\f\u0001\u0005\u000b\u0007I\u0011AA\u0018\u0011)\t\u0019\u0005\u0001B\u0001B\u0003%\u0011\u0011\u0007\u0005\u000b\u0003\u000b\u0002!\u0011!Q\u0001\n\u0005\u001d\u0003BCA+\u0001\t\u0005\t\u0015!\u0003\u0002X!Q\u0011q\r\u0001\u0003\u0002\u0003\u0006I!!\u001b\t\u0015\u0005m\u0005A!A!\u0002\u0013\ti\n\u0003\u0006\u0002&\u0002\u0011\t\u0011)A\u0005\u0003OC!\"!,\u0001\u0005\u0003\u0005\u000b\u0011BAX\u0011\u001d\t)\f\u0001C\u0005\u0003oCq!a3\u0001\t\u0003\ni\rC\u0004\u0002j\u0002!\t%a;\t\u000f\t\u001d\u0001\u0001\"\u0011\u0003\n!9!q\u0002\u0001\u0005\n\tE\u0001b\u0002B\u000e\u0001\u0011\u0005#Q\u0004\u0005\b\u0005?\u0001A\u0011\tB\u0011\u0011\u001d\u0011)\u0003\u0001C!\u0005OAq!a6\u0001\t\u0003\u0012y\u0003C\u0004\u00032\u0001!\tEa\r\t\u000f\t}\u0002\u0001\"\u0011\u0003B!9!\u0011\n\u0001\u0005B\t-\u0003b\u0002B(\u0001\u0011\u0005#\u0011\u000b\u0005\b\u0005/\u0002A\u0011\tB\u0014\u0011\u001d\u0011I\u0006\u0001C!\u00057Bq!a'\u0001\t\u0003\u0012\t\u0007C\u0004\u0003d\u0001!\tE!\u001a\t\u000f\t5\u0004\u0001\"\u0011\u0003p!9!Q\u0011\u0001\u0005B\t\u001d\u0005b\u0002BF\u0001\u0011\u0005#Q\u0012\u0005\b\u00053\u0003A\u0011\tBN\u0011\u001d\u0011i\n\u0001C!\u0005?CqAa)\u0001\t\u0003\u0012y\nC\u0004\u0003&\u0002!\tEa*\t\u000f\t-\u0006\u0001\"\u0011\u0003.\"9!1\u0016\u0001\u0005\n\tE\u0006b\u0002C9\u0001\u0011%A1\u000f\u0005\b\t\u0003\u0003A\u0011\u0002CB\u0011\u001d!I\t\u0001C!\u0005\u0003Bq\u0001b#\u0001\t\u0013!i\tC\u0004\u0005\u001c\u0002!IA!\u0011\t\u000f\u0011u\u0005\u0001\"\u0003\u0003B!9Aq\u0014\u0001\u0005\n\u0011\u0005\u0006b\u0002CT\u0001\u0011%A\u0011\u0016\u0005\b\t_\u0003A\u0011\tCY\u0011!!\u0019\f\u0001C\u0001q\nuqa\u0002Bfq\"\u0005!Q\u001a\u0004\u0007obD\tAa4\t\u000f\u0005Uf\u0006\"\u0001\u0003X\"9!\u0011\u001c\u0018\u0005\u0002\tm\u0007b\u0002B}]\u0011%!1 \u0005\b\u0005\u007ftC\u0011BB\u0001\r%\u0019YB\fI\u0001$S\u0019i\u0002C\u0004\u00038N2\taa\b\u0007\r\r\u0015cFRB$\u0011)\u0019\t'\u000eBK\u0002\u0013\u000511\r\u0005\u000b\u0007K*$\u0011#Q\u0001\n\u0005e\u0007BCB4k\tU\r\u0011\"\u0001\u0004d!Q1\u0011N\u001b\u0003\u0012\u0003\u0006I!!7\t\u0015\r-TG!f\u0001\n\u0003\u0019\u0019\u0007\u0003\u0006\u0004nU\u0012\t\u0012)A\u0005\u00033Dq!!.6\t\u0003\u0019y\u0007C\u0004\u00038V\"\te!\u001f\t\u0013\ruT'!A\u0005\u0002\r}\u0004\"CBDkE\u0005I\u0011ABE\u0011%\u0019y*NI\u0001\n\u0003\u0019I\tC\u0005\u0004\"V\n\n\u0011\"\u0001\u0004\n\"I11U\u001b\u0002\u0002\u0013\u00053Q\u0015\u0005\n\u0007W+\u0014\u0011!C\u0001\u0007[C\u0011ba,6\u0003\u0003%\ta!-\t\u0013\ruV'!A\u0005B\r}\u0006\"CBek\u0005\u0005I\u0011ABf\u0011%\u0019y-NA\u0001\n\u0003\u001a\t\u000eC\u0005\u0004VV\n\t\u0011\"\u0011\u0003\u001e!I1q[\u001b\u0002\u0002\u0013\u00053\u0011\u001c\u0005\n\u00077,\u0014\u0011!C!\u0007;<\u0011\u0002b\t/\u0003\u0003EI\u0001\"\n\u0007\u0013\r\u0015c&!A\t\n\u0011\u001d\u0002bBA[\u0019\u0012\u0005A\u0011\b\u0005\n\u0007/d\u0015\u0011!C#\u00073D\u0011B!7M\u0003\u0003%\t\tb\u000f\t\u0013\u0011\rC*!A\u0005\u0002\u0012\u0015\u0003\"\u0003C*\u0019\u0006\u0005I\u0011\u0002C+\r\u0019\u0019\tO\f$\u0004d\"Q1Q\u001d*\u0003\u0016\u0004%\taa\u0019\t\u0015\r\u001d(K!E!\u0002\u0013\tI\u000e\u0003\u0006\u0004jJ\u0013)\u001a!C\u0001\u0007GB!ba;S\u0005#\u0005\u000b\u0011BAm\u0011)\u0019iO\u0015BK\u0002\u0013\u000511\r\u0005\u000b\u0007_\u0014&\u0011#Q\u0001\n\u0005e\u0007bBA[%\u0012\u00051\u0011\u001f\u0005\b\u0005o\u0013F\u0011IB~\u0011%\u0019iHUA\u0001\n\u0003\u0019y\u0010C\u0005\u0004\bJ\u000b\n\u0011\"\u0001\u0004\n\"I1q\u0014*\u0012\u0002\u0013\u00051\u0011\u0012\u0005\n\u0007C\u0013\u0016\u0013!C\u0001\u0007\u0013C\u0011ba)S\u0003\u0003%\te!*\t\u0013\r-&+!A\u0005\u0002\r5\u0006\"CBX%\u0006\u0005I\u0011\u0001C\u0004\u0011%\u0019iLUA\u0001\n\u0003\u001ay\fC\u0005\u0004JJ\u000b\t\u0011\"\u0001\u0005\f!I1q\u001a*\u0002\u0002\u0013\u0005Cq\u0002\u0005\n\u0007+\u0014\u0016\u0011!C!\u0005;A\u0011ba6S\u0003\u0003%\te!7\t\u0013\rm'+!A\u0005B\u0011Mq!\u0003C,]\u0005\u0005\t\u0012\u0002C-\r%\u0019\tOLA\u0001\u0012\u0013!Y\u0006C\u0004\u00026&$\t\u0001b\u0018\t\u0013\r]\u0017.!A\u0005F\re\u0007\"\u0003BmS\u0006\u0005I\u0011\u0011C1\u0011%!\u0019%[A\u0001\n\u0003#I\u0007C\u0005\u0005T%\f\t\u0011\"\u0003\u0005V\u001d9AQ\u000e\u0018\t\u000e\r}baBB\u001b]!51q\u0007\u0005\b\u0003k\u0003H\u0011AB\u001f\u0011\u001d\u00119\f\u001dC!\u0007\u0003:q\u0001b\u001c/\u0011\u001b!iBB\u0004\u0005\u00189Bi\u0001\"\u0007\t\u000f\u0005UF\u000f\"\u0001\u0005\u001c!9!q\u0017;\u0005B\u0011}!\u0001E&bM.\fW*\u001a;bI\u0006$\u0018\rT8h\u0015\tI(0\u0001\u0003sC\u001a$(\"A>\u0002\u000b-\fgm[1\u0004\u0001M1\u0001A`A\u0007\u0003C\u00012a`A\u0005\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001\u00027b]\u001eT!!a\u0002\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\t\tA\u0001\u0004PE*,7\r\u001e\t\u0005\u0003\u001f\ti\"\u0004\u0002\u0002\u0012)\u0019\u00110a\u0005\u000b\u0007m\f)B\u0003\u0003\u0002\u0018\u0005e\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u001c\u0005\u0019qN]4\n\t\u0005}\u0011\u0011\u0003\u0002\u000e%\u0016\u0004H.[2bi\u0016$Gj\\4\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\n{\u0003\u0015)H/\u001b7t\u0013\u0011\tY#!\n\u0003\u000f1{wmZ5oO\u0006\u0019An\\4\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003\u007fi!!!\u000e\u000b\t\u00055\u0012q\u0007\u0006\u0005\u0003s\tY$A\u0005j]R,'O\\1mg*!\u0011QHA\n\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!\u0011\u00026\tQQK\\5gS\u0016$Gj\\4\u0002\t1|w\rI\u0001\u0005i&lW\r\u0005\u0003\u0002J\u0005ESBAA&\u0015\u0011\t9#!\u0014\u000b\t\u0005=\u00131C\u0001\u0007G>lWn\u001c8\n\t\u0005M\u00131\n\u0002\u0005)&lW-A\u0005tG\",G-\u001e7feB!\u0011\u0011LA2\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013\u0001B;uS2TA!!\u0019\u0002\u0014\u000511/\u001a:wKJLA!!\u001a\u0002\\\tI1k\u00195fIVdWM]\u0001\ng:\f\u0007o\u001d5piN\u0004\u0002\"a\u001b\u0002z\u0005u\u0014qQ\u0007\u0003\u0003[RA!a\u001c\u0002r\u00059Q.\u001e;bE2,'\u0002BA:\u0003k\n!bY8mY\u0016\u001cG/[8o\u0015\t\t9(A\u0003tG\u0006d\u0017-\u0003\u0003\u0002|\u00055$a\u0002+sK\u0016l\u0015\r\u001d\t\u0005\u0003\u007f\n\u0019)\u0004\u0002\u0002\u0002*!\u0011qJA0\u0013\u0011\t))!!\u0003\u001d=3gm]3u\u0003:$W\t]8dQB1\u0011\u0011RAF\u0003\u001fk!!!\u001e\n\t\u00055\u0015Q\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'SA!!&\u0002\u0014\u0005A1O\\1qg\"|G/\u0003\u0003\u0002\u001a\u0006M%!\u0006$jY\u0016\u0014\u0016m^*oCB\u001c\bn\u001c;SK\u0006$WM]\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\ty*!)\u000e\u0005\u00055\u0013\u0002BAR\u0003\u001b\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0004d_:4\u0017n\u001a\t\u0005\u0003\u001f\tI+\u0003\u0003\u0002,\u0006E!!E'fi\u0006$\u0017\r^1M_\u001e\u001cuN\u001c4jO\u00061an\u001c3f\u0013\u0012\u0004B!!#\u00022&!\u00111WA;\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005e\u0016QXA`\u0003\u0003\f\u0019-!2\u0002H\u0006%\u0007cAA^\u00015\t\u0001\u0010C\u0004\u0002.%\u0001\r!!\r\t\u000f\u0005\u0015\u0013\u00021\u0001\u0002H!9\u0011QK\u0005A\u0002\u0005]\u0003bBA4\u0013\u0001\u0007\u0011\u0011\u000e\u0005\b\u00037K\u0001\u0019AAO\u0011\u001d\t)+\u0003a\u0001\u0003OCq!!,\n\u0001\u0004\ty+\u0001\u0003sK\u0006$GCBAh\u0003+\fy\u000e\u0005\u0003\u0002\u0010\u0005E\u0017\u0002BAj\u0003#\u0011A\u0002T8h\r\u0016$8\r[%oM>Dq!a6\u000b\u0001\u0004\tI.A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\b\u0003BAE\u00037LA!!8\u0002v\t!Aj\u001c8h\u0011\u001d\t\tO\u0003a\u0001\u0003G\fQB]3bI&\u001bx\u000e\\1uS>t\u0007\u0003BA\b\u0003KLA!a:\u0002\u0012\tI\u0011j]8mCRLwN\\\u0001\u000fCB\u0004XM\u001c3Bg2+\u0017\rZ3s)\u0019\ti/a=\u0003\u0004A!\u0011qBAx\u0013\u0011\t\t0!\u0005\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u001d\t)p\u0003a\u0001\u0003o\fqA]3d_J$7\u000f\u0005\u0003\u0002z\u0006}XBAA~\u0015\u0011\ti0!\u0014\u0002\rI,7m\u001c:e\u0013\u0011\u0011\t!a?\u0003\u000fI+7m\u001c:eg\"9!QA\u0006A\u0002\u0005=\u0016!B3q_\u000eD\u0017\u0001E1qa\u0016tG-Q:G_2dwn^3s)\u0019\tiOa\u0003\u0003\u000e!9\u0011Q\u001f\u0007A\u0002\u0005]\bb\u0002B\u0003\u0019\u0001\u0007\u0011qV\u0001\u001eQ\u0006tG\r\\3B]\u0012\u001cuN\u001c<feRdunZ!qa\u0016tG-\u00138g_R!\u0011Q\u001eB\n\u0011\u001d\u0011)\"\u0004a\u0001\u0005/\t!\"\u00199qK:$\u0017J\u001c4p!\u0011\t\u0019D!\u0007\n\t\u0005E\u0018QG\u0001\u0011Y\u0006\u001cHOR3uG\",G-\u00129pG\"$\"!a,\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0003\u0002~\t\r\u0002b\u0002B\u0003\u001f\u0001\u0007\u0011qV\u0001\nK:$wJ\u001a4tKR$\"A!\u000b\u0011\t\u0005=!1F\u0005\u0005\u0005[\t\tBA\tM_\u001e|eMZ:fi6+G/\u00193bi\u0006$\"!!7\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000e\u0006\u0003\u00036\tm\u0002\u0003BAE\u0005oIAA!\u000f\u0002v\t!QK\\5u\u0011\u001d\u0011iD\u0005a\u0001\u00033\faa\u001c4gg\u0016$\u0018\u0001\u0007;sk:\u001c\u0017\r^3U_2\u000bG/Z:u':\f\u0007o\u001d5piR\u0011!1\t\t\u0005\u0003\u0013\u0013)%\u0003\u0003\u0003H\u0005U$a\u0002\"p_2,\u0017M\\\u0001\u0016S:LG/[1mSj,G*Z1eKJ,\u0005o\\2i)\u0011\u0011)D!\u0014\t\u000f\t\u0015A\u00031\u0001\u00020\u0006\u0019R\u000f\u001d3bi\u0016D\u0015n\u001a5XCR,'/\\1sWR!!Q\u0007B*\u0011\u001d\u0011)&\u0006a\u0001\u0005S\tab\u001c4gg\u0016$X*\u001a;bI\u0006$\u0018-A\u0007iS\u001eDw+\u0019;fe6\f'o[\u0001\u0006M2,8\u000f\u001b\u000b\u0005\u0005k\u0011i\u0006C\u0004\u0003`]\u0001\rAa\u0011\u0002/\u0019|'oY3GYV\u001c\b.Q2uSZ,7+Z4nK:$HCAAO\u0003\u001d!x\u000e]5d\u0013\u0012$\"Aa\u001a\u0011\t\u0005}%\u0011N\u0005\u0005\u0005W\niE\u0001\u0003Vk&$\u0017!E2sK\u0006$XMT3x':\f\u0007o\u001d5piR!!\u0011\u000fBA!\u0019\u0011\u0019Ha\u001e\u0003|5\u0011!Q\u000f\u0006\u0005\u0003;\n)!\u0003\u0003\u0003z\tU$\u0001C(qi&|g.\u00197\u0011\t\u0005E%QP\u0005\u0005\u0005\u007f\n\u0019JA\tSC^\u001cf.\u00199tQ>$xK]5uKJDqAa!\u001b\u0001\u0004\ti(\u0001\u0006t]\u0006\u00048\u000f[8u\u0013\u0012\f!d\u0019:fCR,g*Z<T]\u0006\u00048\u000f[8u+:\u001c\u0007.Z2lK\u0012$BA!\u001d\u0003\n\"9!1Q\u000eA\u0002\u0005u\u0014\u0001\u0004:fC\u0012\u001cf.\u00199tQ>$H\u0003\u0002BH\u0005/\u0003bAa\u001d\u0003x\tE\u0005\u0003BAI\u0005'KAA!&\u0002\u0014\n\t\"+Y<T]\u0006\u00048\u000f[8u%\u0016\fG-\u001a:\t\u000f\t\rE\u00041\u0001\u0002~\u0005qA.\u0019;fgR\u001cf.\u00199tQ>$HC\u0001BH\u0003Aa\u0017\r^3tiNs\u0017\r]:i_RLE\r\u0006\u0002\u0003\"B1!1\u000fB<\u0003{\n!#Z1sY&,7\u000f^*oCB\u001c\bn\u001c;JI\u0006\u0001rN\\*oCB\u001c\bn\u001c;Ge>TXM\u001c\u000b\u0005\u0005k\u0011I\u000bC\u0004\u0003\u0004\u0002\u0002\r!! \u0002)\u0011,G.\u001a;f\u0005\u00164wN]3T]\u0006\u00048\u000f[8u)\u0011\u0011\u0019Ea,\t\u000f\t\r\u0015\u00051\u0001\u0002~Q1!1\tBZ\u0005kCqAa!#\u0001\u0004\ti\bC\u0004\u00038\n\u0002\rA!/\u0002\rI,\u0017m]8o!\r\u0011Yl\r\b\u0004\u0005{kc\u0002\u0002B`\u0005\u0013tAA!1\u0003H6\u0011!1\u0019\u0006\u0004\u0005\u000bd\u0018A\u0002\u001fs_>$h(C\u0001|\u0013\tI(0\u0001\tLC\u001a\\\u0017-T3uC\u0012\fG/\u0019'pOB\u0019\u00111\u0018\u0018\u0014\u000b9\u0012\t.!\t\u0011\t\u0005%%1[\u0005\u0005\u0005+\f)H\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005\u001b\fQ!\u00199qYf$\u0002#!/\u0003^\n}'\u0011\u001dBy\u0005g\u0014)Pa>\t\u000f\u0005m\u0005\u00071\u0001\u0002\u001e\"9!1\r\u0019A\u0002\t\u001d\u0004b\u0002Bra\u0001\u0007!Q]\u0001\bI\u0006$\u0018\rR5s!\u0011\u00119O!<\u000e\u0005\t%(\u0002\u0002Bv\u0003\u000b\t!![8\n\t\t=(\u0011\u001e\u0002\u0005\r&dW\rC\u0004\u0002FA\u0002\r!a\u0012\t\u000f\u0005U\u0003\u00071\u0001\u0002X!9\u0011Q\u0015\u0019A\u0002\u0005\u001d\u0006bBAWa\u0001\u0007\u0011qV\u0001\u0011e\u0016\u001cwN^3s':\f\u0007o\u001d5piN$B!!\u001b\u0003~\"9\u0011QF\u0019A\u0002\u0005E\u0012a\u00053fY\u0016$Xm\u00158baNDw\u000e\u001e$jY\u0016\u001cHC\u0002B\u001b\u0007\u0007\u00199\u0002C\u0004\u0004\u0006I\u0002\raa\u0002\u0002\r1|w\rR5s!\u0011\u0019Iaa\u0005\u000e\u0005\r-!\u0002BB\u0007\u0007\u001f\tAAZ5mK*!1\u0011CA\u0003\u0003\rq\u0017n\\\u0005\u0005\u0007+\u0019YA\u0001\u0003QCRD\u0007bBB\re\u0001\u0007\u0011\u0011N\u0001\u0011Kb\u0004\u0018N]3e':\f\u0007o\u001d5piN\u0014ac\u00158baNDw\u000e\u001e#fY\u0016$\u0018n\u001c8SK\u0006\u001cxN\\\n\u0004g\tEG\u0003BB\u0011\u0007c\u0001Baa\t\u0004,9!1QEB\u0014!\u0011\u0011\t-!\u001e\n\t\r%\u0012QO\u0001\u0007!J,G-\u001a4\n\t\r52q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\t\r%\u0012Q\u000f\u0005\b\u0005\u0007#\u0004\u0019AA?S\u0015\u0019\u0004/\u000e*u\u000591U\u000f\u001c7UeVt7-\u0019;j_:\u001cR\u0001\u001dBi\u0007s\u00012aa\u000f4\u001b\u0005qCCAB !\r\u0019Y\u0004\u001d\u000b\u0005\u0007C\u0019\u0019\u0005C\u0004\u0003\u0004J\u0004\r!! \u0003#I+G/\u001a8uS>tWj\u001d\"sK\u0006\u001c\u0007nE\u00056\u0005#\u001cId!\u0013\u0004PA!\u0011\u0011RB&\u0013\u0011\u0019i%!\u001e\u0003\u000fA\u0013x\u000eZ;diB!1\u0011KB.\u001d\u0011\u0019\u0019fa\u0016\u000f\t\t\u00057QK\u0005\u0003\u0003oJAa!\u0017\u0002v\u00059\u0001/Y2lC\u001e,\u0017\u0002BB/\u0007?\u0012AbU3sS\u0006d\u0017N_1cY\u0016TAa!\u0017\u0002v\u0005\u0019an\\<\u0016\u0005\u0005e\u0017\u0001\u00028po\u0002\n\u0011\u0002^5nKN$\u0018-\u001c9\u0002\u0015QLW.Z:uC6\u0004\b%A\bsKR,g\u000e^5p]6KG\u000e\\5t\u0003A\u0011X\r^3oi&|g.T5mY&\u001c\b\u0005\u0006\u0005\u0004r\rM4QOB<!\r\u0019Y$\u000e\u0005\b\u0007Cb\u0004\u0019AAm\u0011\u001d\u00199\u0007\u0010a\u0001\u00033Dqaa\u001b=\u0001\u0004\tI\u000e\u0006\u0003\u0004\"\rm\u0004b\u0002BB{\u0001\u0007\u0011QP\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0004r\r\u000551QBC\u0011%\u0019\tG\u0010I\u0001\u0002\u0004\tI\u000eC\u0005\u0004hy\u0002\n\u00111\u0001\u0002Z\"I11\u000e \u0011\u0002\u0003\u0007\u0011\u0011\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019YI\u000b\u0003\u0002Z\u000e55FABH!\u0011\u0019\tja'\u000e\u0005\rM%\u0002BBK\u0007/\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\re\u0015QO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BBO\u0007'\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0007O\u00032a`BU\u0013\u0011\u0019i#!\u0001\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005=\u0016A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0007g\u001bI\f\u0005\u0003\u0002\n\u000eU\u0016\u0002BB\\\u0003k\u00121!\u00118z\u0011%\u0019Y\fRA\u0001\u0002\u0004\ty+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0007\u0003\u0004baa1\u0004F\u000eMVBAA9\u0013\u0011\u00199-!\u001d\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u0007\u001ai\rC\u0005\u0004<\u001a\u000b\t\u00111\u0001\u00044\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u00199ka5\t\u0013\rmv)!AA\u0002\u0005=\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"aa*\u0002\r\u0015\fX/\u00197t)\u0011\u0011\u0019ea8\t\u0013\rm&*!AA\u0002\rM&a\u0005*fi\u0016tG/[8o'&TXM\u0011:fC\u000eD7#\u0003*\u0003R\u000ee2\u0011JB(\u0003\u001dawnZ*ju\u0016\f\u0001\u0002\\8h'&TX\rI\u0001\u000eg:\f\u0007o\u001d5piN\u001c\u0016N_3\u0002\u001dMt\u0017\r]:i_R\u001c8+\u001b>fA\u0005\t\"/\u001a;f]RLwN\\'bq\nKH/Z:\u0002%I,G/\u001a8uS>tW*\u0019=CsR,7\u000f\t\u000b\t\u0007g\u001c)pa>\u0004zB\u001911\b*\t\u000f\r\u0015\u0018\f1\u0001\u0002Z\"91\u0011^-A\u0002\u0005e\u0007bBBw3\u0002\u0007\u0011\u0011\u001c\u000b\u0005\u0007C\u0019i\u0010C\u0004\u0003\u0004j\u0003\r!! \u0015\u0011\rMH\u0011\u0001C\u0002\t\u000bA\u0011b!:\\!\u0003\u0005\r!!7\t\u0013\r%8\f%AA\u0002\u0005e\u0007\"CBw7B\u0005\t\u0019AAm)\u0011\u0019\u0019\f\"\u0003\t\u0013\rm\u0016-!AA\u0002\u0005=F\u0003\u0002B\"\t\u001bA\u0011ba/d\u0003\u0003\u0005\raa-\u0015\t\r\u001dF\u0011\u0003\u0005\n\u0007w#\u0017\u0011!a\u0001\u0003_#BAa\u0011\u0005\u0016!I11X4\u0002\u0002\u0003\u000711\u0017\u0002\u000e+:\\gn\\<o%\u0016\f7o\u001c8\u0014\u000bQ\u0014\tn!\u000f\u0015\u0005\u0011u\u0001cAB\u001eiR!1\u0011\u0005C\u0011\u0011\u001d\u0011\u0019I\u001ea\u0001\u0003{\n\u0011CU3uK:$\u0018n\u001c8Ng\n\u0013X-Y2i!\r\u0019Y\u0004T\n\u0006\u0019\u0012%BQ\u0007\t\r\tW!\t$!7\u0002Z\u0006e7\u0011O\u0007\u0003\t[QA\u0001b\f\u0002v\u00059!/\u001e8uS6,\u0017\u0002\u0002C\u001a\t[\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\u00119\u000fb\u000e\n\t\ru#\u0011\u001e\u000b\u0003\tK!\u0002b!\u001d\u0005>\u0011}B\u0011\t\u0005\b\u0007Cz\u0005\u0019AAm\u0011\u001d\u00199g\u0014a\u0001\u00033Dqaa\u001bP\u0001\u0004\tI.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0011\u001dCq\n\t\u0007\u0003\u0013\u000bY\t\"\u0013\u0011\u0015\u0005%E1JAm\u00033\fI.\u0003\u0003\u0005N\u0005U$A\u0002+va2,7\u0007C\u0005\u0005RA\u000b\t\u00111\u0001\u0004r\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0003y\f1CU3uK:$\u0018n\u001c8TSj,'I]3bG\"\u00042aa\u000fj'\u0015IGQ\fC\u001b!1!Y\u0003\"\r\u0002Z\u0006e\u0017\u0011\\Bz)\t!I\u0006\u0006\u0005\u0004t\u0012\rDQ\rC4\u0011\u001d\u0019)\u000f\u001ca\u0001\u00033Dqa!;m\u0001\u0004\tI\u000eC\u0004\u0004n2\u0004\r!!7\u0015\t\u0011\u001dC1\u000e\u0005\n\t#j\u0017\u0011!a\u0001\u0007g\faBR;mYR\u0013XO\\2bi&|g.A\u0007V].twn\u001e8SK\u0006\u001cxN\\\u0001\u0012Y>\fGm\u00158baNDw\u000e^*ju\u0016\u001cHC\u0001C;!\u0019\u0019\t\u0006b\u001e\u0005|%!A\u0011PB0\u0005\r\u0019V-\u001d\t\t\u0003\u0013#i(! \u0002Z&!AqPA;\u0005\u0019!V\u000f\u001d7fe\u0005)\"/Z1e':\f\u0007o\u001d5piRKW.Z:uC6\u0004H\u0003\u0002CC\t\u000f\u0003b!!#\u0002\f\u0006e\u0007b\u0002BBI\u0001\u0007\u0011QP\u0001\u000b[\u0006L(-Z\"mK\u0006t\u0017AD2mK\u0006t7K\\1qg\"|Go\u001d\u000b\u0005\u0005\u0007\"y\tC\u0004\u0005\u0012\u001a\u0002\r\u0001b%\u0002\u0013A\u0014X\rZ5dCR,\u0007\u0003CAE\t+\u000bi\b\"'\n\t\u0011]\u0015Q\u000f\u0002\n\rVt7\r^5p]F\u0002b!!#\u0002\f\ne\u0016!G2mK\u0006t7K\\1qg\"|Go\u001d*fi\u0016tG/[8o\u001bN\f1d\u00197fC:\u001cf.\u00199tQ>$8OU3uK:$\u0018n\u001c8TSj,\u0017!\u00064pe\u001e,Go\u00158baNDw\u000e^:CK\u001a|'/\u001a\u000b\u0005\u0003S\"\u0019\u000bC\u0004\u0005&&\u0002\r!! \u0002%1|wm\u0015;beR\u001cf.\u00199tQ>$\u0018\nZ\u0001\u0010e\u0016lwN^3T]\u0006\u00048\u000f[8ugR1!Q\u0007CV\t[Cqa!\u0007+\u0001\u0004\tI\u0007C\u0004\u00038*\u0002\rA!/\u0002\u000b\rdwn]3\u0015\u0005\tU\u0012!D:oCB\u001c\bn\u001c;D_VtG\u000f")
public final class KafkaMetadataLog
implements ReplicatedLog,
Logging {
    private final UnifiedLog log;
    private final Time time;
    private final Scheduler scheduler;
    private final TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots;
    private final TopicPartition topicPartition;
    private final MetadataLogConfig config;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaMetadataLog apply(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Scheduler scheduler, MetadataLogConfig config, int nodeId) {
        return KafkaMetadataLog$.MODULE$.apply(topicPartition, topicId, dataDir, time, scheduler, config, nodeId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ValidOffsetAndEpoch validateOffsetAndEpoch(long x$1, int x$2) {
        return super.validateOffsetAndEpoch(x$1, x$2);
    }

    public long truncateToEndOffset(OffsetAndEpoch x$1) {
        return super.truncateToEndOffset(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public LogFetchInfo read(long startOffset, Isolation readIsolation) {
        FetchIsolation fetchIsolation;
        if (Isolation.COMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.HIGH_WATERMARK;
        } else if (Isolation.UNCOMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.LOG_END;
        } else {
            throw new IllegalArgumentException("Unhandled read isolation " + readIsolation);
        }
        FetchIsolation isolation = fetchIsolation;
        FetchDataInfo fetchInfo = this.log().read(startOffset, this.config.internalMaxFetchSizeInBytes(), isolation, true);
        return new LogFetchInfo(fetchInfo.records, new LogOffsetMetadata(fetchInfo.fetchOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(fetchInfo.fetchOffsetMetadata.segmentBaseOffset, fetchInfo.fetchOffsetMetadata.relativePositionInSegment))));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsLeader(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log().appendAsLeader((MemoryRecords)records, epoch, AppendOrigin.RAFT_LEADER));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsFollower(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log().appendAsFollower((MemoryRecords)records, epoch));
    }

    private org.apache.kafka.raft.LogAppendInfo handleAndConvertLogAppendInfo(LogAppendInfo appendInfo) {
        if (appendInfo.firstOffset() == -1L) {
            throw new CorruptRecordException("Append failed unexpectedly " + appendInfo);
        }
        return new org.apache.kafka.raft.LogAppendInfo(appendInfo.firstOffset(), appendInfo.lastOffset());
    }

    public int lastFetchedEpoch() {
        Optional latestEpoch = this.log().latestEpoch();
        if (latestEpoch.isPresent()) {
            return Predef$.MODULE$.Integer2int((Integer)latestEpoch.get());
        }
        return BoxesRunTime.unboxToInt((Object)this.latestSnapshotId().map(snapshotId -> BoxesRunTime.boxToInteger((int)KafkaMetadataLog.$anonfun$lastFetchedEpoch$1(this, snapshotId))).orElse(BoxesRunTime.boxToInteger((int)0)));
    }

    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.earliestSnapshotId()));
        Option option2 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.log().endOffsetForEpoch(epoch)));
        Tuple2 tuple2 = new Tuple2((Object)option2, (Object)option);
        if (option2 instanceof Some) {
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)((Some)option2).value();
            if (option instanceof Some) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
                if (offsetAndEpoch.offset() == snapshotId.offset() && offsetAndEpoch.epoch() == epoch) {
                    return new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
                }
            }
        }
        if (option2 instanceof Some) {
            OffsetAndEpoch offsetAndEpoch = (OffsetAndEpoch)((Some)option2).value();
            return new OffsetAndEpoch(offsetAndEpoch.offset(), offsetAndEpoch.epoch());
        }
        if (None$.MODULE$.equals(option2)) {
            return new OffsetAndEpoch(this.endOffset().offset(), this.lastFetchedEpoch());
        }
        throw new MatchError((Object)tuple2);
    }

    public LogOffsetMetadata endOffset() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata endOffsetMetadata = this.log().logEndOffsetMetadata();
        return new LogOffsetMetadata(endOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(endOffsetMetadata.segmentBaseOffset, endOffsetMetadata.relativePositionInSegment)));
    }

    public long startOffset() {
        return this.log().logStartOffset();
    }

    public void truncateTo(long offset) {
        if (offset < this.highWatermark().offset()) {
            throw new IllegalArgumentException("Attempt to truncate to offset " + offset + ", which is below the current high watermark " + this.highWatermark().offset());
        }
        this.log().truncateTo(offset);
    }

    /*
     * WARNING - void declaration
     */
    public boolean truncateToLatestSnapshot() {
        void var5_8;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap;
        boolean bl;
        OffsetAndEpoch snapshotId;
        Integer latestEpoch = this.log().latestEpoch().orElse(Predef$.MODULE$.int2Integer(0));
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.latestSnapshotId()));
        if (option instanceof Some && ((snapshotId = (OffsetAndEpoch)((Some)option).value()).epoch() > Predef$.MODULE$.Integer2int(latestEpoch) || BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)snapshotId.epoch()), (Object)latestEpoch) && snapshotId.offset() > this.endOffset().offset())) {
            this.log().truncateFullyAndStartAt(snapshotId.offset(), Optional.empty());
            TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap2 = this.snapshots;
            synchronized (treeMap2) {
                TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap3 = this.forgetSnapshotsBefore(snapshotId);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                bl = bl2;
                treeMap = treeMap3;
            }
        } else {
            bl = false;
            treeMap = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        }
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap4 = treeMap;
        boolean truncated = bl;
        this.removeSnapshots(treeMap4, KafkaMetadataLog$FullTruncation$.MODULE$);
        return (boolean)var5_8;
    }

    public void initializeLeaderEpoch(int epoch) {
        this.log().assignEpochStartOffset(epoch, this.log().logEndOffset());
    }

    public void updateHighWatermark(LogOffsetMetadata offsetMetadata) {
        long logHighWatermark;
        OffsetMetadata segmentPosition;
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(offsetMetadata.metadata()));
        if (option instanceof Some && (segmentPosition = (OffsetMetadata)((Some)option).value()) instanceof SegmentPosition) {
            SegmentPosition segmentPosition2 = (SegmentPosition)segmentPosition;
            v0 = this.log().updateHighWatermark(new org.apache.kafka.storage.internals.log.LogOffsetMetadata(offsetMetadata.offset(), segmentPosition2.baseOffset(), segmentPosition2.relativePosition()));
        } else {
            v0 = logHighWatermark = this.log().updateHighWatermark(offsetMetadata.offset());
        }
        if (logHighWatermark != offsetMetadata.offset()) {
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$updateHighWatermark$1(logHighWatermark, offsetMetadata);
                Object var7_6 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                return;
            }
            return;
        }
    }

    public LogOffsetMetadata highWatermark() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata hwm = this.log().fetchOffsetSnapshot().highWatermark;
        Optional segmentPosition = !hwm.messageOffsetOnly() ? Optional.of(new SegmentPosition(hwm.segmentBaseOffset, hwm.relativePositionInSegment)) : Optional.empty();
        return new LogOffsetMetadata(hwm.messageOffset, segmentPosition);
    }

    public void flush(boolean forceFlushActiveSegment) {
        this.log().flush(forceFlushActiveSegment);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Uuid topicId() {
        return (Uuid)this.log().topicId().get();
    }

    public Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch snapshotId) {
        if (snapshotId.offset() < this.startOffset()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$createNewSnapshot$1(this, snapshotId);
                Object var8_2 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return Optional.empty();
        }
        long highWatermarkOffset = this.highWatermark().offset();
        if (snapshotId.offset() > highWatermarkOffset) {
            throw new IllegalArgumentException("Cannot create a snapshot with an id (" + snapshotId + ") greater than the high-watermark (" + highWatermarkOffset + ")");
        }
        ValidOffsetAndEpoch validOffsetAndEpoch = this.validateOffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
        ValidOffsetAndEpoch.Kind kind = validOffsetAndEpoch.kind();
        ValidOffsetAndEpoch.Kind kind2 = ValidOffsetAndEpoch.Kind.VALID;
        if (kind == null ? kind2 != null : !kind.equals(kind2)) {
            throw new IllegalArgumentException("Snapshot id (" + snapshotId + ") is not valid according to the log: " + validOffsetAndEpoch);
        }
        long baseOffset = this.read((long)snapshotId.offset(), (Isolation)Isolation.COMMITTED).startOffsetMetadata.offset();
        if (snapshotId.offset() != baseOffset) {
            throw new IllegalArgumentException("Cannot create snapshot at offset (" + snapshotId.offset() + ") because it is not batch aligned. The batch containing the requested offset has a base offset of (" + baseOffset + ")");
        }
        return this.createNewSnapshotUnchecked(snapshotId);
    }

    public Optional<RawSnapshotWriter> createNewSnapshotUnchecked(OffsetAndEpoch snapshotId2) {
        boolean bl;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            bl = this.snapshots.contains((Object)snapshotId2);
        }
        if (bl) {
            return Optional.empty();
        }
        return Optional.of(new NotifyingRawSnapshotWriter((RawSnapshotWriter)FileRawSnapshotWriter.create((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId2), snapshotId -> this.onSnapshotFrozen((OffsetAndEpoch)snapshotId)));
    }

    /*
     * Unable to fully structure code
     */
    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            block8: {
                block7: {
                    var5_3 = false;
                    var6_4 = null;
                    var7_5 = this.snapshots.get((Object)snapshotId);
                    if (!None$.MODULE$.equals(var7_5)) break block7;
                    v0 = None$.MODULE$;
                    break block8;
                }
                if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
                var5_3 = true;
                var6_4 = (Some)var7_5;
                var8_6 = (Option)var6_4.value();
                if (None$.MODULE$.equals(var8_6)) {
                    v0 = this.liftedTree1$1(snapshotId);
                } else if (var5_3) {
                    v0 = (Option)var6_4.value();
                } else {
                    throw new MatchError((Object)var7_5);
                }
            }
            reader = v0;
            var3_8 = OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption((Option)reader));
            return var3_8;
        }
    }

    public Optional<RawSnapshotReader> latestSnapshot() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional<RawSnapshotReader> optional = this.latestSnapshotId().flatMap(snapshotId -> this.readSnapshot((OffsetAndEpoch)snapshotId));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> latestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(this.snapshots.lastOption().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> earliestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(this.snapshots.headOption().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            this.snapshots.put((Object)snapshotId, (Object)None$.MODULE$);
            return;
        }
    }

    public boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId) {
        return this.deleteBeforeSnapshot(snapshotId, KafkaMetadataLog$UnknownReason$.MODULE$);
    }

    /*
     * Unable to fully structure code
     */
    private boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId, SnapshotDeletionReason reason) {
        var3_3 = this.snapshots;
        synchronized (var3_3) {
            var4_4 = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.latestSnapshotId()));
            if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
            latestSnapshotId = (OffsetAndEpoch)((Some)var4_4).value();
            if (this.snapshots.contains((Object)snapshotId) && this.startOffset() < snapshotId.offset() && snapshotId.offset() <= latestSnapshotId.offset() && this.log().maybeIncrementLogStartOffset(snapshotId.offset(), LogStartOffsetIncrementReason.SnapshotGenerated)) {
                deletedSegments = this.log().deleteOldSegments();
                forgottenSnapshots = this.forgetSnapshotsBefore(snapshotId);
                v0 = deletedSegments != 0 || forgottenSnapshots.nonEmpty() != false;
                v1 = forgottenSnapshots;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
                v1 = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            }
            var9_8 = v1;
            var8_9 = v0;
        }
        this.removeSnapshots(var9_8, reason);
        return var8_9;
    }

    private Seq<Tuple2<OffsetAndEpoch, Object>> loadSnapshotSizes() {
        return (Seq)this.snapshots.keys().toSeq().flatMap((Function1 & Serializable)snapshotId -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.readSnapshot((OffsetAndEpoch)snapshotId))).map((Function1 & Serializable)reader -> new Tuple2(snapshotId, (Object)BoxesRunTime.boxToLong((long)reader.sizeInBytes()))));
    }

    private Option<Object> readSnapshotTimestamp(OffsetAndEpoch snapshotId) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.readSnapshot(snapshotId))).map((Function1 & Serializable)reader -> BoxesRunTime.boxToLong((long)KafkaMetadataLog.$anonfun$readSnapshotTimestamp$1(this, reader)));
    }

    public boolean maybeClean() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            boolean didClean = false;
            boolean bl = (didClean |= this.cleanSnapshotsRetentionSize()) | this.cleanSnapshotsRetentionMs();
            return bl;
        }
    }

    private boolean cleanSnapshots(Function1<OffsetAndEpoch, Option<SnapshotDeletionReason>> predicate) {
        Object object = new Object();
        try {
            if (this.snapshots.size() < 2) {
                return false;
            }
            BooleanRef didClean = BooleanRef.create((boolean)false);
            this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                SeqOps seqOps;
                if (x0$1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1))) {
                    new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                    if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                        OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                        OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                        if (snapshot != null && nextSnapshot != null) {
                            Option option = (Option)predicate.apply((Object)snapshot);
                            if (option instanceof Some) {
                                SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                                if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                }
                            } else {
                                if (None$.MODULE$.equals(option)) {
                                    throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                }
                                throw new MatchError((Object)option);
                            }
                            didClean$1.elem = true;
                            return BoxedUnit.UNIT;
                        }
                    }
                }
                return BoxesRunTime.boxToBoolean((boolean)false);
            });
            return didClean.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private boolean cleanSnapshotsRetentionMs() {
        boolean bl;
        if (this.config.retentionMillis() < 0L) {
            return false;
        }
        Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> this.shouldClean$1((OffsetAndEpoch)snapshotId);
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                    SeqOps seqOps;
                    if (x0$1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1))) {
                        new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                            OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                            OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                            if (snapshot != null && nextSnapshot != null) {
                                Option option = (Option)predicate.apply((Object)snapshot);
                                if (option instanceof Some) {
                                    SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                                    if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                        throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                    }
                                } else {
                                    if (None$.MODULE$.equals(option)) {
                                        throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                    }
                                    throw new MatchError((Object)option);
                                }
                                didClean$1.elem = true;
                                return BoxedUnit.UNIT;
                            }
                        }
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                });
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private boolean cleanSnapshotsRetentionSize() {
        boolean bl;
        if (this.config.retentionMaxBytes() < 0L) {
            return false;
        }
        Map snapshotSizes = this.loadSnapshotSizes().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        LongRef snapshotTotalSize = LongRef.create((long)BoxesRunTime.unboxToLong((Object)snapshotSizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Function1 & Serializable cleanSnapshots_predicate = (Function1 & Serializable)snapshotId -> this.shouldClean$2((OffsetAndEpoch)snapshotId, snapshotSizes, snapshotTotalSize);
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable)x0$1 -> {
                    SeqOps seqOps;
                    if (x0$1 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)x0$1))) {
                        new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                            OffsetAndEpoch snapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                            OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                            if (snapshot != null && nextSnapshot != null) {
                                Option option = (Option)predicate.apply((Object)snapshot);
                                if (option instanceof Some) {
                                    SnapshotDeletionReason reason = (SnapshotDeletionReason)((Some)option).value();
                                    if (!this.deleteBeforeSnapshot(nextSnapshot, reason)) {
                                        throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                    }
                                } else {
                                    if (None$.MODULE$.equals(option)) {
                                        throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                                    }
                                    throw new MatchError((Object)option);
                                }
                                didClean$1.elem = true;
                                return BoxedUnit.UNIT;
                            }
                        }
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                });
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> forgetSnapshotsBefore(OffsetAndEpoch logStartSnapshotId) {
        TreeMap expiredSnapshots = (TreeMap)((MapOps)this.snapshots.until((Object)logStartSnapshotId)).clone();
        this.snapshots.$minus$minus$eq((IterableOnce)expiredSnapshots.keys());
        return expiredSnapshots;
    }

    private void removeSnapshots(TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots, SnapshotDeletionReason reason) {
        expiredSnapshots.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
                if (this.logger().underlying().isInfoEnabled()) {
                    String msgWithLogIdent_msg = reason.reason(snapshotId);
                    Object var4_4 = null;
                    this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
                }
                return Snapshots.markForDelete((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId);
            }
            throw new MatchError(null);
        });
        if (expiredSnapshots.nonEmpty()) {
            this.scheduler.scheduleOnce("delete-snapshot-files", () -> KafkaMetadataLog$.MODULE$.kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(this.log().dir().toPath(), expiredSnapshots), this.config.internalDeleteDelayMillis());
            return;
        }
    }

    public void close() {
        this.log().close();
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            ((IterableOnceOps)this.snapshots.values().flatten(Predef$.MODULE$.$conforms())).foreach((Function1 & Serializable)x$3 -> {
                x$3.close();
                return BoxedUnit.UNIT;
            });
            this.snapshots.clear();
            return;
        }
    }

    public int snapshotCount() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            int n = this.snapshots.size();
            return n;
        }
    }

    public static final /* synthetic */ int $anonfun$lastFetchedEpoch$1(KafkaMetadataLog $this, OffsetAndEpoch snapshotId) {
        long logEndOffset = $this.endOffset().offset();
        if (snapshotId.offset() == $this.startOffset() && snapshotId.offset() == logEndOffset) {
            return snapshotId.epoch();
        }
        throw new KafkaException("Log doesn't have a last fetch epoch and there is a snapshot (" + snapshotId + "). Expected the snapshot's end offset to match the log's end offset (" + logEndOffset + ") and the log start offset (" + $this.startOffset() + ")");
    }

    public static final /* synthetic */ String $anonfun$updateHighWatermark$1(long logHighWatermark$1, LogOffsetMetadata offsetMetadata$1) {
        return "Log's high watermark (" + logHighWatermark$1 + ") is different from the local replica's high watermark (" + offsetMetadata$1 + ")";
    }

    public static final /* synthetic */ String $anonfun$createNewSnapshot$1(KafkaMetadataLog $this, OffsetAndEpoch snapshotId$1) {
        return "Cannot create a snapshot with an id (" + snapshotId$1 + ") less than the log start offset (" + $this.startOffset() + ")";
    }

    public static final /* synthetic */ String $anonfun$readSnapshot$1(OffsetAndEpoch snapshotId$2, Path path$1) {
        return "Couldn't read " + snapshotId$2 + "; expected to find snapshot file " + path$1;
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Option liftedTree1$1(OffsetAndEpoch snapshotId$2) {
        try {
            void var2_2;
            Some snapshotReader = new Some((Object)FileRawSnapshotReader.open((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2));
            this.snapshots.put((Object)snapshotId$2, (Object)snapshotReader);
            return var2_2;
        }
        catch (NoSuchFileException noSuchFileException) {
            Path path = Snapshots.snapshotPath((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2);
            if (this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog.$anonfun$readSnapshot$1(snapshotId$2, path);
                Object var4_4 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            this.snapshots.remove((Object)snapshotId$2);
            return None$.MODULE$;
        }
    }

    public static final /* synthetic */ long $anonfun$readSnapshotTimestamp$1(KafkaMetadataLog $this, RawSnapshotReader reader) {
        return Snapshots.lastContainedLogTimestamp((RawSnapshotReader)reader, (LogContext)new LogContext($this.logIdent()));
    }

    public static final /* synthetic */ Option $anonfun$cleanSnapshotsRetentionMs$1(KafkaMetadataLog $this, long timestamp) {
        long now = $this.time.milliseconds();
        if (now - timestamp > $this.config.retentionMillis()) {
            return new Some((Object)new RetentionMsBreach(now, timestamp, $this.config.retentionMillis()));
        }
        return None$.MODULE$;
    }

    private final Option shouldClean$1(OffsetAndEpoch snapshotId) {
        return this.readSnapshotTimestamp(snapshotId).flatMap((Function1 & Serializable)timestamp -> KafkaMetadataLog.$anonfun$cleanSnapshotsRetentionMs$1(this, BoxesRunTime.unboxToLong((Object)timestamp)));
    }

    public static final /* synthetic */ Option $anonfun$cleanSnapshotsRetentionSize$1(KafkaMetadataLog $this, LongRef snapshotTotalSize$1, long snapshotSize) {
        long logSize = $this.log().size();
        if (logSize + snapshotTotalSize$1.elem > $this.config.retentionMaxBytes()) {
            long oldSnapshotTotalSize = snapshotTotalSize$1.elem;
            snapshotTotalSize$1.elem -= snapshotSize;
            return new Some((Object)new RetentionSizeBreach(logSize, oldSnapshotTotalSize, $this.config.retentionMaxBytes()));
        }
        return None$.MODULE$;
    }

    private final Option shouldClean$2(OffsetAndEpoch snapshotId, Map snapshotSizes$1, LongRef snapshotTotalSize$1) {
        return snapshotSizes$1.get((Object)snapshotId).flatMap((Function1 & Serializable)snapshotSize -> KafkaMetadataLog.$anonfun$cleanSnapshotsRetentionSize$1(this, snapshotTotalSize$1, BoxesRunTime.unboxToLong((Object)snapshotSize)));
    }

    public static final /* synthetic */ String $anonfun$removeSnapshots$2(SnapshotDeletionReason reason$1, OffsetAndEpoch snapshotId$4) {
        return reason$1.reason(snapshotId$4);
    }

    public KafkaMetadataLog(UnifiedLog log, Time time, Scheduler scheduler, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots, TopicPartition topicPartition, MetadataLogConfig config, int nodeId) {
        this.log = log;
        this.time = time;
        this.scheduler = scheduler;
        this.snapshots = snapshots;
        this.topicPartition = topicPartition;
        this.config = config;
        this.logIdent_$eq("[MetadataLog partition=" + topicPartition + ", nodeId=" + nodeId + "] ");
    }

    private static final class RetentionMsBreach
    implements SnapshotDeletionReason,
    Product,
    Serializable {
        private final long now;
        private final long timestamp;
        private final long retentionMillis;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long now() {
            return this.now;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long retentionMillis() {
            return this.retentionMillis;
        }

        @Override
        public String reason(OffsetAndEpoch snapshotId) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Marking snapshot " + snapshotId + " for deletion because its timestamp (" + this.timestamp() + ") is now (" + this.now() + ") older than the\n          |retention (" + this.retentionMillis() + ")"));
        }

        public RetentionMsBreach copy(long now, long timestamp, long retentionMillis) {
            return new RetentionMsBreach(now, timestamp, retentionMillis);
        }

        public long copy$default$1() {
            return this.now();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.retentionMillis();
        }

        public String productPrefix() {
            return "RetentionMsBreach";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.now());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.timestamp());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.retentionMillis());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RetentionMsBreach;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "now";
                }
                case 1: {
                    return "timestamp";
                }
                case 2: {
                    return "retentionMillis";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)"RetentionMsBreach".hashCode()), (int)Statics.longHash((long)this.now())), (int)Statics.longHash((long)this.timestamp())), (int)Statics.longHash((long)this.retentionMillis())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof RetentionMsBreach)) break block3;
                    RetentionMsBreach retentionMsBreach = (RetentionMsBreach)x$1;
                    if (this.now() != retentionMsBreach.now() || this.timestamp() != retentionMsBreach.timestamp() || this.retentionMillis() != retentionMsBreach.retentionMillis()) break block3;
                }
                return true;
            }
            return false;
        }

        public RetentionMsBreach(long now, long timestamp, long retentionMillis) {
            this.now = now;
            this.timestamp = timestamp;
            this.retentionMillis = retentionMillis;
            Product.$init$((Product)this);
        }
    }

    private static final class RetentionSizeBreach
    implements SnapshotDeletionReason,
    Product,
    Serializable {
        private final long logSize;
        private final long snapshotsSize;
        private final long retentionMaxBytes;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public long logSize() {
            return this.logSize;
        }

        public long snapshotsSize() {
            return this.snapshotsSize;
        }

        public long retentionMaxBytes() {
            return this.retentionMaxBytes;
        }

        @Override
        public String reason(OffsetAndEpoch snapshotId) {
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Marking snapshot " + snapshotId + " for deletion because the log size (" + this.logSize() + ") and snapshots size (" + this.snapshotsSize() + ")\n          |is greater than " + this.retentionMaxBytes()));
        }

        public RetentionSizeBreach copy(long logSize, long snapshotsSize, long retentionMaxBytes) {
            return new RetentionSizeBreach(logSize, snapshotsSize, retentionMaxBytes);
        }

        public long copy$default$1() {
            return this.logSize();
        }

        public long copy$default$2() {
            return this.snapshotsSize();
        }

        public long copy$default$3() {
            return this.retentionMaxBytes();
        }

        public String productPrefix() {
            return "RetentionSizeBreach";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.logSize());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.snapshotsSize());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.retentionMaxBytes());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RetentionSizeBreach;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "logSize";
                }
                case 1: {
                    return "snapshotsSize";
                }
                case 2: {
                    return "retentionMaxBytes";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)"RetentionSizeBreach".hashCode()), (int)Statics.longHash((long)this.logSize())), (int)Statics.longHash((long)this.snapshotsSize())), (int)Statics.longHash((long)this.retentionMaxBytes())), (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof RetentionSizeBreach)) break block3;
                    RetentionSizeBreach retentionSizeBreach = (RetentionSizeBreach)x$1;
                    if (this.logSize() != retentionSizeBreach.logSize() || this.snapshotsSize() != retentionSizeBreach.snapshotsSize() || this.retentionMaxBytes() != retentionSizeBreach.retentionMaxBytes()) break block3;
                }
                return true;
            }
            return false;
        }

        public RetentionSizeBreach(long logSize, long snapshotsSize, long retentionMaxBytes) {
            this.logSize = logSize;
            this.snapshotsSize = snapshotsSize;
            this.retentionMaxBytes = retentionMaxBytes;
            Product.$init$((Product)this);
        }
    }

    private static interface SnapshotDeletionReason {
        public String reason(OffsetAndEpoch var1);
    }
}

