/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.server.DelayedProduce$;
import kafka.server.DelayedProduceMetrics$;
import kafka.server.ProduceMetadata;
import kafka.server.ProducePartitionStatus;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.server.purgatory.DelayedOperation;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005%q!B\b\u0011\u0011\u0003)b!B\f\u0011\u0011\u0003A\u0002\"B\u0010\u0002\t\u0003\u0001\u0003bB\u0011\u0002\u0005\u0004%iA\t\u0005\u0007[\u0005\u0001\u000bQB\u0012\u0007\t]\u0001\u0002A\f\u0005\t\u0003\u0016\u0011\t\u0011)A\u0005\u0005\"AQ)\u0002B\u0001B\u0003%a\t\u0003\u0005J\u000b\t\u0005\t\u0015!\u0003K\u0011!iUA!A!\u0002\u0013q\u0005\"B\u0010\u0006\t\u00031\b\u0002C\u0011\u0006\u0011\u000b\u0007I\u0011\t\u0012\t\u000bq,A\u0011I?\t\u000f\u0005\rQ\u0001\"\u0011\u0002\u0006!9\u0011qA\u0003\u0005B\u0005\u0015\u0011A\u0004#fY\u0006LX\r\u001a)s_\u0012,8-\u001a\u0006\u0003#I\taa]3sm\u0016\u0014(\"A\n\u0002\u000b-\fgm[1\u0004\u0001A\u0011a#A\u0007\u0002!\tqA)\u001a7bs\u0016$\u0007K]8ek\u000e,7CA\u0001\u001a!\tQR$D\u0001\u001c\u0015\u0005a\u0012!B:dC2\f\u0017B\u0001\u0010\u001c\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!F\u0001\u0007Y><w-\u001a:\u0016\u0003\r\u0002\"\u0001J\u0016\u000e\u0003\u0015R!AJ\u0014\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005!J\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003)\n1aY8n\u0013\taSE\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!'\r)qf\u000f\t\u0003aej\u0011!\r\u0006\u0003eM\n\u0011\u0002];sO\u0006$xN]=\u000b\u0005E!$BA\n6\u0015\t1t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0005\u0019qN]4\n\u0005i\n$\u0001\u0005#fY\u0006LX\rZ(qKJ\fG/[8o!\tat(D\u0001>\u0015\tq$#A\u0003vi&d7/\u0003\u0002A{\t9Aj\\4hS:<\u0017a\u00023fY\u0006LXj\u001d\t\u00035\rK!\u0001R\u000e\u0003\t1{gnZ\u0001\u0010aJ|G-^2f\u001b\u0016$\u0018\rZ1uCB\u0011acR\u0005\u0003\u0011B\u0011q\u0002\u0015:pIV\u001cW-T3uC\u0012\fG/Y\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\t12*\u0003\u0002M!\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u0011Qr*U:\n\u0005A[\"!\u0003$v]\u000e$\u0018n\u001c82!\u0011\u0011VkV/\u000e\u0003MS!\u0001V\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002W'\n\u0019Q*\u00199\u0011\u0005a[V\"A-\u000b\u0005i#\u0014AB2p[6|g.\u0003\u0002]3\n\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0003=Bt!aX7\u000f\u0005\u0001\\gBA1k\u001d\t\u0011\u0017N\u0004\u0002dQ:\u0011AmZ\u0007\u0002K*\u0011a\rF\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!AN\u001c\n\u0005M)\u0014B\u0001.5\u0013\ta\u0017,\u0001\u0005sKF,Xm\u001d;t\u0013\tqw.A\bQe>$WoY3SKN\u0004xN\\:f\u0015\ta\u0017,\u0003\u0002re\n\t\u0002+\u0019:uSRLwN\u001c*fgB|gn]3\u000b\u00059|\u0007C\u0001\u000eu\u0013\t)8D\u0001\u0003V]&$H#B<ysj\\\bC\u0001\f\u0006\u0011\u0015\t%\u00021\u0001C\u0011\u0015)%\u00021\u0001G\u0011\u0015I%\u00021\u0001K\u0011\u0015i%\u00021\u0001O\u0003-!(/_\"p[BdW\r^3\u0015\u0003y\u0004\"AG@\n\u0007\u0005\u00051DA\u0004C_>dW-\u00198\u0002\u0019=tW\t\u001f9je\u0006$\u0018n\u001c8\u0015\u0003M\f!b\u001c8D_6\u0004H.\u001a;f\u0001")
public class DelayedProduce
extends DelayedOperation
implements Logging {
    private Logger logger;
    private final ProduceMetadata produceMetadata;
    private final ReplicaManager replicaManager;
    private final Function1<Map<TopicIdPartition, ProduceResponse.PartitionResponse>, BoxedUnit> responseCallback;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = DelayedProduce$.MODULE$.kafka$server$DelayedProduce$$logger();
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public boolean tryComplete() {
        this.produceMetadata.produceStatus().foreachEntry((Function2 & Serializable)(topicIdPartition, status) -> {
            DelayedProduce.$anonfun$tryComplete$1(this, topicIdPartition, status);
            return BoxedUnit.UNIT;
        });
        if (!this.produceMetadata.produceStatus().values().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.acksPending()))) {
            return this.forceComplete();
        }
        return false;
    }

    public void onExpiration() {
        this.produceMetadata.produceStatus().foreachEntry((Function2 & Serializable)(topicIdPartition, status) -> {
            DelayedProduce.$anonfun$onExpiration$1(this, topicIdPartition, status);
            return BoxedUnit.UNIT;
        });
    }

    public void onComplete() {
        Map responseStatus = (Map)this.produceMetadata.produceStatus().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition k = (TopicIdPartition)x0$1._1();
                ProducePartitionStatus status = (ProducePartitionStatus)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)status.responseStatus());
            }
            throw new MatchError(null);
        });
        this.responseCallback.apply((Object)responseStatus);
    }

    public static final /* synthetic */ void $anonfun$new$1(DelayedProduce $this, TopicIdPartition topicPartition, ProducePartitionStatus status) {
        Errors errors = status.responseStatus().error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            status.acksPending_$eq(true);
            status.responseStatus().error = Errors.REQUEST_TIMED_OUT;
        } else {
            status.acksPending_$eq(false);
        }
        $this.trace((Function0<String>)(Function0 & Serializable)() -> "Initial partition status for " + topicPartition + " is " + status);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$tryComplete$1(DelayedProduce $this, TopicIdPartition topicIdPartition, ProducePartitionStatus status) {
        $this.trace((Function0<String>)(Function0 & Serializable)() -> "Checking produce satisfaction for " + topicIdPartition + ", current status " + status);
        if (status.acksPending()) {
            void var6_6;
            void var7_7;
            Tuple2 tuple2;
            Either<Errors, Partition> either = $this.replicaManager.getPartitionOrError(topicIdPartition.topicPartition());
            if (either instanceof Left) {
                Errors err = (Errors)((Left)either).value();
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)err);
            } else if (either instanceof Right) {
                tuple2 = ((Partition)((Right)either).value()).checkEnoughReplicasReachOffset(status.requiredOffset());
            } else {
                throw new MatchError(either);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            boolean hasEnough = tuple22._1$mcZ$sp();
            Errors error = (Errors)tuple22._2();
            void v1 = var7_7;
            Errors errors = Errors.NONE;
            if ((v1 != null ? !v1.equals(errors) : errors != null) || var6_6 != false) {
                status.acksPending_$eq(false);
                status.responseStatus().error = var7_7;
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$onExpiration$1(DelayedProduce $this, TopicIdPartition topicIdPartition, ProducePartitionStatus status) {
        if (status.acksPending()) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> "Expiring produce request for partition " + topicIdPartition + " with status " + status);
            DelayedProduceMetrics$.MODULE$.recordExpiration(topicIdPartition.topicPartition());
            return;
        }
    }

    public DelayedProduce(long delayMs, ProduceMetadata produceMetadata, ReplicaManager replicaManager, Function1<Map<TopicIdPartition, ProduceResponse.PartitionResponse>, BoxedUnit> responseCallback) {
        this.produceMetadata = produceMetadata;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(delayMs);
        produceMetadata.produceStatus().foreachEntry((Function2 & Serializable)(topicPartition, status) -> {
            DelayedProduce.$anonfun$new$1(this, topicPartition, status);
            return BoxedUnit.UNIT;
        });
    }
}

