/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import oracle.jdbc.AccessToken;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.diagnostics.DefaultTraceEventListenerProvider;
import oracle.jdbc.driver.DefaultJsonProvider;
import oracle.jdbc.spi.AccessTokenProvider;
import oracle.jdbc.spi.ConnectionStringProvider;
import oracle.jdbc.spi.JsonProvider;
import oracle.jdbc.spi.OracleResourceProvider;
import oracle.jdbc.spi.OsonConverter;
import oracle.jdbc.spi.PasswordProvider;
import oracle.jdbc.spi.TlsConfigurationProvider;
import oracle.jdbc.spi.TraceEventListenerProvider;
import oracle.jdbc.spi.UsernameProvider;

public final class ResourceType<T extends OracleResourceProvider, U> {
    public static final ResourceType<ConnectionStringProvider, String> CONNECTION_STRING;
    public static final ResourceType<UsernameProvider, String> USERNAME;
    public static final ResourceType<PasswordProvider, char[]> PASSWORD;
    public static final ResourceType<AccessTokenProvider, AccessToken> ACCESS_TOKEN;
    public static final ResourceType<TlsConfigurationProvider, SSLContext> TLS_CONFIGURATION;
    public static final ResourceType<TraceEventListenerProvider, TraceEventListener> TRACE_EVENT_LISTENER;
    public static final ResourceType<JsonProvider, OsonConverter> JSON_PROVIDER;
    private static final Collection<ResourceType<?, ?>> ALL_TYPES;
    private final String providerNameProperty;
    private final String defaultProviderName;
    private final FutureTask<T> defaultProviderConstructorTask;
    private final Class<T> providerClass;
    private final BiFunction<T, Map<OracleResourceProvider.Parameter, CharSequence>, U> getResourceFunction;

    public static Collection<ResourceType<?, ?>> allTypes() {
        return ALL_TYPES;
    }

    private ResourceType(String providerNameProperty, Class<T> providerClass, BiFunction<T, Map<OracleResourceProvider.Parameter, CharSequence>, U> getResourceFunction) {
        this(providerNameProperty, providerClass, getResourceFunction, null, () -> null);
    }

    private ResourceType(String providerNameProperty, Class<T> providerClass, BiFunction<T, Map<OracleResourceProvider.Parameter, CharSequence>, U> getResourceFunction, String defaultProviderName, Callable<T> defaultProviderSupplier) {
        this.providerNameProperty = providerNameProperty;
        this.defaultProviderName = defaultProviderName;
        this.providerClass = providerClass;
        this.getResourceFunction = getResourceFunction;
        this.defaultProviderConstructorTask = new FutureTask<T>(defaultProviderSupplier);
    }

    String getProviderNameProperty() {
        return this.providerNameProperty;
    }

    String getDefaultProviderName() {
        return this.defaultProviderName;
    }

    T getDefaultProvider() throws Exception {
        this.defaultProviderConstructorTask.run();
        return (T)((OracleResourceProvider)this.defaultProviderConstructorTask.get());
    }

    public Class<T> getProviderClass() {
        return this.providerClass;
    }

    public U getResource(T provider, Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        return this.getResourceFunction.apply(provider, parameterValues);
    }

    static {
        ArrayList<ResourceType<OracleResourceProvider, Object>> allTypes = new ArrayList<ResourceType<OracleResourceProvider, Object>>(6);
        CONNECTION_STRING = new ResourceType<ConnectionStringProvider, String>("oracle.jdbc.provider.connectionString", ConnectionStringProvider.class, ConnectionStringProvider::getConnectionString);
        allTypes.add(CONNECTION_STRING);
        USERNAME = new ResourceType<UsernameProvider, String>("oracle.jdbc.provider.username", UsernameProvider.class, UsernameProvider::getUsername);
        allTypes.add(USERNAME);
        PASSWORD = new ResourceType<PasswordProvider, char[]>("oracle.jdbc.provider.password", PasswordProvider.class, PasswordProvider::getPassword);
        allTypes.add(PASSWORD);
        ACCESS_TOKEN = new ResourceType<AccessTokenProvider, AccessToken>("oracle.jdbc.provider.accessToken", AccessTokenProvider.class, AccessTokenProvider::getAccessToken);
        allTypes.add(ACCESS_TOKEN);
        TLS_CONFIGURATION = new ResourceType<TlsConfigurationProvider, SSLContext>("oracle.jdbc.provider.tlsConfiguration", TlsConfigurationProvider.class, TlsConfigurationProvider::getSSLContext);
        allTypes.add(TLS_CONFIGURATION);
        TRACE_EVENT_LISTENER = new ResourceType<TraceEventListenerProvider, TraceEventListener>("oracle.jdbc.provider.traceEventListener", TraceEventListenerProvider.class, TraceEventListenerProvider::getTraceEventListener, "ojdbc-default-trace-event-listener-provider", DefaultTraceEventListenerProvider::new);
        allTypes.add(TRACE_EVENT_LISTENER);
        JSON_PROVIDER = new ResourceType<JsonProvider, OsonConverter>("oracle.jdbc.provider.json", JsonProvider.class, JsonProvider::getOsonConverter, "ojdbc-default-json-provider", DefaultJsonProvider::new);
        allTypes.add(JSON_PROVIDER);
        ALL_TYPES = Collections.unmodifiableList(allTypes);
    }
}

