/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class BOMInputStream
extends InputStream {
    private final PushbackInputStream pushbackInputStream;
    private final BOM bom;

    public BOMInputStream(InputStream inputStream) throws NullPointerException, IOException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.pushbackInputStream = new PushbackInputStream(inputStream, 4);
        byte[] bom = new byte[4];
        int read = this.pushbackInputStream.read(bom);
        switch (read) {
            case 4: {
                if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
                    this.bom = BOM.UTF_32_LE;
                    break;
                }
                if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
                    this.bom = BOM.UTF_32_BE;
                    break;
                }
            }
            case 3: {
                if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                    this.bom = BOM.UTF_8;
                    break;
                }
            }
            case 2: {
                if (bom[0] == -1 && bom[1] == -2) {
                    this.bom = BOM.UTF_16_LE;
                    break;
                }
                if (bom[0] == -2 && bom[1] == -1) {
                    this.bom = BOM.UTF_16_BE;
                    break;
                }
            }
            default: {
                this.bom = BOM.NONE;
            }
        }
        if (read > 0) {
            this.pushbackInputStream.unread(bom, 0, read);
        }
        if (this.bom != BOM.NONE) {
            this.pushbackInputStream.skip(this.bom.bytes.length);
        }
    }

    @Override
    public int read() throws IOException {
        return this.pushbackInputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException, NullPointerException {
        return this.pushbackInputStream.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException, NullPointerException {
        return this.pushbackInputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.pushbackInputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.pushbackInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.pushbackInputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.pushbackInputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.pushbackInputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.pushbackInputStream.markSupported();
    }

    public static final class BOM {
        public static final BOM NONE = new BOM(new byte[0], "NONE");
        public static final BOM UTF_8 = new BOM(new byte[]{-17, -69, -65}, "UTF-8");
        public static final BOM UTF_16_LE = new BOM(new byte[]{-1, -2}, "UTF-16 little-endian");
        public static final BOM UTF_16_BE = new BOM(new byte[]{-2, -1}, "UTF-16 big-endian");
        public static final BOM UTF_32_LE = new BOM(new byte[]{-1, -2, 0, 0}, "UTF-32 little-endian");
        public static final BOM UTF_32_BE = new BOM(new byte[]{0, 0, -2, -1}, "UTF-32 big-endian");
        private final byte[] bytes;
        private final String description;

        public String toString() {
            return this.description;
        }

        public byte[] getBytes() {
            byte[] result = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, result, 0, this.bytes.length);
            return result;
        }

        private BOM(byte[] bom, String description) {
            this.bytes = bom;
            this.description = description;
        }
    }
}

