/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.io;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLRuntimeException;
import org.opensaml.core.xml.io.Marshaller;
import org.slf4j.Logger;

public class MarshallerFactory {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MarshallerFactory.class);
    @Nonnull
    private final Map<QName, Marshaller> marshallers = new ConcurrentHashMap<QName, Marshaller>();

    @Nullable
    public Marshaller getMarshaller(@Nonnull QName key) {
        return this.marshallers.get(key);
    }

    @Nullable
    public Marshaller getMarshaller(@Nonnull XMLObject xmlObject) {
        Marshaller marshaller = null;
        QName xsitype = xmlObject.getSchemaType();
        if (xsitype != null) {
            marshaller = this.getMarshaller(xsitype);
        }
        if (marshaller == null) {
            marshaller = this.getMarshaller(xmlObject.getElementQName());
        }
        return marshaller;
    }

    @Nonnull
    public Marshaller ensureMarshaller(@Nonnull QName key) {
        Marshaller m = this.getMarshaller(key);
        if (m != null) {
            return m;
        }
        throw new XMLRuntimeException("Unable to obtain marshaller for " + key.toString());
    }

    @Nonnull
    public Marshaller ensureMarshaller(@Nonnull XMLObject xmlObject) {
        Marshaller m = this.getMarshaller(xmlObject);
        if (m != null) {
            return m;
        }
        throw new XMLRuntimeException("Unable to obtain marshaller for " + xmlObject.getClass().getName());
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<QName, Marshaller> getMarshallers() {
        return CollectionSupport.copyToMap(this.marshallers);
    }

    public void registerMarshaller(@Nonnull QName key, @Nonnull Marshaller marshaller) {
        Constraint.isNotNull(key, "Marshaller key cannot be null");
        Constraint.isNotNull(marshaller, "Marshaller cannot be null");
        this.log.debug("Registering marshaller, {}, for object type {}", (Object)marshaller.getClass().getName(), (Object)key);
        this.marshallers.put(key, marshaller);
    }

    @Nullable
    public Marshaller deregisterMarshaller(@Nonnull QName key) {
        this.log.debug("Deregistering marshaller for object type {}", (Object)key);
        return this.marshallers.remove(key);
    }
}

