#  
# WebDyne docker image
#
# ====
#
# Override with --build-arg
#
ARG BASE=perl:latest
ARG PORT=8080
ARG WORKERS=8


# Default paths
#
ARG PERL_CARTON_PATH="/opt/webdyne"
ARG DOCUMENT_ROOT="/app"


# ====
#
# Build stages
#


# Use arg base builder
#
FROM ${BASE} AS builder


# Redeclare ARGS
#
ARG PERL_CARTON_PATH


# Install build tools and core Perl modules
#

# Nothing to do everything installed



#  Install Carton
#
RUN cpanm --notest Carton


# Set up environment for local::lib
#
RUN echo "PATH ${PATH} $PATH"
ENV PERL_CARTON_PATH=${PERL_CARTON_PATH}
ENV PERL_LOCAL_LIB_ROOT=${PERL_CARTON_PATH}
ENV PERL_MB_OPT="--install_base ${PERL_CARTON_PATH}"
ENV PERL_MM_OPT="INSTALL_BASE=${PERL_CARTON_PATH}"
ENV PERL5LIB=${PERL_CARTON_PATH}/lib/perl5
ENV PATH=${PERL_CARTON_PATH}/bin:$PATH


# Set up app
#
WORKDIR /app


# Checkout Webdyne. Used if cloning
#
#RUN git clone -b development --single-branch https://github.com/aspeer/WebDyne.git pm-WebDyne
#WORKDIR pm-WebDyne


#  Otherwise copy working repo content
#
COPY . .


# And now install CPAN modules using Carton
#
WORKDIR docker.template
COPY docker/cpanfile docker/cpanfile.snapshot ./
RUN carton install --deployment


# Now install main WebDyne module
#
WORKDIR ..
RUN carton exec -- cpanm --local-lib-contained=${PERL_CARTON_PATH} .


# Load in digest file. Should be done by carton when Makefile.PL run but doesn't work
# for some reason so create manually as a backup
#
RUN git rev-parse --short HEAD > $PERL5LIB/WebDyne.pm.sha


# Debug
#
RUN find ${PERL_CARTON_PATH} | grep WebDyne.pm


# Clean carton cache and create empty webdyne cache dir
#
RUN rm -rf ${PERL_CARTON_PATH}/cache &&  mkdir ${PERL_CARTON_PATH}/cache


# ====================================================================================================
#
# Now generate main image from builder image
#
FROM ${BASE} as runtime


# Republish args
#
ARG PERL_CARTON_PATH
ARG PORT
ARG DOCUMENT_ROOT
ARG BASE


#  Republish labels
#
ARG LABEL_MAINTAINER="Andrew Speer <andrew.speer@isolutions.com.au>"
ARG LABEL_TITLE="WebDyne"
ARG LABEL_DESCRIPTION="PSGI web service for generating dynamic HTML pages with embedded Perl"
ARG LABEL_URL="https://github.com/aspeer/WebDyne"
ARG LABEL_SOURCE="https://github.com/aspeer/WebDyne.git"
ARG LABEL_DOCUMENTATION="https://webdyne.org/"
ARG LABEL_AUTHORS="Andrew Speer <andrew.speer@isolutions.com.au>"
ARG LABEL_LICENSES="Artistic-1.0-Perl OR GPL-1.0-or-later"
ARG LABEL_CREATED
ARG LABEL_VERSION
ARG LABEL_REVISION
ARG BASE=${BASE}


# Add Labels into meta for image
#
LABEL maintainer=${LABEL_MAINTAINER} \
    org.opencontainers.image.title=${LABEL_TITLE} \
    org.opencontainers.image.description=${LABEL_DESCRIPTION} \
    org.opencontainers.image.url=${LABEL_URL} \
    org.opencontainers.image.source=${LABEL_SOURCE} \
    org.opencontainers.image.documentation=${LABEL_DOCUMENTATION} \
    org.opencontainers.image.authors=${LABEL_AUTHORS} \
    org.opencontainers.image.licenses=${LABEL_LICENSES} \
    org.opencontainers.image.created=${LABEL_CREATED} \
    org.opencontainers.image.version=${LABEL_VERSION} \
    org.opencontainers.image.revision=${LABEL_REVISION} \
    org.opencontainers.image.base=${BASE}


# Install build tools and core Perl modules
#

#  No extra packages needed



# Install Carton
#
RUN cpanm --notest Carton


# Set up environment for local::lib
#
ENV PERL_CARTON_PATH=${PERL_CARTON_PATH}
ENV PERL5LIB=${PERL_CARTON_PATH}/lib/perl5
ENV PATH=${PERL_CARTON_PATH}/bin:$PATH


# Only psp files go into /app, WebDyne perl modules installed into $PERL_CARTONPATH (/opt/webdyne) 
# by default
#
WORKDIR /app


# Copy CPAN modules from builder + example file
#
COPY --from=builder ${PERL_CARTON_PATH} ${PERL_CARTON_PATH}
COPY docker/app.psp .


# Expose port (default 8080)
#
EXPOSE ${PORT}


# Set document root environment var to the server_time example
#
ENV DOCUMENT_ROOT=${DOCUMENT_ROOT}


# WebDyne environment vars
#
ENV WEBDYNE_CACHE_DN=${PERL_CARTON_PATH}/cache


# Entrypoint script for starting process. Kicks off starman on ${PORT}
#
COPY docker/entrypoint.sh /usr/local/bin
ENTRYPOINT ["/usr/local/bin/entrypoint.sh"]


# Empty cmd, entrypoint script runs "starman --port ${PORT} ${PERL_CARTON_PATH}/bin/webdyne.psgi ${DOCUMENT_ROOT}"
#
CMD []