# This file was autogenerated.
use 5.008001;
use strict;
use warnings;
no warnings qw( void once );
use Hydrogen ();

package Hydrogen::Topic::Scalar;

our $AUTHORITY = 'cpan:TOBYINK';
our $VERSION   = '0.021000';

=head1 NAME

Hydrogen::Topic::Scalar - functions from Hydrogen::Scalar applied to C<$_>

=head1 VERSION

This documentation is for Hydrogen::Topic::Scalar 0.021000,
which is based on Sub::HandlesVia::HandlerLibrary::Scalar 0.050003.

=cut

=head1 FUNCTIONS

Each function implicitly operates on C<< $_ >>, expecting it to be a scalar.

=cut

use Exporter::Shiny qw(
    get
    make_getter
    make_setter
    set
    stringify
);

=head2 C<< get() >>

Operates on C<< $_ >>, which must be a scalar.

Gets the current value of the scalar.

=cut

sub get {

    package Hydrogen::Scalar::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for get; usage: "
          . "Hydrogen::Topic::Scalar::get()" );
    $_;
}

=head2 C<< make_getter() >>

Operates on C<< $_ >>, which must be a scalar.

Returns a getter coderef.

=cut

sub make_getter {

    package Hydrogen::Scalar::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for make_getter; usage: "
          . "Hydrogen::Topic::Scalar::make_getter()" );
    my $s = $_;
    sub { unshift @_, $s; $_ }
}

=head2 C<< make_setter() >>

Operates on C<< $_ >>, which must be a scalar.

Returns a setter coderef.

=cut

sub make_setter {

    package Hydrogen::Scalar::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for make_setter; usage: "
          . "Hydrogen::Topic::Scalar::make_setter()" );
    my $s = $_;
    sub { my $val = shift; unshift @_, $s; ( $_ = $val ) }
}

=head2 C<< set( $value ) >>

Operates on C<< $_ >>, which must be a scalar.

Sets the scalar to a new value.

=cut

sub set {

    package Hydrogen::Scalar::__SANDBOX__;
    @_ == 1
      or Hydrogen::croak( "Wrong number of parameters for set; usage: "
          . "Hydrogen::Topic::Scalar::set( \$value )" );
    ( $_ = $_[0] );
}

=head2 C<< stringify() >>

Operates on C<< $_ >>, which must be a scalar.

Gets the current value of the scalar, but as a string.

=cut

sub stringify {

    package Hydrogen::Scalar::__SANDBOX__;
    @_ == 0
      or Hydrogen::croak( "Wrong number of parameters for stringify; usage: "
          . "Hydrogen::Topic::Scalar::stringify()" );
    do { my $shv_tmp = $_; sprintf q(%s), $shv_tmp; }
}

1;

=head1 EXPORT

No functions are exported by this module by default. To import them all (this is usually a bad idea), use:

    use Hydrogen::Topic::Scalar -all;

To import a particular function, use:

    use Hydrogen::Topic::Scalar 'make_setter';

To rename functions:

    use Hydrogen::Topic::Scalar 'make_setter' => { -as => 'myfunc' };

On Perl 5.37.2+ (or if L<Lexical::Sub> is installed) you can import lexically:

    use Hydrogen::Topic::Scalar -lexical, 'make_setter';

See L<Exporter::Tiny::Manual::Importing> for more hints on importing.

=head1 BUGS

Please report any bugs to
L<http://github.com/tobyink/p5-hydrogen/issues>.

=head1 SEE ALSO

L<Hydrogen>,
L<Hydrogen::Scalar>,
L<Hydrogen::Curry::Scalar>,
L<Sub::HandlesVia::HandlerLibrary::Scalar>.

=head1 AUTHOR

Toby Inkster E<lt>tobyink@cpan.orgE<gt>.

=head1 COPYRIGHT AND LICENCE

This software is copyright (c) 2022-2025 by Toby Inkster.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 DISCLAIMER OF WARRANTIES

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

