/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gnu.trove;

import java.io.Serializable;
import org.jetbrains.kotlin.gnu.trove.HashFunctions;
import org.jetbrains.kotlin.gnu.trove.TByteProcedure;

public class TByteArrayList
implements Serializable,
Cloneable {
    protected transient byte[] _data;
    protected transient int _pos;

    public void ensureCapacity(int capacity) {
        if (this._data == null) {
            this._data = new byte[Math.max(4, capacity)];
        }
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            byte[] tmp = new byte[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public void add(byte val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public Object clone() {
        TByteArrayList clone = null;
        try {
            clone = (TByteArrayList)super.clone();
            clone._data = this._data == null ? null : (byte[])this._data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public byte[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public byte[] toNativeArray(int offset2, int len) {
        byte[] rv = new byte[len];
        this.toNativeArray(rv, offset2, len);
        return rv;
    }

    public void toNativeArray(byte[] dest, int offset2, int len) {
        if (len == 0) {
            return;
        }
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        System.arraycopy(this._data, offset2, dest, 0, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TByteArrayList) {
            TByteArrayList that = (TByteArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data[i] == that._data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i = this._pos;
        while (i-- > 0) {
            h += HashFunctions.hash(this._data[i]);
        }
        return h;
    }

    public boolean forEach(TByteProcedure procedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        final StringBuffer buf = new StringBuffer("{");
        this.forEach(new TByteProcedure(){

            public boolean execute(byte val) {
                buf.append(val);
                buf.append(", ");
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }
}

